/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.dialogs;

import br.gov.serpro.gcap.acoes.VerificarPendenciasAction;
import br.gov.serpro.gcap.app.ConstantesImpressaoIf;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacaoBem;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.componente.JCustomTabbedPane;
import br.gov.serpro.gcap.gui.componente.JEditLabel;
import br.gov.serpro.gcap.gui.componente.JTituloForaPanel;
import br.gov.serpro.gcap.gui.componente.JTituloPanel;
import br.gov.serpro.gcap.gui.dialogs.ListModelMesesDarf;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.impressao.ImpressaoDarf;
import br.gov.serpro.gcap.impressao.RelatorioDarf;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.observador.ObservadorTela;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.persistenciagenerica.HashInvalidoException;

public class PainelSelecionarImpressaoDarf
extends JPanel
implements ConstantesImpressaoIf {
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JEditLogico edtBens;
    private JEditLogico edtMeses;
    private JEditLogico edtSelecionarImpressao;
    private JTituloPanel gcapTitledPanel1;
    private JTituloPanel gcapTitledPanel2;
    private JTituloPanel gcapTitledPanel3;
    private JTituloForaPanel jTituloForaPanel1;
    private JTituloForaPanel jTituloForaPanel2;
    private JEditLabel lblAtencaoImpressao;
    private JEditLabel lblCpf;
    private JEditLabel lblCpfSelecionado;
    private JEditLabel lblMeses;
    private JList lstBensImoveis;
    private JList lstBensMoveis;
    private JList lstMeses;
    private JList lstPSocietarias;
    private JPanel pnlBensImoveis;
    private JPanel pnlBensMoveis;
    private JPanel pnlBotoes;
    private JPanel pnlPSocietarias;
    private JScrollPane scrollBensImoveis;
    private JScrollPane scrollBensMoveis;
    private JScrollPane scrollMeses;
    private JScrollPane scrollPSocietarias;
    private JTabbedPane tabBens;
    private static final long serialVersionUID = 1L;
    private DemonstrativoGCAP[] arrayDemonstrativos;
    private int[][] bensSelecionados = new int[3][];
    private ListModelMesesDarf listModelMeses;
    private VerificarPendenciasAction verificarPendencias = new VerificarPendenciasAction();
    private VerificarPendenciasAction.PendenciasDemonstrativo pendenciasDemonstrativo;

    public PainelSelecionarImpressaoDarf() {
        this.initComponents();
        this.inibirEnterNavegacaoFocoBotoes();
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.btnAjuda.setFocusTraversalKeys(0, set);
        this.btnCancelar.setFocusTraversalKeys(0, set);
        this.btnOk.setFocusTraversalKeys(0, set);
    }

    public PainelSelecionarImpressaoDarf(DemonstrativoGCAP[] pDdemonstrativos) {
        this.arrayDemonstrativos = pDdemonstrativos;
        this.listModelMeses = new ListModelMesesDarf();
        this.initComponents();
        this.lblAtencaoImpressao.setText(MensagemUtil.getMensagem("vencimentodardiautil"));
        this.edtMeses.setBackground(Color.WHITE);
        this.edtBens.setBackground(Color.WHITE);
        this.edtSelecionarImpressao.setBackground(Color.WHITE);
        Logico selecaoRelatorio = new Logico();
        selecaoRelatorio.addOpcao("VISUALIZAR", "Visualizar");
        selecaoRelatorio.addOpcao("PDF", "Gerar imagem PDF");
        selecaoRelatorio.addOpcao("IMPRIMIR", "Imprimir");
        selecaoRelatorio.setConteudo("VISUALIZAR");
        this.edtSelecionarImpressao.setInformacao((Informacao)selecaoRelatorio);
        Logico opcaoTodosOuSelecionados = new Logico();
        opcaoTodosOuSelecionados.addOpcao("TODOS", "Todos");
        opcaoTodosOuSelecionados.addOpcao("SELECIONADOS", "Um ou mais");
        opcaoTodosOuSelecionados.setConteudo("TODOS");
        this.edtBens.setInformacao((Informacao)opcaoTodosOuSelecionados);
        this.setHabilitadoListaBensParaSelecao(false);
        opcaoTodosOuSelecionados = new Logico();
        opcaoTodosOuSelecionados.addOpcao("TODOS", "Todos");
        opcaoTodosOuSelecionados.addOpcao("SELECIONADOS", "Um ou mais");
        opcaoTodosOuSelecionados.setConteudo("TODOS");
        this.edtMeses.setInformacao((Informacao)opcaoTodosOuSelecionados);
        this.edtMeses.getInformacao().setReadOnly(true);
        if (pDdemonstrativos.length == 1) {
            String cpfDeclarante = GCAPFacade.getInstancia().getDeclaracao().getIdDemonstrativo().getCpf().formatado();
            this.lblCpf.setText(cpfDeclarante);
            this.carregarListasDeBensDemonstrativo(pDdemonstrativos[0]);
        } else {
            JRadioButton selecionados = (JRadioButton)this.edtBens.getRadios().get("Um ou mais");
            selecionados.setEnabled(false);
            this.zerarListas();
        }
        this.adicionarObservadores();
        this.edtMeses.getInformacao().setConteudo("TODOS");
        this.edtMeses.getInformacao().setReadOnly(false);
        this.filtraMesesQueContemDarf(null, null, null);
        this.edtBens.getInformacao().setConteudo("TODOS");
        this.edtMeses.setBackground(Color.WHITE);
        this.atualizaHelp("VISUALIZAR");
        this.inibirEnterNavegacaoFocoBotoes();
    }

    private void atualizaHelp(String opcaoSaidaRelatorio) {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Como fazer para.../... Imprimir Darf");
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, "Como fazer para.../... Imprimir Darf");
    }

    private void adicionarObservadores() {
        this.adicionaObservadorTipoRelatorio();
        this.adicionaObservadorMeses();
        this.adicionaObservadorBens();
    }

    private void adicionaObservadorBens() {
        ObservadorTela lObservadorBens = new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Logico opcao = (Logico)observado;
                if (opcao.asString().equals("SELECIONADOS")) {
                    PainelSelecionarImpressaoDarf.this.setHabilitadoListaBensParaSelecao(true);
                }
                if (opcao.asString().equals("TODOS")) {
                    PainelSelecionarImpressaoDarf.this.setHabilitadoListaBensParaSelecao(false);
                }
                PainelSelecionarImpressaoDarf.this.atualizarListaMesesDisponiveisPorBensSelecionados(PainelSelecionarImpressaoDarf.this.bensSelecionados);
            }
        };
        this.edtBens.getInformacao().addObservador((Observador)lObservadorBens);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        String opcaoSaidaRelatorio = this.edtSelecionarImpressao.getInformacao().asString();
        if ("IMPRIMIR".equals(opcaoSaidaRelatorio) && !GuiUtil.mostrarConfirma(null, "Se houver uma impressora instalada, a impress\u00e3o ser\u00e1 enviada diretamente para ela, confirma a impress\u00e3o?")) {
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        GuiUtil.fecharDialog(this);
        this.imprimir();
        this.setCursor(cursor);
    }

    private void lstBensImoveisValueChanged(ListSelectionEvent evt) {
        this.bensSelecionados[0] = ((JList)evt.getSource()).getSelectedIndices();
        this.atualizarListaMesesDisponiveisPorBensSelecionados(this.bensSelecionados);
    }

    private void lstBensMoveisValueChanged(ListSelectionEvent evt) {
        this.bensSelecionados[1] = ((JList)evt.getSource()).getSelectedIndices();
        this.atualizarListaMesesDisponiveisPorBensSelecionados(this.bensSelecionados);
    }

    private void lstPSocietariasValueChanged(ListSelectionEvent evt) {
        this.bensSelecionados[2] = ((JList)evt.getSource()).getSelectedIndices();
        this.atualizarListaMesesDisponiveisPorBensSelecionados(this.bensSelecionados);
    }

    private void adicionaObservadorMeses() {
        ObservadorTela lObservadorMeses = new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                String escolhaMesesUsuario = PainelSelecionarImpressaoDarf.this.edtMeses.getInformacao().asString();
                if ("SELECIONADOS".equals(escolhaMesesUsuario)) {
                    PainelSelecionarImpressaoDarf.this.lstMeses.setEnabled(true);
                } else {
                    PainelSelecionarImpressaoDarf.this.lstMeses.setEnabled(false);
                }
            }
        };
        this.edtMeses.getInformacao().addObservador((Observador)lObservadorMeses);
    }

    private void obterMesesPagamentoPrazoBensImoveis(List<AlienacaoBemImovel> listaBens, Map<Integer, Integer> mesesComPagamento) {
        for (AlienacaoBemImovel bem : listaBens) {
            if (bem.isAlienacaoAPrazo()) {
                List listaCPGC = bem.getColecaoParcelaAlienacao().itens();
                for (int i = 0; i < listaCPGC.size(); ++i) {
                    boolean dataValida;
                    ParcelaAlienacaoBem cpgc = (ParcelaAlienacaoBem)((Object)listaCPGC.get(i));
                    boolean bl = dataValida = cpgc.getDataRecebimento().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() < 3;
                    if (cpgc.getImpostoDevido().isVazio() || !dataValida) continue;
                    mesesComPagamento.put(Integer.valueOf(cpgc.getDataRecebimento().getMes()) - 1, Integer.valueOf(cpgc.getDataRecebimento().getMes()) - 1);
                }
            }
            Data dataConsiderada = null;
            dataConsiderada = String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS).equals(bem.getNatureza().naoFormatado()) && bem.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals("1") ? bem.getDataTransitoJulgado() : bem.getDataAlienacao();
            if (!bem.isAlienacaoAVista() || bem.isIsento() || dataConsiderada.getMes().trim().length() <= 0) continue;
            int mesDarf = Integer.valueOf(dataConsiderada.getMes());
            mesesComPagamento.put(mesDarf - 1, mesDarf - 1);
        }
    }

    private void obterMesesPagamentoPrazoBensMoveis(List<AlienacaoBemMovel> listaBens, Map<Integer, Integer> mesesComPagamento) {
        for (AlienacaoBemMovel bem : listaBens) {
            if (bem.isAlienacaoAPrazo()) {
                List listaCPGC = bem.getColecaoParcelaAlienacao().itens();
                for (int i = 0; i < listaCPGC.size(); ++i) {
                    boolean dataValida;
                    ParcelaAlienacaoBem cpgc = (ParcelaAlienacaoBem)((Object)listaCPGC.get(i));
                    boolean bl = dataValida = cpgc.getDataRecebimento().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() < 3;
                    if (cpgc.getImpostoDevido().isVazio() || !dataValida) continue;
                    mesesComPagamento.put(Integer.valueOf(cpgc.getDataRecebimento().getMes()) - 1, Integer.valueOf(cpgc.getDataRecebimento().getMes()) - 1);
                }
            }
            Data dataConsiderada = null;
            dataConsiderada = String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS).equals(bem.getNatureza().naoFormatado()) && bem.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals("1") ? bem.getDataTransitoJulgado() : bem.getDataAlienacao();
            if (!bem.isAlienacaoAVista() || bem.isIsento() || dataConsiderada.getMes().trim().length() <= 0) continue;
            int mesDarf = Integer.valueOf(dataConsiderada.getMes());
            mesesComPagamento.put(mesDarf - 1, mesDarf - 1);
        }
    }

    private void obterMesesPagamentoPrazoParticipacaoSoc(List<AlienacaoParticipacaoSocietaria> listaBens, Map<Integer, Integer> mesesComPagamento) {
        for (AlienacaoParticipacaoSocietaria partSoc : listaBens) {
            if (partSoc.isAlienacaoAPrazo()) {
                List listaCPGC = partSoc.getColecaoParcelaAlienacao().itens();
                for (int i = 0; i < listaCPGC.size(); ++i) {
                    boolean dataValida;
                    ParcelaAlienacao cpgc = (ParcelaAlienacao)((Object)listaCPGC.get(i));
                    boolean bl = dataValida = cpgc.getDataRecebimento().validar().getPrimeiroRetornoValidacaoMaisSevero().getSeveridade() < 3;
                    if (cpgc.getImpostoDevido().isVazio() || !dataValida) continue;
                    mesesComPagamento.put(Integer.valueOf(cpgc.getDataRecebimento().getMes()) - 1, Integer.valueOf(cpgc.getDataRecebimento().getMes()));
                }
            }
            Data dataConsiderada = null;
            dataConsiderada = String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS).equals(partSoc.getNatureza().naoFormatado()) && partSoc.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals("1") ? partSoc.getDataTransitoJulgado() : partSoc.getDataAlienacao();
            if (!partSoc.isAlienacaoAVista() || partSoc.isIsento() || dataConsiderada.getMes().trim().length() <= 0) continue;
            int mesDarf = Integer.valueOf(dataConsiderada.getMes());
            mesesComPagamento.put(mesDarf - 1, mesDarf - 1);
        }
    }

    private void filtraMesesQueContemDarf(List<AlienacaoBemImovel> pListaBensImoveis, List<AlienacaoBemMovel> pListaBensMoveis, List<AlienacaoParticipacaoSocietaria> pListaBensPS) {
        this.listModelMeses.zerarMeses();
        if (this.arrayDemonstrativos.length == 1) {
            DemonstrativoGCAP demonstrativo = this.arrayDemonstrativos[0];
            HashMap<Integer, Integer> mesesComPagamento = new HashMap<Integer, Integer>();
            if ("TODOS".equals(this.edtBens.getInformacao().asString())) {
                pListaBensImoveis = demonstrativo.getBensImoveis().itens();
                pListaBensMoveis = demonstrativo.getBensMoveis().itens();
                pListaBensPS = demonstrativo.getParticipacoesSocietarias().itens();
            }
            this.obterMesesPagamentoPrazoBensImoveis(pListaBensImoveis, mesesComPagamento);
            this.obterMesesPagamentoPrazoBensMoveis(pListaBensMoveis, mesesComPagamento);
            this.obterMesesPagamentoPrazoParticipacaoSoc(pListaBensPS, mesesComPagamento);
            ListModelMesesDarf listModelMesesEncontrados = new ListModelMesesDarf(mesesComPagamento);
            this.lstMeses.setModel(listModelMesesEncontrados);
        }
    }

    private boolean imprimir() {
        String lTipoRelatorio = this.edtSelecionarImpressao.getInformacao().getConteudoFormatado();
        return this.imprimirDarf(lTipoRelatorio);
    }

    private void adicionaObservadorTipoRelatorio() {
        ObservadorTela lObservadorTipoRelatorio = new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                String stringNovo = valorNovo.toString();
                if ("VISUALIZAR".equals(stringNovo) || "PDF".equals(stringNovo)) {
                    PainelSelecionarImpressaoDarf.this.lblAtencaoImpressao.setText(MensagemUtil.getMensagem("vencimentodardiautil"));
                } else {
                    PainelSelecionarImpressaoDarf.this.lblAtencaoImpressao.setText(MensagemUtil.getMensagem("vencimentodardiautilmaispapela4"));
                }
                PainelSelecionarImpressaoDarf.this.atualizaHelp(stringNovo);
            }
        };
        this.edtSelecionarImpressao.getInformacao().addObservador((Observador)lObservadorTipoRelatorio);
    }

    private void setHabilitadoListaBensParaSelecao(boolean isHabilitado) {
        this.tabBens.setEnabled(isHabilitado);
        this.lstBensImoveis.setEnabled(isHabilitado);
        this.lstBensMoveis.setEnabled(isHabilitado);
        this.lstPSocietarias.setEnabled(isHabilitado);
    }

    private void carregarListasDeBensDemonstrativo(DemonstrativoGCAP demonstrativo) {
        final List listaBensMoveis = demonstrativo.getBensMoveis().itens();
        final List listaBensImoveis = demonstrativo.getBensImoveis().itens();
        final List listaPSocietarias = demonstrativo.getParticipacoesSocietarias().itens();
        this.lstBensMoveis.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return listaBensMoveis.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((AlienacaoBemMovel)((Object)listaBensMoveis.get(i))).getBemMovel().getEspecificacao();
            }
        });
        this.lstBensImoveis.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return listaBensImoveis.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((AlienacaoBemImovel)((Object)listaBensImoveis.get(i))).getBemImovel().getEspecificacao();
            }
        });
        this.lstPSocietarias.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return listaPSocietarias.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((AlienacaoParticipacaoSocietaria)((Object)listaPSocietarias.get(i))).getParticipacaoSocietaria().getNome();
            }
        });
    }

    private void btnAjudaActionPerformed(ActionEvent evt) {
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        GuiUtil.fecharDialog(this);
    }

    private int[] getMesesSelecionados() {
        Object[] nomesMesesSelecionados = null;
        if ("SELECIONADOS".equals(this.edtMeses.getInformacao().getConteudoFormatado())) {
            nomesMesesSelecionados = this.lstMeses.getSelectedValues();
        }
        int[] indiceRealDoMes = null;
        if (nomesMesesSelecionados != null) {
            indiceRealDoMes = new int[nomesMesesSelecionados.length];
            for (int i = 0; i < nomesMesesSelecionados.length; ++i) {
                String nomeMes = nomesMesesSelecionados[i].toString();
                indiceRealDoMes[i] = DataUtil.getNumeroMesPorNomeExtenso(nomeMes);
            }
        }
        return indiceRealDoMes;
    }

    private void initComponents() {
        this.jTituloForaPanel1 = new JTituloForaPanel();
        this.pnlBotoes = new JPanel();
        this.jTituloForaPanel2 = new JTituloForaPanel();
        this.lblAtencaoImpressao = new JEditLabel();
        this.gcapTitledPanel1 = new JTituloPanel();
        this.edtSelecionarImpressao = new JEditLogico();
        this.gcapTitledPanel2 = new JTituloPanel();
        this.lblMeses = new JEditLabel();
        this.edtMeses = new JEditLogico();
        this.scrollMeses = new JScrollPane();
        this.lstMeses = new JList();
        this.gcapTitledPanel3 = new JTituloPanel();
        this.edtBens = new JEditLogico();
        this.tabBens = new JCustomTabbedPane();
        this.pnlBensImoveis = new JPanel();
        this.scrollBensImoveis = new JScrollPane();
        this.lstBensImoveis = new JList();
        this.pnlBensMoveis = new JPanel();
        this.scrollBensMoveis = new JScrollPane();
        this.lstBensMoveis = new JList();
        this.pnlPSocietarias = new JPanel();
        this.scrollPSocietarias = new JScrollPane();
        this.lstPSocietarias = new JList();
        this.lblCpfSelecionado = new JEditLabel();
        this.lblCpf = new JEditLabel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        GroupLayout jTituloForaPanel1Layout = new GroupLayout((Container)this.jTituloForaPanel1);
        this.jTituloForaPanel1.setLayout((LayoutManager)jTituloForaPanel1Layout);
        jTituloForaPanel1Layout.setHorizontalGroup((GroupLayout.Group)jTituloForaPanel1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jTituloForaPanel1Layout.setVerticalGroup((GroupLayout.Group)jTituloForaPanel1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        this.pnlBotoes.setLayout(new FlowLayout(2));
        this.jTituloForaPanel2.setTitulo("");
        this.lblAtencaoImpressao.setText("<html><body><p>Aten\u00e7\u00e3o: para melhor qualidade na impress\u00e3o do Demonstrativo, configure a impressora para papel tamanho A4.</p></body></html>");
        this.lblAtencaoImpressao.setAlignmentX(0.5f);
        this.lblAtencaoImpressao.setMinimumSize(new Dimension(99, 27));
        this.gcapTitledPanel1.setTitulo("Selecione a op\u00e7\u00e3o desejada");
        GroupLayout gcapTitledPanel1Layout = new GroupLayout((Container)this.gcapTitledPanel1);
        this.gcapTitledPanel1.setLayout((LayoutManager)gcapTitledPanel1Layout);
        gcapTitledPanel1Layout.setHorizontalGroup((GroupLayout.Group)gcapTitledPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.edtSelecionarImpressao, -1, 229, Short.MAX_VALUE).addContainerGap()));
        gcapTitledPanel1Layout.setVerticalGroup((GroupLayout.Group)gcapTitledPanel1Layout.createParallelGroup(1).add((Component)this.edtSelecionarImpressao, -1, -1, Short.MAX_VALUE));
        this.gcapTitledPanel2.setTitulo("Sele\u00e7\u00e3o de Meses");
        this.lblMeses.setText("<html><body><p>Selecione o m\u00eas de RECEBIMENTO cujo Darf voc\u00ea deseja imprimir. O vencimento \u00e9 o \u00faltimo dia \u00fatil do m\u00eas seguinte ao do recebimento.</p></body></html>");
        this.edtMeses.setCorBackgroundComponenteReadOnly(Color.white);
        this.edtMeses.setOrientacaoTexto(0);
        this.scrollMeses.setNextFocusableComponent(this.lstMeses);
        this.lstMeses.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Janeiro", "Fevereiro", "Mar\u00e7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstMeses.setEnabled(false);
        this.scrollMeses.setViewportView(this.lstMeses);
        GroupLayout gcapTitledPanel2Layout = new GroupLayout((Container)this.gcapTitledPanel2);
        this.gcapTitledPanel2.setLayout((LayoutManager)gcapTitledPanel2Layout);
        gcapTitledPanel2Layout.setHorizontalGroup((GroupLayout.Group)gcapTitledPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)gcapTitledPanel2Layout.createParallelGroup(1).add(2, (Component)this.lblMeses, -1, 229, Short.MAX_VALUE).add(2, (Component)this.scrollMeses, -1, 229, Short.MAX_VALUE).add((Component)this.edtMeses, -2, 229, Short.MAX_VALUE)).addContainerGap()));
        gcapTitledPanel2Layout.setVerticalGroup((GroupLayout.Group)gcapTitledPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel2Layout.createSequentialGroup().add((Component)this.lblMeses, -2, -1, -2).addPreferredGap(0).add((Component)this.edtMeses, -2, -1, -2).add(9, 9, 9).add((Component)this.scrollMeses, -2, 0, Short.MAX_VALUE).addContainerGap()));
        this.gcapTitledPanel3.setTitulo("Sele\u00e7\u00e3o de Itens");
        this.edtBens.setOrientacaoTexto(0);
        this.pnlBensImoveis.setNextFocusableComponent(this.scrollBensImoveis);
        this.scrollBensImoveis.setNextFocusableComponent(this.lstBensImoveis);
        this.lstBensImoveis.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Mans\u00e3o Flanboyant", "Village Carpedien"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstBensImoveis.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PainelSelecionarImpressaoDarf.this.lstBensImoveisValueChanged(evt);
            }
        });
        this.scrollBensImoveis.setViewportView(this.lstBensImoveis);
        GroupLayout pnlBensImoveisLayout = new GroupLayout((Container)this.pnlBensImoveis);
        this.pnlBensImoveis.setLayout((LayoutManager)pnlBensImoveisLayout);
        pnlBensImoveisLayout.setHorizontalGroup((GroupLayout.Group)pnlBensImoveisLayout.createParallelGroup(1).add((GroupLayout.Group)pnlBensImoveisLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollBensImoveis, -1, 439, Short.MAX_VALUE).addContainerGap()));
        pnlBensImoveisLayout.setVerticalGroup((GroupLayout.Group)pnlBensImoveisLayout.createParallelGroup(1).add((GroupLayout.Group)pnlBensImoveisLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollBensImoveis, -1, 283, Short.MAX_VALUE).addContainerGap()));
        this.tabBens.addTab("Bens Im\u00f3veis", this.pnlBensImoveis);
        this.pnlBensMoveis.setNextFocusableComponent(this.scrollBensMoveis);
        this.scrollBensMoveis.setNextFocusableComponent(this.lstBensMoveis);
        this.lstBensMoveis.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Astra", "Golf", "I-30"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstBensMoveis.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PainelSelecionarImpressaoDarf.this.lstBensMoveisValueChanged(evt);
            }
        });
        this.scrollBensMoveis.setViewportView(this.lstBensMoveis);
        GroupLayout pnlBensMoveisLayout = new GroupLayout((Container)this.pnlBensMoveis);
        this.pnlBensMoveis.setLayout((LayoutManager)pnlBensMoveisLayout);
        pnlBensMoveisLayout.setHorizontalGroup((GroupLayout.Group)pnlBensMoveisLayout.createParallelGroup(1).add((GroupLayout.Group)pnlBensMoveisLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollBensMoveis, -1, 439, Short.MAX_VALUE).addContainerGap()));
        pnlBensMoveisLayout.setVerticalGroup((GroupLayout.Group)pnlBensMoveisLayout.createParallelGroup(1).add((GroupLayout.Group)pnlBensMoveisLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollBensMoveis, -1, 283, Short.MAX_VALUE).addContainerGap()));
        this.tabBens.addTab("Bens M\u00f3veis", this.pnlBensMoveis);
        this.pnlPSocietarias.setNextFocusableComponent(this.scrollPSocietarias);
        this.scrollPSocietarias.setNextFocusableComponent(this.lstPSocietarias);
        this.lstPSocietarias.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Petro 4", "Vale 5", "BB"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.lstPSocietarias.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                PainelSelecionarImpressaoDarf.this.lstPSocietariasValueChanged(evt);
            }
        });
        this.scrollPSocietarias.setViewportView(this.lstPSocietarias);
        GroupLayout pnlPSocietariasLayout = new GroupLayout((Container)this.pnlPSocietarias);
        this.pnlPSocietarias.setLayout((LayoutManager)pnlPSocietariasLayout);
        pnlPSocietariasLayout.setHorizontalGroup((GroupLayout.Group)pnlPSocietariasLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPSocietariasLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollPSocietarias, -1, 439, Short.MAX_VALUE).addContainerGap()));
        pnlPSocietariasLayout.setVerticalGroup((GroupLayout.Group)pnlPSocietariasLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPSocietariasLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollPSocietarias, -1, 283, Short.MAX_VALUE).addContainerGap()));
        this.tabBens.addTab("Participa\u00e7\u00f5es Societ\u00e1rias", this.pnlPSocietarias);
        GroupLayout gcapTitledPanel3Layout = new GroupLayout((Container)this.gcapTitledPanel3);
        this.gcapTitledPanel3.setLayout((LayoutManager)gcapTitledPanel3Layout);
        gcapTitledPanel3Layout.setHorizontalGroup((GroupLayout.Group)gcapTitledPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)gcapTitledPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)gcapTitledPanel3Layout.createParallelGroup(2).add(1, (Component)this.tabBens).add(1, (Component)this.edtBens, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        gcapTitledPanel3Layout.setVerticalGroup((GroupLayout.Group)gcapTitledPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.edtBens, -2, 25, -2).addPreferredGap(0).add((Component)this.tabBens).addContainerGap()));
        this.lblCpfSelecionado.setText("CPF selecionado:");
        this.lblCpfSelecionado.setFont(new Font("Tahoma", 1, 11));
        this.lblCpf.setText("V\u00e1rios");
        GroupLayout jTituloForaPanel2Layout = new GroupLayout((Container)this.jTituloForaPanel2);
        this.jTituloForaPanel2.setLayout((LayoutManager)jTituloForaPanel2Layout);
        jTituloForaPanel2Layout.setHorizontalGroup((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jTituloForaPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(1).add((Component)this.lblAtencaoImpressao, -1, 786, Short.MAX_VALUE).add((GroupLayout.Group)jTituloForaPanel2Layout.createSequentialGroup().add((Component)this.lblCpfSelecionado, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblCpf, -2, 613, -2)).add((GroupLayout.Group)jTituloForaPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(1, false).add((Component)this.gcapTitledPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.gcapTitledPanel1, -1, -1, Short.MAX_VALUE)).add(18, 18, 18).add((Component)this.gcapTitledPanel3, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jTituloForaPanel2Layout.setVerticalGroup((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jTituloForaPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(3).add((Component)this.lblCpfSelecionado, -2, -1, -2).add((Component)this.lblCpf, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)jTituloForaPanel2Layout.createParallelGroup(1, false).add((GroupLayout.Group)jTituloForaPanel2Layout.createSequentialGroup().add((Component)this.gcapTitledPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.gcapTitledPanel2, -1, -1, Short.MAX_VALUE)).add((Component)this.gcapTitledPanel3, -2, -1, -2)).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.lblAtencaoImpressao, -2, -1, -2)));
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.setPreferredSize(new Dimension(90, 27));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecionarImpressaoDarf.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('c');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.setPreferredSize(new Dimension(90, 27));
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecionarImpressaoDarf.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('a');
        this.btnAjuda.setText("Ajuda");
        this.btnAjuda.setPreferredSize(new Dimension(90, 27));
        this.btnAjuda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecionarImpressaoDarf.this.btnAjudaActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jTituloForaPanel2, -1, 798, Short.MAX_VALUE).add(1, (Component)this.pnlBotoes, -1, -1, Short.MAX_VALUE)).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.btnOk, -2, -1, -2).add(5, 5, 5).add((Component)this.btnCancelar, -2, -1, -2).add(5, 5, 5).add((Component)this.btnAjuda, -2, -1, -2).add(22, 22, 22)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jTituloForaPanel2, -2, 475, -2).add(0, 0, 0).add((Component)this.pnlBotoes, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.btnOk, -2, -1, -2).add((Component)this.btnCancelar, -2, -1, -2).add((Component)this.btnAjuda, -2, -1, -2)).addContainerGap()));
    }

    private void zerarListas() {
        AbstractListModel modeloVazio = new AbstractListModel(){

            @Override
            public int getSize() {
                return 0;
            }

            @Override
            public Object getElementAt(int i) {
                return null;
            }
        };
        this.lstBensMoveis.setModel(modeloVazio);
        this.lstBensImoveis.setModel(modeloVazio);
        this.lstPSocietarias.setModel(modeloVazio);
    }

    private void atualizarListaMesesDisponiveisPorBensSelecionados(int[][] pBensSelecionados) {
        int i;
        int[] imoveisSelecionados = pBensSelecionados[0];
        int[] moveisSelecionados = pBensSelecionados[1];
        int[] psSelecionados = pBensSelecionados[2];
        ArrayList<AlienacaoBemImovel> listaBensImoveis = new ArrayList<AlienacaoBemImovel>();
        ArrayList<AlienacaoBemMovel> listaBensMoveis = new ArrayList<AlienacaoBemMovel>();
        ArrayList<AlienacaoParticipacaoSocietaria> listaBensPS = new ArrayList<AlienacaoParticipacaoSocietaria>();
        DemonstrativoGCAP demonstrativo = this.arrayDemonstrativos[0];
        if (imoveisSelecionados != null) {
            for (i = 0; i < imoveisSelecionados.length; ++i) {
                listaBensImoveis.add((AlienacaoBemImovel)((Object)demonstrativo.getBensImoveis().recuperarLista().get(imoveisSelecionados[i])));
            }
        }
        if (moveisSelecionados != null) {
            for (i = 0; i < moveisSelecionados.length; ++i) {
                listaBensMoveis.add((AlienacaoBemMovel)((Object)demonstrativo.getBensMoveis().recuperarLista().get(moveisSelecionados[i])));
            }
        }
        if (psSelecionados != null) {
            for (i = 0; i < psSelecionados.length; ++i) {
                listaBensPS.add((AlienacaoParticipacaoSocietaria)((Object)demonstrativo.getParticipacoesSocietarias().recuperarLista().get(psSelecionados[i])));
            }
        }
        this.filtraMesesQueContemDarf(listaBensImoveis, listaBensMoveis, listaBensPS);
    }

    private boolean imprimirDarf(String opcaoSaidaRelatorio) {
        RelatorioDarf relatorio = new RelatorioDarf(null, null);
        if (this.arrayDemonstrativos.length > 1) {
            return false;
        }
        boolean isValido = false;
        DemonstrativoGCAP demonstrativo = null;
        int[][] itemDados = null;
        int[] mesesParaImprimir = null;
        if (this.arrayDemonstrativos.length == 1) {
            demonstrativo = this.arrayDemonstrativos[0];
            itemDados = this.getArrayBensSelecionadosDarf();
            mesesParaImprimir = this.getMesesSelecionados();
            isValido = this.validarImpressaoDarf();
        }
        if (isValido) {
            try {
                ControladorGui.abrirDemonstrativoSemUI(this.arrayDemonstrativos[0].getIdDemonstrativo());
                demonstrativo = ControladorGui.getDemonstrativoAberto();
            }
            catch (HashInvalidoException hashInvalidoException) {
                // empty catch block
            }
            DemonstrativoGCAP decAtual = this.arrayDemonstrativos[0];
            if (this.edtBens.getInformacao().formatado().equals("TODOS")) {
                VerificarPendenciasAction verificarPendenciasAction = new VerificarPendenciasAction();
                VerificarPendenciasAction.PendenciasDemonstrativo pendencias = verificarPendenciasAction.obterPendencias(decAtual);
                if (pendencias.getTotalErros() > 0) {
                    if (0 == JOptionPane.showConfirmDialog(this.getParent(), MensagemUtil.getMensagem("ErroImprimirDarfErrosImpeditivosExibirListaPendencias", new String[]{""}), "Confirma\u00e7\u00e3o", 0, 3)) {
                        GCAPFacade.limpaCacheDeclaracoes();
                        try {
                            ControladorGui.fecharDemonstrativoSemUI();
                            ControladorGui.abrirDemonstrativo(decAtual.getIdDemonstrativo(), true);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return false;
                        }
                        verificarPendenciasAction.exibirPendencias(pendencias);
                        return true;
                    }
                    ControladorGui.fecharDemonstrativoSemUI();
                    return true;
                }
                ControladorGui.fecharDemonstrativoSemUI();
            } else {
                if (this.temPendencia()) {
                    ControladorGui.fecharDemonstrativoSemUI();
                    GuiUtil.mostrarAviso("ErroImprimirDarfErrosImpeditivos");
                    return true;
                }
                ControladorGui.fecharDemonstrativoSemUI();
            }
            if ("VISUALIZAR".equals(opcaoSaidaRelatorio)) {
                new ImpressaoDarf().exibirPdfsDarfsBens(PlataformaPPGD.getPlataforma().getPainelPrincipal(), demonstrativo, itemDados, mesesParaImprimir);
                return true;
            }
        }
        return false;
    }

    private boolean temPendencia() {
        DemonstrativoGCAP demonstrativo = this.arrayDemonstrativos[0];
        List<AlienacaoBemImovel> bensImoveisSelecionados = new ArrayList();
        List bensImoveis = demonstrativo.getBensImoveis().itens();
        List<AlienacaoBemMovel> bensMoveisSelecionados = new ArrayList();
        List bensMoveis = demonstrativo.getBensMoveis().itens();
        List<AlienacaoParticipacaoSocietaria> participacaoSocSelecionados = new ArrayList();
        List participacaoSocs = demonstrativo.getParticipacoesSocietarias().itens();
        if (this.edtBens.getInformacao().formatado().equals("TODOS")) {
            bensImoveisSelecionados = bensImoveis;
            bensMoveisSelecionados = bensMoveis;
            participacaoSocSelecionados = participacaoSocs;
        } else {
            int i;
            if (this.bensSelecionados[0] != null) {
                for (i = 0; i < this.bensSelecionados[0].length; ++i) {
                    bensImoveisSelecionados.add((AlienacaoBemImovel)((Object)bensImoveis.get(this.bensSelecionados[0][i])));
                }
            }
            if (this.bensSelecionados[1] != null) {
                for (i = 0; i < this.bensSelecionados[1].length; ++i) {
                    bensMoveisSelecionados.add((AlienacaoBemMovel)((Object)bensMoveis.get(this.bensSelecionados[1][i])));
                }
            }
            if (this.bensSelecionados[2] != null) {
                for (i = 0; i < this.bensSelecionados[2].length; ++i) {
                    participacaoSocSelecionados.add((AlienacaoParticipacaoSocietaria)((Object)participacaoSocs.get(this.bensSelecionados[2][i])));
                }
            }
        }
        ArrayList listaPendencias = new ArrayList();
        for (AlienacaoBemImovel alienacaoBemImovel : bensImoveisSelecionados) {
            listaPendencias.addAll(FabricaUtilitarios.verificarPendencias((Object)((Object)alienacaoBemImovel)));
        }
        for (AlienacaoBemMovel alienacaoBemMovel : bensMoveisSelecionados) {
            listaPendencias.addAll(FabricaUtilitarios.verificarPendencias((Object)((Object)alienacaoBemMovel)));
        }
        for (AlienacaoParticipacaoSocietaria alienacaoParticSoc : participacaoSocSelecionados) {
            listaPendencias.addAll(FabricaUtilitarios.verificarPendencias((Object)((Object)alienacaoParticSoc)));
        }
        ArrayList<Pendencia> listaPendenciasErro = new ArrayList<Pendencia>();
        for (Pendencia pendencia : listaPendencias) {
            if (pendencia.getSeveridade() != 3) continue;
            listaPendenciasErro.add(pendencia);
        }
        if (listaPendenciasErro.size() > 0) {
            VerificarPendenciasAction verificarPendenciasAction = this.verificarPendencias;
            Objects.requireNonNull(verificarPendenciasAction);
            this.pendenciasDemonstrativo = verificarPendenciasAction.new VerificarPendenciasAction.PendenciasDemonstrativo(listaPendenciasErro, 0, 0);
            return true;
        }
        return false;
    }

    private boolean validarImpressaoDarf() {
        boolean isBensConsistentes;
        boolean isMesesConsistentes;
        DemonstrativoGCAP demonstrativo = this.arrayDemonstrativos[0];
        int[] mesesParaImprimir = this.getMesesSelecionados();
        boolean selecionouAlgumMes = mesesParaImprimir != null && mesesParaImprimir.length > 0;
        String lOpcaoMeses = this.edtMeses.getInformacao().getConteudoFormatado();
        boolean bl = isMesesConsistentes = selecionouAlgumMes && lOpcaoMeses.equals("SELECIONADOS") || lOpcaoMeses.equals("TODOS");
        if (!isMesesConsistentes) {
            GuiUtil.mostrarErro("\u00c9 necess\u00e1rio escolher ao menos um m\u00eas para a gera\u00e7\u00e3o do DARF.");
            return false;
        }
        boolean selecionouAlgumBem = this.bensSelecionados != null && this.bensSelecionados.length > 0;
        String lOpcaoBens = this.edtBens.getInformacao().getConteudoFormatado();
        boolean bl2 = isBensConsistentes = "SELECIONADOS".equals(lOpcaoBens) && selecionouAlgumBem || "TODOS".equals(lOpcaoBens) && (!demonstrativo.getBensImoveis().recuperarLista().isEmpty() || !demonstrativo.getBensMoveis().recuperarLista().isEmpty() || !demonstrativo.getParticipacoesSocietarias().recuperarLista().isEmpty());
        if (!isBensConsistentes) {
            GuiUtil.mostrarErro("\u00c9 necess\u00e1rio escolher ao menos um bem para a gera\u00e7\u00e3o do DARF.");
            return false;
        }
        return true;
    }

    private int[][] getArrayBensSelecionadosDarf() {
        int[][] itemDados = null;
        boolean isImprimirSomenteSelecionados = "SELECIONADOS".equals(this.edtBens.getInformacao().getConteudoFormatado());
        if (isImprimirSomenteSelecionados) {
            itemDados = this.getArrayBensSelecionados();
        }
        return itemDados;
    }

    private int[][] getArrayBensSelecionados() {
        int[][] itemDados = new int[][]{this.lstBensImoveis.getSelectedIndices(), this.lstBensMoveis.getSelectedIndices(), this.lstPSocietarias.getSelectedIndices()};
        return itemDados;
    }
}

