/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.dialogs;

import br.gov.serpro.gcap.app.ConstantesImpressaoIf;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.gui.componente.JCustomTabbedPane;
import br.gov.serpro.gcap.gui.componente.JEditLabel;
import br.gov.serpro.gcap.gui.componente.JTituloForaPanel;
import br.gov.serpro.gcap.gui.componente.JTituloPanel;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.impressao.RelatorioDemonstrativo;
import br.gov.serpro.gcap.observador.ObservadorTela;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Observador;

public class PainelSelecionarImpressaoDemonstrativo
extends JPanel
implements ConstantesImpressaoIf {
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JEditLogico edtBens;
    private JEditLogico edtSelecionarImpressao;
    private JTituloPanel gcapTitledPanel1;
    private JTituloPanel gcapTitledPanel3;
    private JPanel jPanel1;
    private JTituloForaPanel jTituloForaPanel1;
    private JEditLabel lblAtencaoImpressao;
    private JEditLabel lblCpf;
    private JEditLabel lblCpfSelecionado;
    private JList lstBensImoveis;
    private JList lstBensMoveis;
    private JList lstEspecies;
    private JList lstPSocietarias;
    private JPanel pnlBensImoveis;
    private JPanel pnlBensMoveis;
    private JPanel pnlBotoes;
    private JPanel pnlEspecies;
    private JPanel pnlPSocietarias;
    private JScrollPane scrollBensImoveis;
    private JScrollPane scrollBensMoveis;
    private JScrollPane scrollEspecies;
    private JScrollPane scrollPSocietarias;
    private JTabbedPane tabBens;
    private static final long serialVersionUID = 1L;
    private DemonstrativoGCAP[] arrayDemonstrativos;
    public static final String HELP_ID = "Como fazer para.../Imprimir Demonstrativo";

    public PainelSelecionarImpressaoDemonstrativo() {
        this.initComponents();
        this.inibirEnterNavegacaoFocoBotoes();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.btnAjuda.setFocusTraversalKeys(0, set);
        this.btnCancelar.setFocusTraversalKeys(0, set);
        this.btnOk.setFocusTraversalKeys(0, set);
    }

    public PainelSelecionarImpressaoDemonstrativo(DemonstrativoGCAP[] pDdemonstrativos) {
        this.arrayDemonstrativos = pDdemonstrativos;
        this.initComponents();
        this.edtBens.setBackground(Color.WHITE);
        this.edtSelecionarImpressao.setBackground(Color.WHITE);
        this.lblAtencaoImpressao.setText("<HTML></HTML>");
        Logico selecaoRelatorio = new Logico();
        selecaoRelatorio.addOpcao("VISUALIZAR", "Visualizar");
        selecaoRelatorio.addOpcao("PDF", "Gerar imagem PDF");
        selecaoRelatorio.addOpcao("IMPRIMIR", "Imprimir");
        selecaoRelatorio.setConteudo("VISUALIZAR");
        this.edtSelecionarImpressao.setInformacao((Informacao)selecaoRelatorio);
        Logico opcaoTodosOuSelecionados = new Logico();
        opcaoTodosOuSelecionados.addOpcao("TODOS", "Todos");
        opcaoTodosOuSelecionados.addOpcao("SELECIONADOS", "Um ou mais");
        opcaoTodosOuSelecionados.setConteudo("TODOS");
        this.edtBens.setInformacao((Informacao)opcaoTodosOuSelecionados);
        this.setHabilitadoListaBensParaSelecao(false);
        if (pDdemonstrativos.length == 1) {
            String cpfDeclarante = pDdemonstrativos[0].getIdDemonstrativo().getCpf().formatado();
            this.lblCpf.setText(cpfDeclarante);
            this.carregarListasDeBensDemonstrativo(pDdemonstrativos[0]);
        } else {
            JRadioButton selecionados = (JRadioButton)this.edtBens.getRadios().get("Um ou mais");
            selecionados.setEnabled(false);
            this.zerarListas();
        }
        this.adicionarObservadores();
        this.atualizaHelp("VISUALIZAR");
        this.inibirEnterNavegacaoFocoBotoes();
    }

    private void atualizaHelp(String opcaoSaidaRelatorio) {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "Como fazer para.../... Imprimir Demonstrativo");
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, "Como fazer para.../... Imprimir Demonstrativo");
    }

    private void adicionarObservadores() {
        this.adicionaObservadorTipoRelatorio();
        this.adicionaObservadorBens();
    }

    private void adicionaObservadorBens() {
        ObservadorTela lObservadorBens = new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                Logico opcao = (Logico)observado;
                if (opcao.asString().equals("SELECIONADOS")) {
                    PainelSelecionarImpressaoDemonstrativo.this.setHabilitadoListaBensParaSelecao(true);
                }
                if (opcao.asString().equals("TODOS")) {
                    PainelSelecionarImpressaoDemonstrativo.this.setHabilitadoListaBensParaSelecao(false);
                }
            }
        };
        this.edtBens.getInformacao().addObservador((Observador)lObservadorBens);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        String opcaoSaidaRelatorio = this.edtSelecionarImpressao.getInformacao().asString();
        if ("IMPRIMIR".equals(opcaoSaidaRelatorio) && !GuiUtil.mostrarConfirma(null, "Se houver uma impressora instalada, a impress\u00e3o ser\u00e1 enviada diretamente para ela, confirma a impress\u00e3o?")) {
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        GuiUtil.fecharDialog(this);
        this.imprimir();
        this.setCursor(cursor);
    }

    private boolean imprimir() {
        String lTipoRelatorio = this.edtSelecionarImpressao.getInformacao().getConteudoFormatado();
        return this.imprimirDemonstrativo(lTipoRelatorio);
    }

    private void adicionaObservadorTipoRelatorio() {
        ObservadorTela lObservadorTipoRelatorio = new ObservadorTela(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                String stringNovo = valorNovo.toString();
                if ("VISUALIZAR".equals(stringNovo) || "PDF".equals(stringNovo)) {
                    PainelSelecionarImpressaoDemonstrativo.this.lblAtencaoImpressao.setText("<HTML><body></body></HTML>");
                } else {
                    PainelSelecionarImpressaoDemonstrativo.this.lblAtencaoImpressao.setText("<html><body><p>Aten\u00e7\u00e3o: para melhor qualidade na impress\u00e3o do Demonstrativo, configure a impressora para papel tamanho A4.</p></body></html>");
                }
                PainelSelecionarImpressaoDemonstrativo.this.atualizaHelp(stringNovo);
                PainelSelecionarImpressaoDemonstrativo.this.edtBens.getInformacao().setConteudo("TODOS");
            }
        };
        this.edtSelecionarImpressao.getInformacao().addObservador((Observador)lObservadorTipoRelatorio);
    }

    private void setHabilitadoListaBensParaSelecao(boolean isHabilitado) {
        this.tabBens.setEnabled(isHabilitado);
        this.lstBensImoveis.setEnabled(isHabilitado);
        this.lstBensMoveis.setEnabled(isHabilitado);
        this.lstPSocietarias.setEnabled(isHabilitado);
        this.lstEspecies.setEnabled(isHabilitado);
    }

    private void carregarListasDeBensDemonstrativo(DemonstrativoGCAP demonstrativo) {
        final List listaBensMoveis = demonstrativo.getBensMoveis().itens();
        final List listaBensImoveis = demonstrativo.getBensImoveis().itens();
        final List listaPSocietarias = demonstrativo.getParticipacoesSocietarias().itens();
        final ArrayList<ColecaoMoedaAlienada> listaColecaoMoedaAlienada = new ArrayList<ColecaoMoedaAlienada>();
        if (demonstrativo.getMoedasAlienadas().itens().size() > 0) {
            listaColecaoMoedaAlienada.add(demonstrativo.getMoedasAlienadas());
        }
        this.lstBensMoveis.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return listaBensMoveis.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((AlienacaoBemMovel)((Object)listaBensMoveis.get(i))).getBemMovel().getEspecificacao();
            }
        });
        this.lstBensImoveis.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return listaBensImoveis.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((AlienacaoBemImovel)((Object)listaBensImoveis.get(i))).getBemImovel().getEspecificacao();
            }
        });
        this.lstPSocietarias.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return listaPSocietarias.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((AlienacaoParticipacaoSocietaria)((Object)listaPSocietarias.get(i))).getParticipacaoSocietaria().getNome();
            }
        });
        this.lstEspecies.setModel(new AbstractListModel(){

            @Override
            public int getSize() {
                return listaColecaoMoedaAlienada.size();
            }

            @Override
            public Object getElementAt(int i) {
                return ((ColecaoMoedaAlienada)((Object)listaColecaoMoedaAlienada.get(i))).nomeRelatorio();
            }
        });
    }

    private void btnAjudaActionPerformed(ActionEvent evt) {
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        GuiUtil.fecharDialog(this);
    }

    private void initComponents() {
        this.jTituloForaPanel1 = new JTituloForaPanel();
        this.pnlBotoes = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.jPanel1 = new JPanel();
        this.lblAtencaoImpressao = new JEditLabel();
        this.gcapTitledPanel1 = new JTituloPanel();
        this.edtSelecionarImpressao = new JEditLogico();
        this.gcapTitledPanel3 = new JTituloPanel();
        this.edtBens = new JEditLogico();
        this.tabBens = new JCustomTabbedPane();
        this.pnlBensImoveis = new JPanel();
        this.scrollBensImoveis = new JScrollPane();
        this.lstBensImoveis = new JList();
        this.pnlBensMoveis = new JPanel();
        this.scrollBensMoveis = new JScrollPane();
        this.lstBensMoveis = new JList();
        this.pnlPSocietarias = new JPanel();
        this.scrollPSocietarias = new JScrollPane();
        this.lstPSocietarias = new JList();
        this.pnlEspecies = new JPanel();
        this.scrollEspecies = new JScrollPane();
        this.lstEspecies = new JList();
        this.lblCpfSelecionado = new JEditLabel();
        this.lblCpf = new JEditLabel();
        GroupLayout jTituloForaPanel1Layout = new GroupLayout((Container)this.jTituloForaPanel1);
        this.jTituloForaPanel1.setLayout((LayoutManager)jTituloForaPanel1Layout);
        jTituloForaPanel1Layout.setHorizontalGroup((GroupLayout.Group)jTituloForaPanel1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        jTituloForaPanel1Layout.setVerticalGroup((GroupLayout.Group)jTituloForaPanel1Layout.createParallelGroup(1).add(0, 0, Short.MAX_VALUE));
        this.pnlBotoes.setLayout(new FlowLayout(2));
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.setPreferredSize(new Dimension(90, 27));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecionarImpressaoDemonstrativo.this.btnOkActionPerformed(evt);
            }
        });
        this.pnlBotoes.add(this.btnOk);
        this.btnCancelar.setMnemonic('c');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.setPreferredSize(new Dimension(90, 27));
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecionarImpressaoDemonstrativo.this.btnCancelarActionPerformed(evt);
            }
        });
        this.pnlBotoes.add(this.btnCancelar);
        this.btnAjuda.setMnemonic('a');
        this.btnAjuda.setText("Ajuda");
        this.btnAjuda.setPreferredSize(new Dimension(90, 27));
        this.btnAjuda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecionarImpressaoDemonstrativo.this.btnAjudaActionPerformed(evt);
            }
        });
        this.pnlBotoes.add(this.btnAjuda);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.lblAtencaoImpressao.setText("<html><body><p>Aten\u00e7\u00e3o: para melhor qualidade na impress\u00e3o do Demonstrativo, configure a impressora para papel tamanho A4.</p></body></html>");
        this.lblAtencaoImpressao.setAlignmentX(0.5f);
        this.lblAtencaoImpressao.setMinimumSize(new Dimension(99, 27));
        this.gcapTitledPanel1.setBackground(new Color(255, 255, 255));
        this.gcapTitledPanel1.setTitulo("Sele\u00e7\u00e3o de Documento");
        GroupLayout gcapTitledPanel1Layout = new GroupLayout((Container)this.gcapTitledPanel1);
        this.gcapTitledPanel1.setLayout((LayoutManager)gcapTitledPanel1Layout);
        gcapTitledPanel1Layout.setHorizontalGroup((GroupLayout.Group)gcapTitledPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.edtSelecionarImpressao, -1, 229, Short.MAX_VALUE).addContainerGap()));
        gcapTitledPanel1Layout.setVerticalGroup((GroupLayout.Group)gcapTitledPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel1Layout.createSequentialGroup().add((Component)this.edtSelecionarImpressao, -2, 61, Short.MAX_VALUE).addContainerGap()));
        this.gcapTitledPanel3.setBackground(new Color(255, 255, 255));
        this.gcapTitledPanel3.setTitulo("Sele\u00e7\u00e3o de Itens");
        this.edtBens.setOrientacaoTexto(0);
        this.lstBensImoveis.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Mans\u00e3o Flanboyant", "Village Carpedien"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.scrollBensImoveis.setViewportView(this.lstBensImoveis);
        this.lstBensImoveis.getAccessibleContext().setAccessibleName("Bens Im\u00f3veis");
        GroupLayout pnlBensImoveisLayout = new GroupLayout((Container)this.pnlBensImoveis);
        this.pnlBensImoveis.setLayout((LayoutManager)pnlBensImoveisLayout);
        pnlBensImoveisLayout.setHorizontalGroup((GroupLayout.Group)pnlBensImoveisLayout.createParallelGroup(1).add((GroupLayout.Group)pnlBensImoveisLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollBensImoveis, -1, 440, Short.MAX_VALUE).addContainerGap()));
        pnlBensImoveisLayout.setVerticalGroup((GroupLayout.Group)pnlBensImoveisLayout.createParallelGroup(1).add((GroupLayout.Group)pnlBensImoveisLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollBensImoveis, -1, 295, Short.MAX_VALUE).addContainerGap()));
        this.tabBens.addTab("Bens Im\u00f3veis", this.pnlBensImoveis);
        this.lstBensMoveis.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Astra", "Golf", "I-30"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.scrollBensMoveis.setViewportView(this.lstBensMoveis);
        this.lstBensMoveis.getAccessibleContext().setAccessibleName("Bens M\u00f3veis");
        GroupLayout pnlBensMoveisLayout = new GroupLayout((Container)this.pnlBensMoveis);
        this.pnlBensMoveis.setLayout((LayoutManager)pnlBensMoveisLayout);
        pnlBensMoveisLayout.setHorizontalGroup((GroupLayout.Group)pnlBensMoveisLayout.createParallelGroup(1).add((GroupLayout.Group)pnlBensMoveisLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollBensMoveis, -1, 440, Short.MAX_VALUE).addContainerGap()));
        pnlBensMoveisLayout.setVerticalGroup((GroupLayout.Group)pnlBensMoveisLayout.createParallelGroup(1).add((GroupLayout.Group)pnlBensMoveisLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollBensMoveis, -1, 295, Short.MAX_VALUE).addContainerGap()));
        this.tabBens.addTab("Bens M\u00f3veis", this.pnlBensMoveis);
        this.lstPSocietarias.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Petro 4", "Vale 5", "BB"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.scrollPSocietarias.setViewportView(this.lstPSocietarias);
        this.lstPSocietarias.getAccessibleContext().setAccessibleName("Participa\u00e7\u00f5es Societ\u00e1rias");
        GroupLayout pnlPSocietariasLayout = new GroupLayout((Container)this.pnlPSocietarias);
        this.pnlPSocietarias.setLayout((LayoutManager)pnlPSocietariasLayout);
        pnlPSocietariasLayout.setHorizontalGroup((GroupLayout.Group)pnlPSocietariasLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPSocietariasLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollPSocietarias, -1, 440, Short.MAX_VALUE).addContainerGap()));
        pnlPSocietariasLayout.setVerticalGroup((GroupLayout.Group)pnlPSocietariasLayout.createParallelGroup(1).add((GroupLayout.Group)pnlPSocietariasLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollPSocietarias, -1, 295, Short.MAX_VALUE).addContainerGap()));
        this.tabBens.addTab("Participa\u00e7\u00f5es Societ\u00e1rias", this.pnlPSocietarias);
        this.lstEspecies.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Petro 4", "Vale 5", "BB"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.scrollEspecies.setViewportView(this.lstEspecies);
        this.lstEspecies.getAccessibleContext().setAccessibleName("Esp\u00e9cies");
        GroupLayout pnlEspeciesLayout = new GroupLayout((Container)this.pnlEspecies);
        this.pnlEspecies.setLayout((LayoutManager)pnlEspeciesLayout);
        pnlEspeciesLayout.setHorizontalGroup((GroupLayout.Group)pnlEspeciesLayout.createParallelGroup(1).add((GroupLayout.Group)pnlEspeciesLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollEspecies, -1, 440, Short.MAX_VALUE).addContainerGap()));
        pnlEspeciesLayout.setVerticalGroup((GroupLayout.Group)pnlEspeciesLayout.createParallelGroup(1).add((GroupLayout.Group)pnlEspeciesLayout.createSequentialGroup().addContainerGap().add((Component)this.scrollEspecies, -1, 295, Short.MAX_VALUE).addContainerGap()));
        this.tabBens.addTab("Esp\u00e9cies", this.pnlEspecies);
        GroupLayout gcapTitledPanel3Layout = new GroupLayout((Container)this.gcapTitledPanel3);
        this.gcapTitledPanel3.setLayout((LayoutManager)gcapTitledPanel3Layout);
        gcapTitledPanel3Layout.setHorizontalGroup((GroupLayout.Group)gcapTitledPanel3Layout.createParallelGroup(1).add(2, (GroupLayout.Group)gcapTitledPanel3Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)gcapTitledPanel3Layout.createParallelGroup(2).add(1, (Component)this.tabBens).add(1, (Component)this.edtBens, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        gcapTitledPanel3Layout.setVerticalGroup((GroupLayout.Group)gcapTitledPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)gcapTitledPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.edtBens, -2, 25, -2).addPreferredGap(0).add((Component)this.tabBens).addContainerGap()));
        this.lblCpfSelecionado.setText("CPF selecionado:");
        this.lblCpfSelecionado.setFont(new Font("Tahoma", 1, 11));
        this.lblCpf.setText("V\u00e1rios");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.lblCpfSelecionado, -2, 123, -2).add(44, 44, 44).add((Component)this.lblCpf, -1, -1, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.lblAtencaoImpressao, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.gcapTitledPanel1, -2, -1, -2).addPreferredGap(1).add((Component)this.gcapTitledPanel3, -1, -1, Short.MAX_VALUE))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.lblCpfSelecionado, -2, -1, -2).add((Component)this.lblCpf, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.gcapTitledPanel3, -2, -1, -2).add((Component)this.gcapTitledPanel1, -2, -1, -2)).addPreferredGap(0, 27, Short.MAX_VALUE).add((Component)this.lblAtencaoImpressao, -2, 27, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -2, -1, -2).add((Component)this.pnlBotoes, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -2, -1, -2).add(18, 18, 18).add((Component)this.pnlBotoes, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void zerarListas() {
        AbstractListModel modeloVazio = new AbstractListModel(){

            @Override
            public int getSize() {
                return 0;
            }

            @Override
            public Object getElementAt(int i) {
                return null;
            }
        };
        this.lstBensMoveis.setModel(modeloVazio);
        this.lstBensImoveis.setModel(modeloVazio);
        this.lstPSocietarias.setModel(modeloVazio);
        this.lstEspecies.setModel(modeloVazio);
    }

    private boolean imprimirDemonstrativo(String opcaoSaidaRelatorio) {
        RelatorioDemonstrativo relatorio = new RelatorioDemonstrativo(null);
        if (this.arrayDemonstrativos.length > 1) {
            relatorio = new RelatorioDemonstrativo(this.arrayDemonstrativos);
        }
        if (this.arrayDemonstrativos.length == 1) {
            DemonstrativoGCAP demonstrativo = this.arrayDemonstrativos[0];
            boolean isImprimirSomenteBensSelecionados = "SELECIONADOS".equals(this.edtBens.getInformacao().getConteudoFormatado());
            relatorio = isImprimirSomenteBensSelecionados ? new RelatorioDemonstrativo(demonstrativo, this.getArrayBensSelecionados()) : new RelatorioDemonstrativo(demonstrativo, null);
        }
        if ("VISUALIZAR".equals(opcaoSaidaRelatorio)) {
            relatorio.visualizar();
        } else if ("IMPRIMIR".equals(opcaoSaidaRelatorio)) {
            relatorio.imprimir();
        } else {
            relatorio.gerarPDF();
        }
        return true;
    }

    private int[][] getArrayBensSelecionados() {
        int[][] itemDados = new int[][]{this.lstBensImoveis.getSelectedIndices(), this.lstBensMoveis.getSelectedIndices(), this.lstPSocietarias.getSelectedIndices(), this.lstEspecies.getSelectedIndices()};
        return itemDados;
    }
}

