/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.especie;

import br.gov.serpro.gcap.entidades.especie.MoedaAlienada;
import br.gov.serpro.gcap.entidades.especie.OperacaoEspecie;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.GCAPListSelectionModel;
import br.gov.serpro.gcap.gui.GCAPTableAb;
import br.gov.serpro.gcap.gui.GCAPTableModelAb;
import br.gov.serpro.gcap.gui.GCAPToolbar;
import br.gov.serpro.gcap.gui.PainelAbaIf;
import br.gov.serpro.gcap.gui.PainelComlListaEditavelIf;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.TableLista;
import br.gov.serpro.gcap.gui.TableListaCellRenderer;
import br.gov.serpro.gcap.gui.TableListaModel;
import br.gov.serpro.gcap.gui.especie.PainelAbaListaOperacoesMoedasEspecieAb;
import br.gov.serpro.gcap.gui.especie.PainelOperacaoCompra;
import br.gov.serpro.gcap.gui.especie.PainelOperacaoVenda;
import br.gov.serpro.gcap.gui.especie.TableModelOperacoesMoedasEspecie;
import br.gov.serpro.gcap.gui.table.ColumnGroup;
import br.gov.serpro.gcap.gui.table.GroupableTableColumnModel;
import br.gov.serpro.gcap.gui.table.GroupableTableHeader;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;

public class PainelAbaListaOperacoesMoedasEspecie
extends PainelAbaListaOperacoesMoedasEspecieAb
implements PainelAbaIf,
PainelComlListaEditavelIf {
    private static final long serialVersionUID = 1L;
    public static final String TITULO_PAINEL = "Moedas em Esp\u00e9cie";
    public static final String NOME_ABA = "Opera\u00e7\u00f5es";
    public static final String HELP_ID = "\u00cdndice";
    private MoedaAlienada moedaAlienada = null;
    private PainelDemonstrativoIf painelPai;

    public PainelAbaListaOperacoesMoedasEspecie(PainelDemonstrativoIf painelPai, MoedaAlienada moedaAlienada) {
        super(new TableModelOperacoesMoedasEspecie((ObjetoNegocio)moedaAlienada.getOperacoesEspecie()));
        this.painelPai = painelPai;
        this.moedaAlienada = moedaAlienada;
        this.getEdtGanhoCapitalTotal().setInformacao((Informacao)this.moedaAlienada.getOperacoesEspecie().getTotalGanhoCapital());
        this.configurarAcessibilidade();
    }

    public void configurarAcessibilidade() {
        this.getTabela().getAccessibleContext().setAccessibleDescription("Opera\u00e7\u00f5es de compra e venda de moeda em esp\u00e9cie.\nObserva\u00e7\u00e3o: A primeira linha da tabela n\u00e3o \u00e9 selecion\u00e1vel, pois corresponde ao saldo inicial, informado na aba identifica\u00e7\u00e3o.");
        this.getEdtGanhoCapitalTotal().getAccessibleContext().setAccessibleName("Ganho de capital total em reais");
    }

    @Override
    protected void configurarTamanhoColunas() {
    }

    @Override
    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis){

            @Override
            protected void configuraLayoutHeader() {
                super.configuraLayoutHeader();
                this.setColumnModel(new GroupableTableColumnModel());
                this.setTableHeader(new GroupableTableHeader(this.getColumnModel()));
                this.getTableHeader().setForeground(new Color(0, 74, 106));
                this.getTableHeader().setBackground(new Color(231, 245, 249));
                this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(1));
            }

            @Override
            protected void configuraLayout() {
                super.configuraLayout();
                final GroupableTableColumnModel cm = (GroupableTableColumnModel)this.getColumnModel();
                ColumnGroup cgVazio = new ColumnGroup("");
                ColumnGroup cgEntrada = new ColumnGroup("<HTML><CENTER>Entrada</CENTER></HTML>"){

                    @Override
                    public Dimension getSize(JTable table) {
                        return new Dimension(cm.getColumn(1).getWidth() + cm.getColumn(2).getWidth(), 20);
                    }
                };
                cgEntrada.add(cm.getColumn(1));
                cgEntrada.add(cm.getColumn(2));
                ColumnGroup cgSaida = new ColumnGroup("<HTML><CENTER>Sa\u00edda</CENTER></HTML>"){

                    @Override
                    public Dimension getSize(JTable table) {
                        return new Dimension(cm.getColumn(3).getWidth() + cm.getColumn(4).getWidth() + cm.getColumn(5).getWidth(), 20);
                    }
                };
                cgSaida.add(cm.getColumn(3));
                cgSaida.add(cm.getColumn(4));
                cgSaida.add(cm.getColumn(5));
                ColumnGroup cgSaldo = new ColumnGroup("<HTML><CENTER>Saldo</CENTER></HTML>"){

                    @Override
                    public Dimension getSize(JTable table) {
                        return new Dimension(cm.getColumn(6).getWidth() + cm.getColumn(7).getWidth() + cm.getColumn(8).getWidth(), 20);
                    }
                };
                cgSaldo.add(cm.getColumn(6));
                cgSaldo.add(cm.getColumn(7));
                cgSaldo.add(cm.getColumn(8));
                cm.addColumnGroup(cgVazio);
                cm.addColumnGroup(cgEntrada);
                cm.addColumnGroup(cgSaida);
                cm.addColumnGroup(cgSaldo);
                this.getTableHeader().setPreferredSize(new Dimension(this.getTableHeader().getWidth(), 80));
            }
        };
        tableLista.accessibleColumnHeader = new String[]{"Data", "Quantidade de Entrada", "Custo Total de Aquisi\u00e7\u00e3o", "Quantidade de Sa\u00edda", "Custo Total", "Ganho de Capital", "Quantidade", "Valor Acumulado", "Custo M\u00e9dio Ponderado Unit\u00e1rio"};
        tableLista.setSelectionModel(new GCAPListSelectionModel(model.getRowCount()){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (index0 > 0) {
                    super.setSelectionInterval(index0, index1);
                }
            }

            @Override
            public void addSelectionInterval(int index0, int index1) {
                if (index0 > 0) {
                    super.addSelectionInterval(index0, index1);
                }
            }
        });
        tableLista.setDefaultRenderer(Object.class, new TableListaCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component retorno = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (row == 0) {
                    if (!isSelected) {
                        this.setBackground(new Color(234, 242, 251));
                    }
                    this.setFont(this.getFont().deriveFont(1));
                } else {
                    if (!isSelected) {
                        this.setBackground(Color.WHITE);
                    }
                    this.setFont(this.getFont().deriveFont(0));
                }
                if (retorno instanceof JLabel && value != null && value instanceof Informacao) {
                    JLabel lRetorno = (JLabel)retorno;
                    Informacao info = (Informacao)value;
                    RetornoValidacao ret = info.validar().getPrimeiroRetornoValidacaoMaisSevero();
                    if (ret != null && !ret.isValido()) {
                        lRetorno.setForeground(Color.RED);
                    } else {
                        lRetorno.setForeground(null);
                    }
                }
                return retorno;
            }
        });
        tableLista.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent arg0) {
                if (PainelAbaListaOperacoesMoedasEspecie.this.getTableModel().getRowCount() > 1) {
                    PainelAbaListaOperacoesMoedasEspecie.this.getTabela().setRowSelectionInterval(1, 1);
                }
            }
        });
        return tableLista;
    }

    @Override
    protected String getClassePainelNavegacao() {
        return null;
    }

    @Override
    protected String getButtonHelpID() {
        return HELP_ID;
    }

    @Override
    protected int getColunaOrdenacao() {
        return 0;
    }

    @Override
    protected Integer[] getColunasOrdenaveis() {
        return null;
    }

    @Override
    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens";
    }

    @Override
    public String[] getParametrosMensagemExclusao() {
        return new String[]{"opera\u00e7\u00e3o sobre moeda em esp\u00e9cie"};
    }

    @Override
    public GCAPToolbar novoToolBar() {
        return new GCAPToolbar("_Venda", "_Editar", "E_xcluir", "_Compra");
    }

    @Override
    public boolean validarExclusao(int row, ObjetoNegocio objetoNegocio) {
        if (row == 0) {
            GuiUtil.mostrarAviso("ErroExcluirOperacaoEspecieSaldoInicial");
            return false;
        }
        return true;
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        this.onBtnVendaClick(e);
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha) - 1;
            OperacaoEspecie operacao = (OperacaoEspecie)((Object)this.moedaAlienada.getOperacoesEspecie().itens().get(indiceVetor));
            if (operacao.getTipo().naoFormatado().equals("1")) {
                ControladorGui.acionarPainel(new PainelOperacaoCompra(this.painelPai, this.getSubtitulo() + " - Opera\u00e7\u00e3o de Compra", this.moedaAlienada.getOperacoesEspecie(), indiceVetor, false));
            } else if (operacao.getTipo().naoFormatado().equals("2")) {
                ControladorGui.acionarPainel(new PainelOperacaoVenda(this.painelPai, this.getSubtitulo() + " - Opera\u00e7\u00e3o de Venda", this.moedaAlienada.getOperacoesEspecie(), indiceVetor, false));
            }
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }

    public void onBtnCompraClick(ActionEvent e) {
        int ordem = this.moedaAlienada.getOperacoesEspecie().inserirNovaOperacaoCompra();
        ControladorGui.acionarPainel(new PainelOperacaoCompra(this.painelPai, this.getSubtitulo() + " - Opera\u00e7\u00e3o de Compra", this.moedaAlienada.getOperacoesEspecie(), ordem, true));
        GCAPTableModelAb lModel = (GCAPTableModelAb)this.getTabela().getModel();
        lModel.refresh();
    }

    public void onBtnVendaClick(ActionEvent e) {
        int ordem = this.moedaAlienada.getOperacoesEspecie().inserirNovaOperacaoVenda();
        ControladorGui.acionarPainel(new PainelOperacaoVenda(this.painelPai, this.getSubtitulo() + " - Opera\u00e7\u00e3o de Venda", this.moedaAlienada.getOperacoesEspecie(), ordem, true));
        GCAPTableModelAb lModel = (GCAPTableModelAb)this.getTabela().getModel();
        lModel.refresh();
    }

    @Override
    public void onBtnClick(int index, ActionEvent e) {
        switch (index) {
            case 0: {
                this.onBtnCompraClick(e);
                break;
            }
        }
    }

    @Override
    public String getTituloPainel() {
        return TITULO_PAINEL;
    }

    @Override
    public void aposCriarAbas() {
    }

    @Override
    public String getNomeAba() {
        return NOME_ABA;
    }

    @Override
    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    @Override
    public boolean isTelaComSubtitulo() {
        return true;
    }

    @Override
    public String getSubtitulo() {
        return this.moedaAlienada.getMoeda().getConteudoAtual(1);
    }

    @Override
    public void acionarEdicaoLinha(int linha) {
        GCAPTableAb tabela = this.getTabela();
        int indiceTabela = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToView(linha + 1);
        tabela.setRowSelectionInterval(indiceTabela, indiceTabela);
        this.onBtnAbrirClick(null);
    }
}

