/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.especie;

import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.PainelComAbasAb;
import br.gov.serpro.gcap.gui.especie.PainelAbaConsolidacaoMoeda;
import br.gov.serpro.gcap.gui.especie.PainelAbaListaMoedasEspecie;
import br.gov.serpro.gcap.gui.especie.PainelAbaListaTotalizacaoMoedasEspecie;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelDadosMoedas
extends PainelComAbasAb {
    private static final long serialVersionUID = 1L;
    public static String TITULO = "Moedas em Esp\u00e9cie";
    private PainelAbaListaMoedasEspecie painelListaMoedasEspecie = null;
    private PainelAbaListaTotalizacaoMoedasEspecie painelListaTotalizacaoMoedasEspecie = null;
    private PainelAbaConsolidacaoMoeda painelConsolidacaoMoeda = null;

    public PainelDadosMoedas() {
        this(GCAPFacade.getInstancia().getDeclaracao().getMoedasAlienadas());
    }

    public PainelDadosMoedas(ColecaoMoedaAlienada moedas) {
        super((ObjetoNegocio)moedas);
        this.montarAbas();
        this.configurarHelpID();
        this.acionarAba("Moedas Alienadas", true);
    }

    @Override
    protected void montarAbas() {
        this.painelListaMoedasEspecie = new PainelAbaListaMoedasEspecie(this);
        this.getTabbedPane().addTab("Moedas Alienadas", this.painelListaMoedasEspecie);
        this.painelListaTotalizacaoMoedasEspecie = new PainelAbaListaTotalizacaoMoedasEspecie(this);
        this.getTabbedPane().addTab("Totaliza\u00e7\u00e3o", this.painelListaTotalizacaoMoedasEspecie);
        this.painelConsolidacaoMoeda = new PainelAbaConsolidacaoMoeda(this);
        this.getTabbedPane().addTab("Consolida\u00e7\u00e3o", this.painelConsolidacaoMoeda);
    }

    @Override
    protected void tratarMudancaTabbedPane() {
        ControladorGui.alterarCabecalhoFicha(this.getTituloPainel());
        ControladorGui.alterarHelpId(this.getHelpIdAba(this.getTabbedPane().getSelectedIndex()));
        this.configurarHelpID();
        if (this.getTabbedPane().getSelectedIndex() == 2) {
            this.painelConsolidacaoMoeda.preExibir();
        }
    }

    @Override
    protected String[] definirNomeAbas() {
        return new String[]{"Moedas Alienadas", "Totaliza\u00e7\u00e3o", "Consolida\u00e7\u00e3o"};
    }

    @Override
    protected void configObservadores() {
    }

    @Override
    public String getTituloPainel() {
        switch (this.getTabbedPane().getSelectedIndex()) {
            case 0: {
                return "Moedas em Esp\u00e9cie - Moedas Alienadas";
            }
            case 1: {
                return "Moedas em Esp\u00e9cie - Totaliza\u00e7\u00e3o";
            }
            case 2: {
                return "Moedas em Esp\u00e9cie - Consolida\u00e7\u00e3o";
            }
        }
        return TITULO;
    }

    @Override
    public String getHelpID() {
        return "\u00cdndice";
    }

    private void configurarHelpID() {
        switch (this.getTabbedPane().getSelectedIndex()) {
            case 0: {
                PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "\u00cdndice");
                break;
            }
            case 1: {
                PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "\u00cdndice");
                break;
            }
            case 2: {
                PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, "\u00cdndice");
                break;
            }
        }
    }

    private String getHelpIdAba(int indiceAba) {
        switch (indiceAba) {
            case 0: {
                return "\u00cdndice";
            }
            case 1: {
                return "\u00cdndice";
            }
            case 2: {
                return "\u00cdndice";
            }
        }
        return "";
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_cabecalhoMoedas.png");
    }
}

