/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.especie;

import br.gov.serpro.gcap.entidades.especie.ColecaoOperacaoEspecie;
import br.gov.serpro.gcap.entidades.especie.OperacaoEspecie;
import br.gov.serpro.gcap.gui.TableListaModel;
import java.util.ArrayList;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelOperacoesMoedasEspecie
extends TableListaModel {
    private static final long serialVersionUID = 1L;

    public TableModelOperacoesMoedasEspecie(ObjetoNegocio pObj) {
        super(pObj);
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public int getRowCount() {
        return ((ColecaoOperacaoEspecie)this.getObjetoNegocio()).itens().size() + 1;
    }

    @Override
    public Informacao getInformacaoAt(int row, int col) {
        ColecaoOperacaoEspecie operacoes = (ColecaoOperacaoEspecie)this.getObjetoNegocio();
        Alfa a = new Alfa();
        if (row == 0) {
            switch (col) {
                case 0: {
                    Data data = new Data();
                    data.setConteudo("01/01/" + ConstantesGlobais.EXERCICIO);
                    return data;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return a;
                }
                case 6: {
                    return operacoes.getEstoqueInicial();
                }
                case 7: {
                    return operacoes.getSaldoInicial();
                }
                case 8: {
                    return operacoes.getCustoMedioInicial();
                }
            }
        } else {
            OperacaoEspecie item = (OperacaoEspecie)((Object)operacoes.itens().get(row - 1));
            switch (col) {
                case 0: {
                    return item.getData();
                }
                case 1: {
                    if (item.getTipo().naoFormatado().equals("1")) {
                        return item.getQuantidade();
                    }
                    return a;
                }
                case 2: {
                    if (item.getTipo().naoFormatado().equals("1")) {
                        return item.getValor();
                    }
                    return a;
                }
                case 3: {
                    if (item.getTipo().naoFormatado().equals("2")) {
                        return item.getQuantidade();
                    }
                    return a;
                }
                case 4: {
                    if (item.getTipo().naoFormatado().equals("2")) {
                        return item.getCustoAlienacao();
                    }
                    return a;
                }
                case 5: {
                    if (item.getTipo().naoFormatado().equals("2")) {
                        return item.getGanhoCapital();
                    }
                    return a;
                }
                case 6: {
                    return item.getEstoque();
                }
                case 7: {
                    return item.getSaldo();
                }
                case 8: {
                    return item.getCustoMedio();
                }
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "<html><center>Data</center></html>";
            }
            case 1: {
                return "<html><center>Quantidade de Moeda<br>Estrangeira</center></html>";
            }
            case 2: {
                return "<html><center>Custo Total<br>Aquisi\u00e7\u00e3o (R$)</center></html>";
            }
            case 3: {
                return "<html><center>Quantidade de Moeda<br>Estrangeira</center></html>";
            }
            case 4: {
                return "<html><center>Custo Total<br>Aquisi\u00e7\u00e3o (R$)</center></html>";
            }
            case 5: {
                return "<html><center>Ganho de<br>Capital (R$)</center></html>";
            }
            case 6: {
                return "<html><center>Quantidade de Moeda<br>Estrangeira</center></html>";
            }
            case 7: {
                return "<html><center>Valor<br>Acumulado (R$)</center></html>";
            }
            case 8: {
                return "<html><center>Custo M\u00e9dio<br>Ponderado Unit\u00e1rio</center></html>";
            }
        }
        return "";
    }

    @Override
    public ObjetoNegocio getObjetoNegocio(int rowIndex) {
        return (ObjetoNegocio)((ColecaoOperacaoEspecie)this.getObjetoNegocio()).itens().get(rowIndex - 1);
    }

    @Override
    public void removeObjetoNegocio(Integer[] rowIndexes) {
        ArrayList<OperacaoEspecie> lista = new ArrayList<OperacaoEspecie>();
        for (Integer i : rowIndexes) {
            lista.add((OperacaoEspecie)((Object)((ColecaoOperacaoEspecie)this.getObjetoNegocio()).itens().get(i - 1)));
        }
        ((ColecaoOperacaoEspecie)this.getObjetoNegocio()).itens().removeAll(lista);
        this.refresh();
    }
}

