/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.psocietarias.adquirente;

import br.gov.serpro.gcap.entidades.adquirente.Adquirente;
import br.gov.serpro.gcap.entidades.adquirente.ColecaoAdquirente;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.GCAPTableModelAb;
import br.gov.serpro.gcap.gui.PainelAbaIf;
import br.gov.serpro.gcap.gui.PainelComAbasAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.PainelListaAb;
import br.gov.serpro.gcap.gui.TableLista;
import br.gov.serpro.gcap.gui.TableListaModel;
import br.gov.serpro.gcap.gui.psocietarias.adquirente.PainelAdquirentePSocietariaDetalhe;
import br.gov.serpro.gcap.gui.psocietarias.adquirente.TableModelAdquirentesPSocietaria;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaListaAdquirentePSocietaria
extends PainelListaAb
implements PainelAbaIf {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Adquirentes";
    public static final String NOME_ABA = "Adquirentes";
    public static final String HELP_ID = "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Participa\u00e7\u00e3o Societ\u00e1ria/Adquirentes";
    private PainelDemonstrativoIf painelPai;
    private AlienacaoParticipacaoSocietaria alienacaoParticipacaoSocietaria;

    public PainelAbaListaAdquirentePSocietaria(PainelDemonstrativoIf painelPai) {
        super(false);
        this.painelPai = painelPai;
        this.alienacaoParticipacaoSocietaria = (AlienacaoParticipacaoSocietaria)((PainelComAbasAb)this.painelPai).getDataSource();
        super.construirUI();
    }

    public PainelAbaListaAdquirentePSocietaria(Colecao<? extends ObjetoNegocio> colecao) {
        super(colecao);
    }

    @Override
    public String getTituloPainel() {
        return "Adquirentes";
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        GCAPTableModelAb lModel = (GCAPTableModelAb)this.getTabela().getModel();
        AlienacaoParticipacaoSocietaria alienacao = this.alienacaoParticipacaoSocietaria;
        Adquirente adquirente = new Adquirente();
        alienacao.getAdquirentes().add(adquirente);
        ControladorGui.acionarPainel(new PainelAdquirentePSocietariaDetalhe(this.painelPai, this.alienacaoParticipacaoSocietaria, adquirente, true));
        lModel.refresh();
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            TableModelAdquirentesPSocietaria model = (TableModelAdquirentesPSocietaria)this.getTabela().getModel();
            ColecaoAdquirente colAdquientes = (ColecaoAdquirente)model.getObjetoNegocio();
            Adquirente adquirente = (Adquirente)colAdquientes.itens().get(indiceVetor);
            ControladorGui.acionarPainel(new PainelAdquirentePSocietariaDetalhe(this.painelPai, this.alienacaoParticipacaoSocietaria, adquirente, true));
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }

    @Override
    protected void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(5);
        tcm.getColumn(1).setPreferredWidth(200);
    }

    @Override
    protected TableListaModel getTableModel() {
        this.alienacaoParticipacaoSocietaria = (AlienacaoParticipacaoSocietaria)((PainelComAbasAb)this.painelPai).getDataSource();
        return new TableModelAdquirentesPSocietaria(this.alienacaoParticipacaoSocietaria.getAdquirentes());
    }

    @Override
    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"CPF/CNPJ", "Nome"};
        return tableLista;
    }

    @Override
    protected String getClassePainelNavegacao() {
        return null;
    }

    @Override
    protected String getButtonHelpID() {
        return "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel";
    }

    @Override
    protected int getColunaOrdenacao() {
        return 0;
    }

    @Override
    protected Integer[] getColunasOrdenaveis() {
        return new Integer[]{0, 1};
    }

    @Override
    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens";
    }

    @Override
    public String[] getParametrosMensagemExclusao() {
        return new String[]{"adquirente(s)"};
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_cabecalhoPSocietarias.png");
    }

    @Override
    public void aposCriarAbas() {
    }

    @Override
    public String getNomeAba() {
        return "Adquirentes";
    }

    @Override
    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    @Override
    public boolean isTelaComSubtitulo() {
        return true;
    }

    @Override
    public String getSubtitulo() {
        return this.alienacaoParticipacaoSocietaria.getParticipacaoSocietaria().getNome().naoFormatado();
    }
}

