/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.psocietarias.aquisicao;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.psocietarias.ColecaoOperacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.OperacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.ParcelaAquisicaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.ParticipacaoSocietariaAlienada;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.GCAPListSelectionModel;
import br.gov.serpro.gcap.gui.GCAPTableAb;
import br.gov.serpro.gcap.gui.GCAPTableModelAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.PainelPrincipalAb;
import br.gov.serpro.gcap.gui.TableLista;
import br.gov.serpro.gcap.gui.TableListaCellRenderer;
import br.gov.serpro.gcap.gui.TableListaModel;
import br.gov.serpro.gcap.gui.TableListaSumario;
import br.gov.serpro.gcap.gui.psocietarias.aquisicao.PainelOperacaoCompraParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.psocietarias.aquisicao.PainelOperacaoSaldoInicial;
import br.gov.serpro.gcap.gui.psocietarias.aquisicao.PainelOperacaoVendaParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.psocietarias.aquisicao.TableModelOperacoesParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.table.ColumnGroup;
import br.gov.serpro.gcap.gui.table.GroupableTableColumnModel;
import br.gov.serpro.gcap.gui.table.GroupableTableHeader;
import br.gov.serpro.gcap.gui.util.GCAPTableDecorator;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.impressao.RelatorioPlanilhaCustoAquisicao;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.RetornoValidacao;

public class PainelListaOperacoesParticipacaoSocietaria
extends PainelPrincipalAb {
    private static final long serialVersionUID = 1L;
    private TableListaModel tableListaModel = null;
    public static String TITULO = "Participa\u00e7\u00f5es Societ\u00e1rias - Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o - Planilha";
    public static final String HELP_ID = "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o";
    private ParticipacaoSocietariaAlienada participacaoSocietariaAlienada = null;
    private PainelDemonstrativoIf painelPai;
    private ParcelaAquisicaoParticipacaoSocietaria parcela;
    private JEditValor edtUltimoCustoMedioTransportado;
    private JButton jButtonAbrir;
    private JButton jButtonCancelar;
    private JButton jButtonCompra;
    private JButton jButtonExcluir;
    private JButton jButtonImprimir;
    private JButton jButtonSaldoInicial;
    private JButton jButtonTransportar;
    private JButton jButtonVenda;
    private JLabel jLabel31;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private TableLista tableLista;

    public PainelListaOperacoesParticipacaoSocietaria(boolean construir) {
        if (construir) {
            this.construirUI();
        }
    }

    public PainelListaOperacoesParticipacaoSocietaria() {
        this(true);
    }

    public PainelListaOperacoesParticipacaoSocietaria(PainelDemonstrativoIf painelPai, ParcelaAquisicaoParticipacaoSocietaria parcela) {
        this.painelPai = painelPai;
        this.parcela = parcela;
        this.participacaoSocietariaAlienada = parcela.getParticipacaoSocietariaAlienada();
        this.tableListaModel = new TableModelOperacoesParticipacaoSocietaria(this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria());
        this.construirUI();
        this.habilitarBotaoSaldoInicial();
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    private void habilitarBotaoSaldoInicial() {
        this.jButtonSaldoInicial.setEnabled(true);
        for (OperacaoParticipacaoSocietaria item : this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria().itens()) {
            if (!item.getTipo().naoFormatado().equals("0")) continue;
            this.jButtonSaldoInicial.setEnabled(false);
            break;
        }
    }

    protected void associarInformacao() {
        this.edtUltimoCustoMedioTransportado.setInformacao((Informacao)this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria().getUltimoCustoMedioTransportado());
    }

    protected void configurarAcessibilidade() {
        this.getTabela().getAccessibleContext().setAccessibleName("Planilha de apura\u00e7\u00e3o do custo de aquisi\u00e7\u00e3o");
        this.edtUltimoCustoMedioTransportado.getAccessibleContext().setAccessibleName("\u00daltimo custo m\u00e9dio transportado");
    }

    public void construirUI() {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, this.getButtonHelpID());
        this.initComponents();
        this.associarInformacao();
        this.configurarAcessibilidade();
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        GCAPTableDecorator.decorate(this.getTabela(), this);
        if (this.getTabela().getModel().getRowCount() > 0) {
            this.getTabela().selecionaCelula(0, 0);
        }
    }

    public PainelListaOperacoesParticipacaoSocietaria(Colecao<? extends ObjetoNegocio> colecao) {
        this.construirUI();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.jButtonSaldoInicial = new JButton();
        this.jButtonCompra = new JButton();
        this.jButtonVenda = new JButton();
        this.jButtonImprimir = new JButton();
        this.jButtonAbrir = new JButton();
        this.jButtonExcluir = new JButton();
        this.jButtonTransportar = new JButton();
        this.jButtonCancelar = new JButton();
        this.jPanel1 = new JPanel();
        this.edtUltimoCustoMedioTransportado = new JEditValor();
        this.jLabel31 = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.jScrollPane1.setViewportView(this.tableLista);
        this.jButtonSaldoInicial.setMnemonic('S');
        this.jButtonSaldoInicial.setText("Saldo Inicial");
        this.jButtonSaldoInicial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelListaOperacoesParticipacaoSocietaria.this.jButtonSaldoInicialActionPerformed(evt);
            }
        });
        this.jButtonCompra.setMnemonic('M');
        this.jButtonCompra.setText("Compra");
        this.jButtonCompra.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelListaOperacoesParticipacaoSocietaria.this.jButtonCompraActionPerformed(evt);
            }
        });
        this.jButtonVenda.setMnemonic('V');
        this.jButtonVenda.setText("Venda");
        this.jButtonVenda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelListaOperacoesParticipacaoSocietaria.this.jButtonVendaActionPerformed(evt);
            }
        });
        this.jButtonImprimir.setMnemonic('I');
        this.jButtonImprimir.setText("Imprimir");
        this.jButtonImprimir.setToolTipText("Novo");
        this.jButtonImprimir.setPreferredSize(new Dimension(90, 25));
        this.jButtonImprimir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelListaOperacoesParticipacaoSocietaria.this.jButtonImprimirActionPerformed(evt);
            }
        });
        this.jButtonAbrir.setMnemonic('e');
        this.jButtonAbrir.setText("Editar");
        this.jButtonAbrir.setToolTipText("Editar");
        this.jButtonAbrir.setEnabled(true);
        this.jButtonAbrir.setPreferredSize(new Dimension(90, 25));
        this.jButtonAbrir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelListaOperacoesParticipacaoSocietaria.this.jButtonAbrirActionPerformed(evt);
            }
        });
        this.jButtonExcluir.setMnemonic('x');
        this.jButtonExcluir.setText("Excluir");
        this.jButtonExcluir.setToolTipText("Excluir");
        this.jButtonExcluir.setEnabled(true);
        this.jButtonExcluir.setPreferredSize(new Dimension(90, 25));
        this.jButtonExcluir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelListaOperacoesParticipacaoSocietaria.this.jButtonExcluirActionPerformed(evt);
            }
        });
        this.jButtonTransportar.setMnemonic('T');
        this.jButtonTransportar.setText("Transportar");
        this.jButtonTransportar.setToolTipText("Novo");
        this.jButtonTransportar.setPreferredSize(new Dimension(90, 25));
        this.jButtonTransportar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelListaOperacoesParticipacaoSocietaria.this.jButtonTransportarActionPerformed(evt);
            }
        });
        this.jButtonCancelar.setMnemonic('c');
        this.jButtonCancelar.setText("Cancelar");
        this.jButtonCancelar.setToolTipText("Cancelar");
        this.jButtonCancelar.setPreferredSize(new Dimension(90, 25));
        this.jButtonCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelListaOperacoesParticipacaoSocietaria.this.jButtonCancelarActionPerformed(evt);
            }
        });
        this.jPanel1.setBackground(new Color(234, 242, 251));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.edtUltimoCustoMedioTransportado.setEnabled(false);
        this.jLabel31.setFont(new Font("FreeSans", 1, 12));
        this.jLabel31.setForeground(new Color(0, 74, 106));
        this.jLabel31.setHorizontalAlignment(4);
        this.jLabel31.setText("\u00daltimo custo m\u00e9dio transportado :");
        this.jLabel31.setName("lblMN");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.jLabel31).addPreferredGap(0).add((Component)this.edtUltimoCustoMedioTransportado, -2, 175, -2).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.edtUltimoCustoMedioTransportado, -2, -1, -2).add((Component)this.jLabel31)).addContainerGap()));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonSaldoInicial).add(5, 5, 5).add((Component)this.jButtonCompra).add(5, 5, 5).add((Component)this.jButtonVenda).add(12, 12, 12).add((Component)this.jButtonImprimir, -2, -1, -2).add(5, 5, 5).add((Component)this.jButtonAbrir, -2, -1, -2).add(5, 5, 5).add((Component)this.jButtonExcluir, -2, -1, -2).addPreferredGap(0).add((Component)this.jButtonTransportar, -2, 96, -2).add(5, 5, 5).add((Component)this.jButtonCancelar, -2, -1, -2)).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 162, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jButtonCompra, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonVenda, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonImprimir, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonAbrir, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonExcluir, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonTransportar, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonCancelar, -1, -1, Short.MAX_VALUE).add((Component)this.jButtonSaldoInicial, -1, -1, Short.MAX_VALUE)).add(18, 18, 18).add((Component)this.jPanel1, -2, -1, -2).addContainerGap()));
    }

    private void jButtonSaldoInicialActionPerformed(ActionEvent evt) {
        this.onBtnSaldoInicialClick(evt);
    }

    private void jButtonImprimirActionPerformed(ActionEvent evt) {
        this.onBtnNovoClick(evt);
    }

    private void jButtonAbrirActionPerformed(ActionEvent evt) {
        this.onBtnAbrirClick(evt);
    }

    private void jButtonExcluirActionPerformed(ActionEvent evt) {
        this.onBtnExcluirClick(evt);
    }

    private void jButtonTransportarActionPerformed(ActionEvent evt) {
        this.onBtnTransportarClick(evt);
    }

    private void jButtonCancelarActionPerformed(ActionEvent evt) {
        this.onBtnCancelarClick(evt);
    }

    private void jButtonCompraActionPerformed(ActionEvent evt) {
        this.onBtnCompraClick(evt);
    }

    private void jButtonVendaActionPerformed(ActionEvent evt) {
        this.onBtnVendaClick(evt);
    }

    @Override
    public GCAPTableAb getTabela() {
        return this.tableLista;
    }

    protected void configurarTamanhoColunas() {
    }

    protected TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis){

            @Override
            protected void configuraLayoutHeader() {
                super.configuraLayoutHeader();
                this.setColumnModel(new GroupableTableColumnModel());
                this.setTableHeader(new GroupableTableHeader(this.getColumnModel()));
                this.getTableHeader().setForeground(new Color(0, 74, 106));
                this.getTableHeader().setBackground(new Color(213, 231, 245));
                this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(1));
            }

            @Override
            protected void configuraLayout() {
                super.configuraLayout();
                final GroupableTableColumnModel cm = (GroupableTableColumnModel)this.getColumnModel();
                ColumnGroup cgVazio = new ColumnGroup("");
                ColumnGroup cgEntrada = new ColumnGroup("<HTML><CENTER>Entrada</CENTER></HTML>"){

                    @Override
                    public Dimension getSize(JTable table) {
                        return new Dimension(cm.getColumn(1).getWidth() + cm.getColumn(2).getWidth(), 20);
                    }
                };
                cgEntrada.add(cm.getColumn(1));
                cgEntrada.add(cm.getColumn(2));
                ColumnGroup cgSaida = new ColumnGroup("<HTML><CENTER>Sa\u00edda</CENTER></HTML>"){

                    @Override
                    public Dimension getSize(JTable table) {
                        return new Dimension(cm.getColumn(3).getWidth() + cm.getColumn(4).getWidth(), 20);
                    }
                };
                cgSaida.add(cm.getColumn(3));
                cgSaida.add(cm.getColumn(4));
                ColumnGroup cgSaldo = new ColumnGroup("<HTML><CENTER>Saldo</CENTER></HTML>"){

                    @Override
                    public Dimension getSize(JTable table) {
                        return new Dimension(cm.getColumn(5).getWidth() + cm.getColumn(6).getWidth() + cm.getColumn(7).getWidth(), 20);
                    }
                };
                cgSaldo.add(cm.getColumn(5));
                cgSaldo.add(cm.getColumn(6));
                cgSaldo.add(cm.getColumn(7));
                cm.addColumnGroup(cgVazio);
                cm.addColumnGroup(cgEntrada);
                cm.addColumnGroup(cgSaida);
                cm.addColumnGroup(cgSaldo);
                this.getTableHeader().setPreferredSize(new Dimension(this.getTableHeader().getWidth(), 80));
            }
        };
        tableLista.accessibleColumnHeader = new String[]{"Data", "Quantidade de Entrada", "Custo Total de Aquisi\u00e7\u00e3o", "Quantidade de Sa\u00edda", "Custo Total", "Quantidade", "Valor Acumulado", "Custo M\u00e9dio Ponderado Unit\u00e1rio"};
        tableLista.setSelectionModel(new GCAPListSelectionModel(model.getRowCount()){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                super.setSelectionInterval(index0, index1);
            }

            @Override
            public void addSelectionInterval(int index0, int index1) {
                super.addSelectionInterval(index0, index1);
            }
        });
        tableLista.setDefaultRenderer(Object.class, new TableListaCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component retorno = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    this.setBackground(Color.WHITE);
                }
                this.setFont(this.getFont().deriveFont(0));
                if (retorno instanceof JLabel && value != null && value instanceof Informacao) {
                    JLabel lRetorno = (JLabel)retorno;
                    Informacao info = (Informacao)value;
                    RetornoValidacao ret = info.validar().getPrimeiroRetornoValidacaoMaisSevero();
                    if (ret != null && !ret.isValido()) {
                        lRetorno.setForeground(Color.RED);
                    } else {
                        lRetorno.setForeground(null);
                    }
                }
                return retorno;
            }
        });
        return tableLista;
    }

    protected String getClassePainelNavegacao() {
        return null;
    }

    protected String getButtonHelpID() {
        return HELP_ID;
    }

    protected int getColunaOrdenacao() {
        return 0;
    }

    protected Integer[] getColunasOrdenaveis() {
        return null;
    }

    protected TableListaModel getTableModel() {
        return this.tableListaModel;
    }

    @Override
    public void preExibir() {
        if (((GCAPTableModelAb)this.getTabela().getModel()).getObjetoNegocio() instanceof Colecao) {
            ((Colecao)((GCAPTableModelAb)this.getTabela().getModel()).getObjetoNegocio()).excluirRegistrosEmBranco();
        }
        ((GCAPTableModelAb)this.getTabela().getModel()).refresh();
    }

    @Override
    public void onBtnExcluirClick(ActionEvent e) {
        GCAPTableAb tabela = this.getTabela();
        boolean temSumario = tabela instanceof TableListaSumario;
        if (!(tabela.getSelectedRowCount() <= 0 || temSumario && tabela.getSelectedRow() >= tabela.getRowCount())) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirmaNaoPadrao(this.getMensagemExclusao(), this.getParametrosMensagemExclusao())) {
                TableListaModel model = (TableListaModel)tabela.getModel();
                ArrayList<Integer> linhasExcluidas = new ArrayList<Integer>();
                for (int linhaTabela : linhasTabela) {
                    ObjetoNegocio objetoNegocio;
                    int indiceVetor;
                    if ((!temSumario || linhaTabela >= tabela.getRowCount()) && temSumario || !this.validarExclusao(indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela), objetoNegocio = model.getObjetoNegocio(indiceVetor))) continue;
                    linhasExcluidas.add(new Integer(indiceVetor));
                }
                model.removeObjetoNegocio(linhasExcluidas.toArray(new Integer[linhasExcluidas.size()]));
                this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria().recalcularGanhoTotal();
            }
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
        this.habilitarBotaoSaldoInicial();
    }

    @Override
    public void onBtnClick(int index, ActionEvent e) {
    }

    public boolean validarExclusao(int row, ObjetoNegocio objetoNegocio) {
        return this.validarExclusao(objetoNegocio);
    }

    public boolean validarExclusao(ObjetoNegocio objetoNegocio) {
        return true;
    }

    public String getMensagemExclusao() {
        return "ConfirmaExcluirItens";
    }

    public String[] getParametrosMensagemExclusao() {
        return new String[]{"opera\u00e7\u00e3o(\u00f5es)"};
    }

    @Override
    public String getHelpID() {
        return this.getButtonHelpID();
    }

    @Override
    public void onBtnNovoClick(ActionEvent e) {
        new RelatorioPlanilhaCustoAquisicao(this.parcela).imprimir();
    }

    @Override
    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            OperacaoParticipacaoSocietaria operacao = (OperacaoParticipacaoSocietaria)((Object)this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria().itens().get(indiceVetor));
            if (operacao.getTipo().naoFormatado().equals("1")) {
                ControladorGui.acionarPainel(new PainelOperacaoCompraParticipacaoSocietaria(this, "Altera\u00e7\u00e3o da Opera\u00e7\u00e3o de Compra", this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria(), indiceVetor, false));
            } else if (operacao.getTipo().naoFormatado().equals("2")) {
                ControladorGui.acionarPainel(new PainelOperacaoVendaParticipacaoSocietaria(this, "Altera\u00e7\u00e3o da Opera\u00e7\u00e3o de Venda", this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria(), indiceVetor, false));
            }
            if (operacao.getTipo().naoFormatado().equals("0")) {
                ((OperacaoParticipacaoSocietaria)((Object)this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria().itens().get(indiceVetor))).getData().setReadOnly(true);
                ControladorGui.acionarPainel(new PainelOperacaoSaldoInicial(this, "Altera\u00e7\u00e3o do Saldo Incial", this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria(), indiceVetor, false));
            }
        } else {
            GuiUtil.mostrarAviso("ErroSelecioneItem");
        }
    }

    public void onBtnSaldoInicialClick(ActionEvent e) {
        int ordem = this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria().inserirNovaOperacaoSaldoInicial();
        ControladorGui.acionarPainel(new PainelOperacaoSaldoInicial(this, " Novo Saldo Inicial", this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria(), ordem, true));
        GCAPTableModelAb lModel = (GCAPTableModelAb)this.getTabela().getModel();
        lModel.refresh();
        this.habilitarBotaoSaldoInicial();
    }

    public void onBtnCompraClick(ActionEvent e) {
        int ordem = this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria().inserirNovaOperacaoCompra();
        ControladorGui.acionarPainel(new PainelOperacaoCompraParticipacaoSocietaria(this, "Nova Opera\u00e7\u00e3o de Compra", this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria(), ordem, true));
        GCAPTableModelAb lModel = (GCAPTableModelAb)this.getTabela().getModel();
        lModel.refresh();
    }

    public void onBtnVendaClick(ActionEvent e) {
        int ordem = this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria().inserirNovaOperacaoVenda();
        ControladorGui.acionarPainel(new PainelOperacaoVendaParticipacaoSocietaria(this, " Nova Opera\u00e7\u00e3o de Venda", this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria(), ordem, true));
        GCAPTableModelAb lModel = (GCAPTableModelAb)this.getTabela().getModel();
        lModel.refresh();
    }

    public void onBtnTransportarClick(ActionEvent evt) {
        ColecaoOperacaoParticipacaoSocietaria colecao = this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria();
        if (!colecao.isVazio()) {
            ValorPositivo ultimoCustoMedio = ((OperacaoParticipacaoSocietaria)((Object)colecao.itens().get(colecao.itens().size() - 1))).getCustoMedio();
            colecao.getUltimoCustoMedioTransportado().setConteudo(ultimoCustoMedio);
            this.parcela.getCustoMedio().setConteudo(ultimoCustoMedio);
        }
        this.executaVoltar();
    }

    private void onBtnCancelarClick(ActionEvent evt) {
        this.executaVoltar();
    }

    @Override
    public void executaVoltar() {
        this.participacaoSocietariaAlienada.getOperacoesParticipacaoSocietaria().excluirRegistrosEmBranco();
        ControladorGui.acionarPainel(this.painelPai);
    }

    @Override
    public JComponent getDefaultFocus() {
        if (this.tableListaModel.getRowCount() > 0) {
            return this.tableLista;
        }
        return this.jButtonSaldoInicial;
    }
}

