/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.psocietarias.aquisicao;

import br.gov.serpro.gcap.entidades.psocietarias.ColecaoOperacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.OperacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.PainelDemonstrativoAb;
import br.gov.serpro.gcap.gui.PainelDemonstrativoIf;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class PainelOperacaoVendaParticipacaoSocietaria
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    public static final String TITULO = "Participa\u00e7\u00f5es Societ\u00e1rias - Apura\u00e7\u00e3o do Custo de Aquisi\u00e7\u00e3o - Venda";
    public static final String HELP_ID = "Instru\u00e7\u00f5es para o Preenchimento/Fichas do Programa Ganhos de Capital/Aliena\u00e7\u00e3o de Bem ou Direito - Bem M\u00f3vel/Identifica\u00e7\u00e3o";
    private int ordem = -1;
    private ColecaoOperacaoParticipacaoSocietaria operacoes = null;
    private PainelDemonstrativoIf painelPai = null;
    private String subtitulo = null;
    private boolean novaOperacao = false;
    private OperacaoParticipacaoSocietaria operacaoCopia = null;
    private JEditData edtData;
    private JEditValor edtQuantidade;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JLabel lblTitulo;

    public PainelOperacaoVendaParticipacaoSocietaria() {
        this.initComponents();
    }

    public PainelOperacaoVendaParticipacaoSocietaria(PainelDemonstrativoIf painelPai, String subtitulo, ColecaoOperacaoParticipacaoSocietaria operacoes, int ordem, boolean novaOperacao) {
        this.ordem = ordem;
        this.operacoes = operacoes;
        this.painelPai = painelPai;
        this.subtitulo = subtitulo;
        this.novaOperacao = novaOperacao;
        this.operacaoCopia = new OperacaoParticipacaoSocietaria();
        this.copiarOperacao(this.operacaoCopia, this.getOperacaoParticipacaoSocietaria());
        this.initComponents();
        this.associarInformacao();
        this.configurarAcessibilidade();
        this.edtData.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                PainelOperacaoVendaParticipacaoSocietaria.this.atualizarData();
            }
        });
    }

    private void copiarOperacao(OperacaoParticipacaoSocietaria operacaoCopia, OperacaoParticipacaoSocietaria operacao) {
        operacaoCopia.getData().setConteudo(operacao.getData());
        operacaoCopia.getQuantidade().setConteudo(operacao.getQuantidade());
        operacaoCopia.getValor().setConteudo(operacao.getValor());
        operacaoCopia.getCustoMedio().setConteudo(operacao.getCustoMedio());
        operacaoCopia.getCustoAlienacao().setConteudo(operacao.getCustoAlienacao());
    }

    protected void associarInformacao() {
        this.edtData.setInformacao((Informacao)this.getOperacaoParticipacaoSocietaria().getData());
        this.edtQuantidade.setInformacao((Informacao)this.getOperacaoParticipacaoSocietaria().getQuantidade());
    }

    protected void configurarAcessibilidade() {
        this.edtData.getAccessibleContext().setAccessibleName("Data da aliena\u00e7\u00e3o");
        this.edtQuantidade.getAccessibleContext().setAccessibleName("Quantidade");
    }

    protected void atualizarData() {
        this.ordem = this.getOperacoes().alterarOrdemOperacaoParticipacaoSocietaria(this.getOrdem());
    }

    public OperacaoParticipacaoSocietaria getOperacaoParticipacaoSocietaria() {
        return (OperacaoParticipacaoSocietaria)((Object)this.getOperacoes().itens().get(this.getOrdem()));
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.edtData;
    }

    @Override
    public String getTituloPainel() {
        return TITULO;
    }

    @Override
    public boolean isTelaComVoltar() {
        return true;
    }

    @Override
    public void executaVoltar() {
        ControladorGui.acionarPainel(this.painelPai);
    }

    @Override
    public boolean isTelaComCancelar() {
        return true;
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_cabecalhoPSocietarias.png");
    }

    @Override
    public String getHelpID() {
        return HELP_ID;
    }

    @Override
    public boolean isTelaComSubtitulo() {
        return true;
    }

    @Override
    public String getSubtitulo() {
        return this.subtitulo;
    }

    @Override
    public void executaCancelar() {
        if (this.isNovaOperacao()) {
            this.getOperacoes().remove(this.getOrdem());
        } else {
            this.copiarOperacao(this.getOperacaoParticipacaoSocietaria(), this.operacaoCopia);
        }
        ControladorGui.acionarPainel(this.painelPai);
    }

    private void initComponents() {
        this.lblTitulo = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel5 = new JLabel();
        this.edtData = new JEditData();
        this.jLabel6 = new JLabel();
        this.edtQuantidade = new JEditValor();
        this.lblTitulo.setFont(new Font("DejaVu Sans", 1, 13));
        this.lblTitulo.setForeground(new Color(107, 151, 9));
        this.lblTitulo.setText("Dados da Opera\u00e7\u00e3o");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel5.setText("<html>Data da aliena\u00e7\u00e3o: <font color=red>*</font></html>");
        this.edtData.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelOperacaoVendaParticipacaoSocietaria.this.edtDataFocusLost(evt);
            }
        });
        this.jLabel6.setText("<html>Quantidade: <font color=red>*</font></html>");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, -1, -2).addComponent((Component)this.edtData, -2, 144, -2)).addGap(66, 66, 66).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent((Component)this.edtQuantidade, GroupLayout.Alignment.LEADING, -2, 175, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5, -2, -1, -2).addComponent(this.jLabel6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)this.edtData, -2, -1, -2).addComponent((Component)this.edtQuantidade, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.lblTitulo).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblTitulo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void edtDataFocusLost(FocusEvent evt) {
    }

    public int getOrdem() {
        return this.ordem;
    }

    public ColecaoOperacaoParticipacaoSocietaria getOperacoes() {
        return this.operacoes;
    }

    public boolean isNovaOperacao() {
        return this.novaOperacao;
    }
}

