/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.gui.table;

import br.gov.serpro.gcap.gui.table.ColumnGroup;
import br.gov.serpro.gcap.gui.table.GroupableTableHeaderUI;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GroupableTableHeader
extends JTableHeader {
    private static final long serialVersionUID = 1L;
    private static final String uiClassID = "GroupableTableHeaderUI";
    protected Vector<ColumnGroup> columnGroups = null;

    public GroupableTableHeader(TableColumnModel model) {
        super(model);
        this.setUI(new GroupableTableHeaderUI());
        this.setReorderingAllowed(false);
    }

    @Override
    public void setReorderingAllowed(boolean b) {
        this.reorderingAllowed = false;
    }

    public void addColumnGroup(ColumnGroup g) {
        if (this.columnGroups == null) {
            this.columnGroups = new Vector();
        }
        this.columnGroups.addElement(g);
    }

    public Enumeration<Object> getColumnGroups(TableColumn col) {
        if (this.columnGroups == null) {
            return null;
        }
        Enumeration<ColumnGroup> en = this.columnGroups.elements();
        while (en.hasMoreElements()) {
            ColumnGroup cGroup = en.nextElement();
            Vector<Object> v_ret = cGroup.getColumnGroups(col, new Vector<Object>());
            if (v_ret == null) continue;
            return v_ret.elements();
        }
        return null;
    }

    public void setColumnMargin() {
        if (this.columnGroups == null) {
            return;
        }
        int columnMargin = this.getColumnModel().getColumnMargin();
        Enumeration<ColumnGroup> en = this.columnGroups.elements();
        while (en.hasMoreElements()) {
            ColumnGroup cGroup = en.nextElement();
            cGroup.setColumnMargin(columnMargin);
        }
    }
}

