/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.importacao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.importacao.RepositorioXMLDadosGCAP;
import br.gov.serpro.gcap.util.GcapUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public class ProcessoImportacaoGCAP {
    public DemonstrativoGCAP importar(File arquivoZip) throws AplicacaoException {
        if (!arquivoZip.exists()) {
            throw new AplicacaoException("arquivo_inexistente");
        }
        File dirDestino = this.criarDiretorioDestino(arquivoZip);
        if (dirDestino == null) {
            throw new AplicacaoException("gcap_falha_lendo_demonstrativo");
        }
        try {
            File arqXML = this.descompatarDemonstrativo(arquivoZip, dirDestino);
            RepositorioXMLDadosGCAP repositorioXml = new RepositorioXMLDadosGCAP();
            DemonstrativoGCAP demonstrativoGCAP = repositorioXml.importaDados(arqXML);
            return demonstrativoGCAP;
        }
        catch (Exception ex) {
            if (ex instanceof AplicacaoException) {
                throw (AplicacaoException)ex;
            }
            throw new AplicacaoException("demonstrativo_gcap_corrompido");
        }
        finally {
            if (dirDestino != null) {
                try {
                    FileUtils.deleteDirectory((File)dirDestino);
                }
                catch (IOException iOException) {}
            }
        }
    }

    private File descompatarDemonstrativo(File arquivoZip, File dirDestino) throws AplicacaoException {
        File arqXML = null;
        try {
            ZipEntry e;
            if (dirDestino == null) {
                throw new AplicacaoException("gcap_falha_lendo_demonstrativo");
            }
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(arquivoZip));
            ZipInputStream zin = new ZipInputStream(in);
            while ((e = zin.getNextEntry()) != null) {
                try (FileOutputStream out = new FileOutputStream(dirDestino.getAbsoluteFile() + File.separator + e.getName());){
                    byte[] b = new byte[512];
                    int len = 0;
                    while ((len = zin.read(b)) != -1) {
                        out.write(b, 0, len);
                    }
                }
                if (arquivoZip.getName().length() != e.getName().length() || e.getName().length() <= 11) continue;
                arqXML = new File(dirDestino.getAbsolutePath() + File.separator + e.getName());
            }
            return arqXML;
        }
        catch (IOException ioex) {
            throw new AplicacaoException("gcap_falha_lendo_demonstrativo");
        }
    }

    private File criarDiretorioDestino(File arquivoZip) {
        File dirDestino = null;
        boolean criouDirTemp = false;
        String nomeDirSugerido = null;
        for (int tentativa = 1; !criouDirTemp && tentativa <= 2; ++tentativa) {
            nomeDirSugerido = String.valueOf(new Date().getTime());
            dirDestino = new File(GcapUtil.DIR_DADOS + File.separator + nomeDirSugerido);
            if (dirDestino.exists() || !dirDestino.mkdir()) continue;
            criouDirTemp = true;
        }
        return dirDestino;
    }
}

