/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.impressao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.impressao.RelatorioGCAP;
import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import br.gov.serpro.gcap.util.DataUtil;
import br.gov.serpro.gcap.util.GcapUtil;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import serpro.ppgd.formatosexternos.RelatorioXML;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.ObjetoNegocio;

public class RelatorioDarf
extends RelatorioGCAP {
    private static final String NOME_RELATORIO = "relDarf.jasper";
    private static final String TITULO_RELATORIO = "Documento de Arrecada\u00e7\u00e3o de Receitas Federais";
    public static String ULTIMO_DIA_DECLARACAO_IRPF_POSTERIOR = "30/04/" + ConstantesGlobais.EXERCICIO_POSTERIOR;
    public static Map<Integer, String> vencimentos;
    private int[] meses;

    public static void recarregarDatasVencimento() {
        List<ElementoTabela> datasVencimento = CadastroTabelasGCAP.recuperarDatasVencimento(1);
        vencimentos = new HashMap<Integer, String>();
        try {
            for (int meses = 1; meses <= 12; ++meses) {
                vencimentos.put(meses, DataUtil.converterFormatoDatayyyyMMddParaddMMyyyy(datasVencimento.get(meses - 1).getConteudo(1), true));
            }
        }
        catch (AplicacaoException ex) {
            GuiUtil.mostrarErro(null, ex.getMessage());
        }
    }

    private boolean isMesConsiderado(int pMes) {
        if (this.meses == null) {
            return true;
        }
        for (int mes : this.meses) {
            if (pMes != mes + 1) continue;
            return true;
        }
        return false;
    }

    private RelatorioXML criarRelatorio(String pObservacao, String pCpfContribuinte, String pDataVencimento, String pNomeContribuinte, String pTelefone, String pDDDTelefone, String pValorQuota, String pPeriodoApuracao, String pCodigoReceita) {
        RelatorioXML relatorio = new RelatorioXML(TITULO_RELATORIO, NOME_RELATORIO, "", "/classe");
        relatorio.addParametro("PATH", "");
        relatorio.addParametro("icone", "imagens/brasao.jpg");
        relatorio.addParametro("observacao", pObservacao);
        relatorio.addParametro("nirf", pCpfContribuinte);
        relatorio.addParametro("dataVencimento", pDataVencimento);
        relatorio.addParametro("nome", pNomeContribuinte);
        relatorio.addParametro("exercicio", "");
        relatorio.addParametro("anoBase", "");
        relatorio.addParametro("Telefone", pTelefone);
        relatorio.addParametro("DDDTelefone", pDDDTelefone);
        relatorio.addParametro("ValorQuota", pValorQuota);
        relatorio.addParametro("periodoApuracao", pPeriodoApuracao);
        relatorio.addParametro("cod", pCodigoReceita);
        return relatorio;
    }

    private void adicionarRelatoriosBem(List<RelatorioXML> pRelatorios, DemonstrativoGCAP pDemonstrativo, Alienacao pBem) {
        String lPeriodoApuracao = null;
        Integer lMesAlienacao = null;
        BigInteger lValorQuota = null;
        String lValorQuotaFormatado = null;
        Data lData = pBem.getDataAlienacao();
        if (String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS).equals(pBem.getNatureza().naoFormatado())) {
            lData = pBem.getMotivoTransmissaoCausaMortisDecisaoJudicial().naoFormatado().equals("1") ? pBem.getDataTransitoJulgado() : pBem.getDataAlienacao();
        }
        if (lData.isVazio()) {
            return;
        }
        lPeriodoApuracao = lData.formatado();
        lMesAlienacao = Integer.valueOf(lData.getMes());
        if (pBem instanceof AlienacaoBem) {
            lValorQuota = pBem.getCalculoImposto().getImpostoDevido2().getConteudoBigInteger();
            lValorQuotaFormatado = pBem.getCalculoImposto().getImpostoDevido2().formatado();
        } else {
            lValorQuota = ((AlienacaoParticipacaoSocietaria)pBem).getCalculoImposto().getImpostoDevido2().getConteudoBigInteger();
            lValorQuotaFormatado = ((AlienacaoParticipacaoSocietaria)pBem).getCalculoImposto().getImpostoDevido2().formatado();
        }
        String lCodigoReceita = null;
        lCodigoReceita = "105".equals(pBem.getPaisResidencia().asString()) ? (pBem.isAlienacaoBrasil() ? "4600" : "8523") : "0473";
        RelatorioDarf.recarregarDatasVencimento();
        if (pBem.isAlienacaoAPrazo()) {
            if (pBem instanceof AlienacaoBem) {
                for (ObjetoNegocio objetoNegocio : ((AlienacaoBem)pBem).getColecaoParcelaAlienacao().itens()) {
                    ParcelaAlienacao parcela = (ParcelaAlienacao)objetoNegocio;
                    lMesAlienacao = Integer.valueOf(parcela.getDataRecebimento().getMes());
                    if (lMesAlienacao == 0 || !this.isMesConsiderado(lMesAlienacao)) continue;
                    lValorQuota = parcela.getImpostoDevido2().getConteudoBigInteger();
                    lValorQuotaFormatado = parcela.getImpostoDevido2().getConteudoFormatado();
                    if (lValorQuota.equals(BigInteger.ZERO)) continue;
                    if (lValorQuota.compareTo(new BigInteger("1000")) < 0) {
                        GuiUtil.mostrarInfo("ValorMinimoEmissaoDarf", new String[]{"10,00"});
                        continue;
                    }
                    String lVencimento = "";
                    lVencimento = GcapUtil.isDeclaracaoBrasileira(pBem) ? vencimentos.get(lMesAlienacao) : parcela.getDataRecebimento().formatado();
                    if (GcapUtil.isDeclaracaoBrasileira(pBem)) {
                        pRelatorios.add(this.criarRelatorio("", pDemonstrativo.getIdDemonstrativo().getCpf().formatado(), lVencimento, pDemonstrativo.getIdDemonstrativo().getNome().formatado(), pDemonstrativo.getIdDemonstrativo().getTelefoneDeclarante().formatado(), pDemonstrativo.getIdDemonstrativo().getDddDeclarante().formatado(), lValorQuotaFormatado, lPeriodoApuracao, lCodigoReceita));
                        continue;
                    }
                    pRelatorios.add(this.criarRelatorio("", pDemonstrativo.getIdDemonstrativo().getCpf().formatado(), lVencimento, pDemonstrativo.getIdDemonstrativo().getNome().formatado(), pDemonstrativo.getIdDemonstrativo().getTelefoneDeclarante().formatado(), pDemonstrativo.getIdDemonstrativo().getDddDeclarante().formatado(), lValorQuotaFormatado, lPeriodoApuracao, lCodigoReceita));
                }
            } else {
                AlienacaoParticipacaoSocietaria alienacaoPSoc = (AlienacaoParticipacaoSocietaria)pBem;
                for (ObjetoNegocio objetoNegocio : alienacaoPSoc.getColecaoParcelaAlienacao().itens()) {
                    ParcelaAlienacao parcela = (ParcelaAlienacao)objetoNegocio;
                    lMesAlienacao = Integer.valueOf(parcela.getDataRecebimento().getMes());
                    if (lMesAlienacao == 0 || !this.isMesConsiderado(lMesAlienacao)) continue;
                    lValorQuota = parcela.getImpostoDevido2().getConteudoBigInteger();
                    lValorQuotaFormatado = parcela.getImpostoDevido2().getConteudoFormatado();
                    if (lValorQuota.equals(BigInteger.ZERO)) continue;
                    if (lValorQuota.compareTo(new BigInteger("1000")) < 0) {
                        GuiUtil.mostrarInfo("ValorMinimoEmissaoDarf", new String[]{"10,00"});
                        continue;
                    }
                    String lVencimento = "";
                    lVencimento = GcapUtil.isDeclaracaoBrasileira(pBem) ? vencimentos.get(lMesAlienacao) : parcela.getDataRecebimento().formatado();
                    if (GcapUtil.isDeclaracaoBrasileira(pBem)) {
                        pRelatorios.add(this.criarRelatorio("", pDemonstrativo.getIdDemonstrativo().getCpf().formatado(), lVencimento, pDemonstrativo.getIdDemonstrativo().getNome().formatado(), pDemonstrativo.getIdDemonstrativo().getTelefoneDeclarante().formatado(), pDemonstrativo.getIdDemonstrativo().getDddDeclarante().formatado(), lValorQuotaFormatado, lPeriodoApuracao, lCodigoReceita));
                        continue;
                    }
                    pRelatorios.add(this.criarRelatorio("", pDemonstrativo.getIdDemonstrativo().getCpf().formatado(), lVencimento, pDemonstrativo.getIdDemonstrativo().getNome().formatado(), pDemonstrativo.getIdDemonstrativo().getTelefoneDeclarante().formatado(), pDemonstrativo.getIdDemonstrativo().getDddDeclarante().formatado(), lValorQuotaFormatado, lPeriodoApuracao, lCodigoReceita));
                }
            }
        } else if (pBem.isAlienacaoAVista() && this.isMesConsiderado(lMesAlienacao)) {
            if (lValorQuota.equals(BigInteger.ZERO)) {
                return;
            }
            if (lValorQuota.compareTo(new BigInteger("1000")) < 0) {
                GuiUtil.mostrarInfo("ValorMinimoEmissaoDarf", new String[]{"10,00"});
                return;
            }
            String lVencimento = vencimentos.get(lMesAlienacao);
            if (pBem.getNatureza().getConteudoAtual(0).equals(String.valueOf(AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS))) {
                lVencimento = pBem.calculaDataVencimentoDarfCausaMortis().formatado();
            }
            if (GcapUtil.isDeclaracaoBrasileira(pBem)) {
                pRelatorios.add(this.criarRelatorio("", pDemonstrativo.getIdDemonstrativo().getCpf().formatado(), lVencimento, pDemonstrativo.getIdDemonstrativo().getNome().formatado(), pDemonstrativo.getIdDemonstrativo().getTelefoneDeclarante().formatado(), pDemonstrativo.getIdDemonstrativo().getDddDeclarante().formatado(), lValorQuotaFormatado, lPeriodoApuracao, lCodigoReceita));
            } else {
                pRelatorios.add(this.criarRelatorio("", pDemonstrativo.getIdDemonstrativo().getCpf().formatado(), lPeriodoApuracao, pDemonstrativo.getIdDemonstrativo().getNome().formatado(), pDemonstrativo.getIdDemonstrativo().getTelefoneDeclarante().formatado(), pDemonstrativo.getIdDemonstrativo().getDddDeclarante().formatado(), lValorQuotaFormatado, lPeriodoApuracao, lCodigoReceita));
            }
        }
    }

    private String calculaDataVencimentoDarfCausaMortis(Data dataVencimento) {
        Data data = new Data();
        if (Integer.valueOf(dataVencimento.getMes()) < 3) {
            data.setConteudo("30/04/" + dataVencimento.getAno());
        } else {
            data.setConteudo("30/04/" + (Integer.valueOf(dataVencimento.getAno()) + 1));
        }
        Calendar calendario = Calendar.getInstance();
        calendario.setTime(data.asDate());
        if (calendario.get(7) == 1) {
            calendario.add(5, -2);
        } else if (calendario.get(7) == 7) {
            calendario.add(5, -1);
        }
        String lVencimento = new SimpleDateFormat("dd/MM/yyyy").format(calendario.getTime());
        return lVencimento;
    }

    @Override
    protected void adicionarRelatorioConsolidado(List<RelatorioXML> pRelatorios, DemonstrativoGCAP pDemonstrativo) {
    }

    public RelatorioDarf(DemonstrativoGCAP[] pDemonstrativos, int[] pMeses) {
        super(pDemonstrativos);
        this.meses = pMeses;
    }

    public RelatorioDarf(DemonstrativoGCAP pDemonstrativo, int[][] pItemDados, int[] pMeses) {
        super(pDemonstrativo, pItemDados);
        this.meses = pMeses;
    }

    public RelatorioDarf(DemonstrativoGCAP pDemonstrativo, boolean imprimirDarfMoedaEspecie) {
        super(pDemonstrativo, imprimirDarfMoedaEspecie);
    }

    @Override
    protected void adicionarRelatorios(List<RelatorioXML> pRelatorios, DemonstrativoGCAP pDemonstrativo, AlienacaoBemImovel pItemDadosBemImovel) {
        this.adicionarRelatoriosBem(pRelatorios, pDemonstrativo, pItemDadosBemImovel);
    }

    @Override
    protected void adicionarRelatorios(List<RelatorioXML> pRelatorios, DemonstrativoGCAP pDemonstrativo, AlienacaoBemMovel pItemDadosBemMovel) {
        this.adicionarRelatoriosBem(pRelatorios, pDemonstrativo, pItemDadosBemMovel);
    }

    @Override
    protected void adicionarRelatorios(List<RelatorioXML> pRelatorios, DemonstrativoGCAP pDemonstrativo, AlienacaoParticipacaoSocietaria pItemDados) {
        this.adicionarRelatoriosBem(pRelatorios, pDemonstrativo, pItemDados);
    }

    @Override
    protected void adicionarRelatorios(List<RelatorioXML> pRelatorios, DemonstrativoGCAP pDemonstrativo, ColecaoMoedaAlienada colecaoMoedaAlienada) {
        this.adicionarRelatorioMoedasAlienadas(pRelatorios, pDemonstrativo, colecaoMoedaAlienada);
    }

    private void adicionarRelatorioMoedasAlienadas(List<RelatorioXML> pRelatorios, DemonstrativoGCAP pDemonstrativo, ColecaoMoedaAlienada colecaoMoedaAlienada) {
        BigInteger lValorQuota = null;
        String lValorQuotaFormatado = null;
        String lPeriodoApuracao = "31/12/" + ConstantesGlobais.EXERCICIO;
        lValorQuota = colecaoMoedaAlienada.getImpostoDevido().getConteudoBigInteger();
        lValorQuotaFormatado = colecaoMoedaAlienada.getImpostoDevido().formatado();
        String lCodigoReceita = "8960";
        if (lValorQuota.equals(BigInteger.ZERO)) {
            return;
        }
        if (lValorQuota.compareTo(new BigInteger("1000")) < 0) {
            GuiUtil.mostrarInfo("ValorMinimoEmissaoDarf", new String[]{"10,00"});
            return;
        }
        String lVencimento = this.calculaDataVencimentoMoedasAlienadas();
        pRelatorios.add(this.criarRelatorio("", pDemonstrativo.getIdDemonstrativo().getCpf().formatado(), lVencimento, pDemonstrativo.getIdDemonstrativo().getNome().formatado(), pDemonstrativo.getIdDemonstrativo().getTelefoneDeclarante().formatado(), pDemonstrativo.getIdDemonstrativo().getDddDeclarante().formatado(), lValorQuotaFormatado, lPeriodoApuracao, lCodigoReceita));
    }

    private String calculaDataVencimentoMoedasAlienadas() {
        Data data = new Data();
        data.setConteudo("30/04/" + ConstantesGlobais.EXERCICIO_POSTERIOR);
        Calendar calendario = Calendar.getInstance();
        calendario.setTime(data.asDate());
        if (calendario.get(7) == 1) {
            calendario.add(5, -2);
        } else if (calendario.get(7) == 7) {
            calendario.add(5, -1);
        }
        String lVencimento = new SimpleDateFormat("dd/MM/yyyy").format(calendario.getTime());
        return lVencimento;
    }

    @Override
    protected boolean isPaginado() {
        return false;
    }

    @Override
    protected String obterExtensaoArquivoRelatorio() {
        return "-darf.pdf";
    }
}

