/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.impressao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.especie.ColecaoMoedaAlienada;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.impressao.RelatorioDarf;
import br.gov.serpro.gcap.impressao.RelatorioDemonstrativo;
import br.gov.serpro.gcap.impressao.RelatorioMultiploXMLGCAP;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.formatosexternos.RelatorioXML;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;

public abstract class RelatorioGCAP {
    protected static final String CODIGO_RECEITA_BRASIL = "4600";
    protected static final String CODIGO_RECEITA_EXTERIOR = "0473";
    protected static final String CODIGO_RECEITA_GCME = "8523";
    protected DemonstrativoGCAP[] arrayDemonstrativos;
    protected int[][] arrayItemDados;
    protected ColecaoMoedaAlienada colecaoMoedaAlienada;
    RelatorioMultiploXMLGCAP relatorio;
    protected boolean gerarConsolidadoGeral = false;
    protected boolean imprimirDarfMoedaEspecie = false;

    public RelatorioGCAP(DemonstrativoGCAP[] pDemonstrativos) {
        this.arrayDemonstrativos = pDemonstrativos;
    }

    public RelatorioGCAP(DemonstrativoGCAP pDemonstrativo, int[][] pItemDados) {
        this.arrayDemonstrativos = new DemonstrativoGCAP[]{pDemonstrativo};
        this.arrayItemDados = pItemDados;
    }

    public RelatorioGCAP(DemonstrativoGCAP pDemonstrativo, boolean imprimirDarfMoedaEspecie) {
        this.arrayDemonstrativos = new DemonstrativoGCAP[]{pDemonstrativo};
        this.imprimirDarfMoedaEspecie = imprimirDarfMoedaEspecie;
    }

    protected abstract void adicionarRelatorios(List<RelatorioXML> var1, DemonstrativoGCAP var2, AlienacaoBemImovel var3);

    protected abstract void adicionarRelatorios(List<RelatorioXML> var1, DemonstrativoGCAP var2, AlienacaoBemMovel var3);

    protected abstract void adicionarRelatorios(List<RelatorioXML> var1, DemonstrativoGCAP var2, AlienacaoParticipacaoSocietaria var3);

    protected abstract void adicionarRelatorios(List<RelatorioXML> var1, DemonstrativoGCAP var2, ColecaoMoedaAlienada var3);

    protected abstract void adicionarRelatorioConsolidado(List<RelatorioXML> var1, DemonstrativoGCAP var2);

    protected abstract boolean isPaginado();

    public void imprimir() {
        this.preparar();
        if (this.isValido()) {
            this.relatorio.imprimir();
        }
    }

    public void visualizar() {
        this.preparar();
        if (this.isValido()) {
            this.relatorio.visualizar();
        }
    }

    public void gerarPDF() {
        this.preparar();
        if (this.isValido()) {
            this.relatorio.gerarPDF();
        }
    }

    public boolean isValido() {
        if (this.relatorio.getRelatorios().isEmpty()) {
            if (this instanceof RelatorioDarf) {
                GuiUtil.mostrarAviso("NaoExistemDadosRelatorioDarf");
            }
            if (this instanceof RelatorioDemonstrativo) {
                GuiUtil.mostrarAviso("NaoExistemDadosRelatorioDemonstrativo");
            }
            return false;
        }
        return true;
    }

    protected void preparar() {
        ArrayList<RelatorioXML> lRelatorios = new ArrayList<RelatorioXML>();
        for (DemonstrativoGCAP demonstrativo : this.arrayDemonstrativos) {
            this.relatorio = this.adicionarDadosBasicosAoRelatorio(demonstrativo);
            if (this.imprimirDarfMoedaEspecie) {
                this.adicionarMoedaAlienadaAoRelatorio(lRelatorios, demonstrativo);
            } else if (this.arrayItemDados == null) {
                this.adicionarBensAoRelatorio(lRelatorios, demonstrativo);
            } else {
                this.adicionarBensEspecificadosAoRelatorio(lRelatorios, demonstrativo);
            }
            if (!this.gerarConsolidadoGeral) continue;
            this.adicionarRelatorioConsolidado(lRelatorios, demonstrativo);
        }
        this.relatorio.setRelatorios(lRelatorios);
    }

    private RelatorioMultiploXMLGCAP adicionarDadosBasicosAoRelatorio(DemonstrativoGCAP demonstrativo) {
        Data dataInicio = demonstrativo.getIdDemonstrativo().getDataInicioPermanencia();
        Data dataFim = demonstrativo.getIdDemonstrativo().getDataFimPermanencia();
        String strInicio = dataInicio.getDia() + dataInicio.getMes();
        String strFim = dataFim.getDia() + dataFim.getMes();
        String lNomeArquivoDisco = demonstrativo.getIdDemonstrativo().getCpf().naoFormatado() + "-" + strInicio + "-" + strFim + "-" + ConstantesGlobais.NOME_PROGRAMA + "-" + ConstantesGlobais.EXERCICIO;
        String extensao = !this.imprimirDarfMoedaEspecie ? this.obterExtensaoArquivoRelatorio() : "-darfmoedaespecie.pdf";
        String lNomeArquivoPdfGerado = lNomeArquivoDisco + extensao;
        RelatorioMultiploXMLGCAP relatorio = new RelatorioMultiploXMLGCAP("T\u00edtulo do Relat\u00f3rio: " + lNomeArquivoDisco, "Nome do relat\u00f3rio: tamb\u00e9m n\u00e3o importa", demonstrativo.getIdDemonstrativo().getPathArquivo(), "/classe", lNomeArquivoPdfGerado);
        relatorio.setPaginado(this.isPaginado());
        return relatorio;
    }

    protected void adicionarBensAoRelatorio(List<RelatorioXML> lRelatorios, DemonstrativoGCAP demonstrativo) {
        this.adicionarBensImoveisAoRelatorio(lRelatorios, demonstrativo);
        this.adicionarBensMoveisAoRelatorio(lRelatorios, demonstrativo);
        this.adicionarBensParticipacaoSocietariaAoRelatorio(lRelatorios, demonstrativo);
    }

    protected void adicionarBensEspecificadosAoRelatorio(List<RelatorioXML> lRelatorios, DemonstrativoGCAP demonstrativo) {
        this.adicionarBensImoveisEspecificadosAoRelatorio(lRelatorios, demonstrativo);
        this.adicionarBensMoveisEspecificadosAoRelatorio(lRelatorios, demonstrativo);
        this.adicionarBensPSEspecificadosAoRelatorio(lRelatorios, demonstrativo);
    }

    private void adicionarMoedaAlienadaAoRelatorio(List<RelatorioXML> lRelatorios, DemonstrativoGCAP demonstrativo) {
        this.adicionarRelatorios(lRelatorios, demonstrativo, demonstrativo.getMoedasAlienadas());
    }

    private void adicionarBensPSEspecificadosAoRelatorio(List<RelatorioXML> lRelatorios, DemonstrativoGCAP demonstrativo) {
        List participacoes = demonstrativo.getParticipacoesSocietarias().itens();
        for (int i = 0; i < this.arrayItemDados[2].length; ++i) {
            this.adicionarRelatorios(lRelatorios, demonstrativo, (AlienacaoParticipacaoSocietaria)((Object)participacoes.get(this.arrayItemDados[2][i])));
        }
    }

    private void adicionarBensMoveisEspecificadosAoRelatorio(List<RelatorioXML> lRelatorios, DemonstrativoGCAP demonstrativo) {
        List bensMoveis = demonstrativo.getBensMoveis().itens();
        for (int i = 0; i < this.arrayItemDados[1].length; ++i) {
            this.adicionarRelatorios(lRelatorios, demonstrativo, (AlienacaoBemMovel)((Object)bensMoveis.get(this.arrayItemDados[1][i])));
        }
    }

    private void adicionarBensImoveisEspecificadosAoRelatorio(List<RelatorioXML> lRelatorios, DemonstrativoGCAP demonstrativo) {
        List bensImoveis = demonstrativo.getBensImoveis().itens();
        for (int i = 0; i < this.arrayItemDados[0].length; ++i) {
            this.adicionarRelatorios(lRelatorios, demonstrativo, (AlienacaoBemImovel)((Object)bensImoveis.get(this.arrayItemDados[0][i])));
        }
    }

    private void adicionarBensImoveisAoRelatorio(List<RelatorioXML> lRelatorios, DemonstrativoGCAP demonstrativo) {
        List lBensImoveis = demonstrativo.getBensImoveis().itens();
        for (int i = 0; i < lBensImoveis.size(); ++i) {
            this.adicionarRelatorios(lRelatorios, demonstrativo, (AlienacaoBemImovel)((Object)lBensImoveis.get(i)));
        }
    }

    private void adicionarBensMoveisAoRelatorio(List<RelatorioXML> lRelatorios, DemonstrativoGCAP demonstrativo) {
        List lBensMoveis = demonstrativo.getBensMoveis().itens();
        for (int i = 0; i < lBensMoveis.size(); ++i) {
            this.adicionarRelatorios(lRelatorios, demonstrativo, (AlienacaoBemMovel)((Object)lBensMoveis.get(i)));
        }
    }

    private void adicionarBensParticipacaoSocietariaAoRelatorio(List<RelatorioXML> lRelatorios, DemonstrativoGCAP demonstrativo) {
        List lParticipacoes = demonstrativo.getParticipacoesSocietarias().itens();
        for (int i = 0; i < lParticipacoes.size(); ++i) {
            this.adicionarRelatorios(lRelatorios, demonstrativo, (AlienacaoParticipacaoSocietaria)((Object)lParticipacoes.get(i)));
        }
    }

    protected abstract String obterExtensaoArquivoRelatorio();
}

