/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.nuvem;

import br.gov.serpro.gcap.util.ObfuscatedString;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import serpro.ppgd.negocio.util.LogPPGD;

public final class BarramentoIRPFUtil {
    private static final String HASH_KEY = new ObfuscatedString(new long[]{5248493371353446733L, -1145172901818804059L, 7965234193472123598L}).toString();
    private static final String HASH_ALGORITHM = "HmacSHA1";
    private static final String DEFAULT_ENCODING = "UTF-8";

    private BarramentoIRPFUtil() {
    }

    public static String UTF8toISO(String str) {
        Charset utf8charset = Charset.forName(DEFAULT_ENCODING);
        Charset iso88591charset = Charset.forName("ISO-8859-1");
        ByteBuffer inputBuffer = ByteBuffer.wrap(str.getBytes());
        CharBuffer data = utf8charset.decode(inputBuffer);
        ByteBuffer outputBuffer = iso88591charset.encode(data);
        byte[] outputData = outputBuffer.array();
        return new String(outputData);
    }

    public static String gerarHashParametros(Map<String, String> mapParametros) {
        StringBuilder parametrosConcatenados = new StringBuilder();
        for (String chave : mapParametros.keySet()) {
            parametrosConcatenados.append(mapParametros.get(chave));
        }
        return BarramentoIRPFUtil.generateHash(parametrosConcatenados.toString());
    }

    public static String generateHash(String text) {
        SecretKeySpec keySpec = new SecretKeySpec(HASH_KEY.getBytes(), HASH_ALGORITHM);
        try {
            Mac mac = Mac.getInstance(HASH_ALGORITHM);
            mac.init(keySpec);
            byte[] rawMac = mac.doFinal(text.getBytes(DEFAULT_ENCODING));
            byte[] hexBytes = new Hex().encode(rawMac);
            return new String(hexBytes, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            LogPPGD.erro((String)e.getMessage());
            return null;
        }
    }
}

