/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.observador;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.aquisicao.Aquisicao;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class ObservadorCalculoPercentualCustoAquisicao
extends Observador {
    private Aquisicao aquisicao;

    public ObservadorCalculoPercentualCustoAquisicao(Aquisicao aquisicao) {
        this.aquisicao = aquisicao;
    }

    public static void main(String[] args) {
        Valor percentualAquisicaoMN = new Valor(null, "percentualAquisicaoMN", 11, 3);
        percentualAquisicaoMN.setConteudo("100000,00");
        percentualAquisicaoMN.append('*', "100,000");
        percentualAquisicaoMN.append('/', "101000,00");
        percentualAquisicaoMN.arredonda(2, 5);
        System.out.println("percentualAquisicaoMN: " + percentualAquisicaoMN.formatado());
    }

    public void notifica(Object observado, String propriedade, Object valorAntigo, Object valorNovo) {
        if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL.equals(this.aquisicao.getOrigemRendimentos().naoFormatado())) {
            this.aquisicao.getPercentualCustoAquisicaoOrigemNacional().setConteudo("100,00");
            this.aquisicao.getPercentualCustoAquisicaoOrigemME().clear();
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_ESTRANGEIRA.equals(this.aquisicao.getOrigemRendimentos().naoFormatado())) {
            this.aquisicao.getPercentualCustoAquisicaoOrigemNacional().clear();
            this.aquisicao.getPercentualCustoAquisicaoOrigemME().setConteudo("100,00");
        } else if (Aquisicao.STR_CODIGO_ORIGEM_RENDIMENTOS_MOEDA_NACIONAL_E_ESTRANGEIRA.equals(this.aquisicao.getOrigemRendimentos().naoFormatado()) && !this.aquisicao.getCustoAquisicaoTotalDolar().isVazio()) {
            ValorPositivo percentualAquisicaoMN = new ValorPositivo(null, "percentualAquisicaoMN", 3, 9);
            percentualAquisicaoMN.setConteudo(this.aquisicao.getCustoAquisicaoOrigemNacionalDolar().formatado());
            percentualAquisicaoMN.append('*', "100,000");
            percentualAquisicaoMN.append('/', this.aquisicao.getCustoAquisicaoTotalDolar().formatado());
            Valor percentualAquisicaoMNArredondado = new Valor(null, "percentualAquisicaoMNArredondado", 3, 9);
            percentualAquisicaoMNArredondado.setConteudo(percentualAquisicaoMN.formatado());
            this.aquisicao.getPercentualCustoAquisicaoOrigemNacional().setConteudo(percentualAquisicaoMNArredondado.formatado());
            this.aquisicao.getPercentualCustoAquisicaoOrigemME().setConteudo(new ValorPositivo("100,00").operacao('-', this.aquisicao.getPercentualCustoAquisicaoOrigemNacional()));
        } else {
            this.aquisicao.getPercentualCustoAquisicaoOrigemNacional().clear();
            this.aquisicao.getPercentualCustoAquisicaoOrigemME().clear();
        }
    }
}

