/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.observador;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.psocietarias.ColecaoParcelaAquisicaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.psocietarias.ParcelaAquisicaoParticipacaoSocietaria;
import serpro.ppgd.negocio.Observador;

public class ObservadorCalculoTotaisParcelasAquisicaoPSocietaria
extends Observador {
    private ColecaoParcelaAquisicaoParticipacaoSocietaria colecao;

    public ObservadorCalculoTotaisParcelasAquisicaoPSocietaria(ColecaoParcelaAquisicaoParticipacaoSocietaria colecao) {
        this.colecao = colecao;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                ParcelaAquisicaoParticipacaoSocietaria parcela = (ParcelaAquisicaoParticipacaoSocietaria)((Object)valorNovo);
                parcela.addObservador(this);
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                ParcelaAquisicaoParticipacaoSocietaria parcela = (ParcelaAquisicaoParticipacaoSocietaria)((Object)valorNovo);
                parcela.removeObservador(this);
                this.calcularQuantidadeQuotasTotal();
                this.calcularCustoMedioTotal();
                this.calcularCustoAquisicaoTotal();
            } else if (nomePropriedade.equals(ParcelaAquisicaoParticipacaoSocietaria.CAMPO_CUSTO_AQUISICAO)) {
                this.calcularCustoAquisicaoTotal();
            } else if (nomePropriedade.equals(ParcelaAquisicaoParticipacaoSocietaria.CAMPO_CUSTO_MEDIO)) {
                this.calcularCustoMedioTotal();
            } else if (nomePropriedade.equals(ParcelaAquisicaoParticipacaoSocietaria.CAMPO_QUANTIDADE_QUOTAS)) {
                this.calcularQuantidadeQuotasTotal();
            }
        }
    }

    private void calcularCustoAquisicaoTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAquisicaoParticipacaoSocietaria parcela : this.colecao.itens()) {
            total.append('+', parcela.getCustoAquisicao());
        }
        this.colecao.getCustoAquisicaoTotal().setConteudo(total);
    }

    private void calcularCustoMedioTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAquisicaoParticipacaoSocietaria parcela : this.colecao.itens()) {
            total.append('+', parcela.getCustoMedio());
        }
        this.colecao.getCustoMedioTotal().setConteudo(total);
    }

    private void calcularQuantidadeQuotasTotal() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAquisicaoParticipacaoSocietaria parcela : this.colecao.itens()) {
            total.append('+', parcela.getQuantidadeQuotas().formatado());
        }
        total.append('/', new ValorBigDecimal(100L));
        this.colecao.getQuantidadeQuotasTotal().setConteudo(total.asString());
    }
}

