/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.observador;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoParcelaAlienacao;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import serpro.ppgd.negocio.Observador;

public class ObservadorCalculoTotaisParcelasPSocietarias
extends Observador {
    private ColecaoParcelaAlienacao colecao;

    public ObservadorCalculoTotaisParcelasPSocietarias(ColecaoParcelaAlienacao colecao) {
        this.colecao = colecao;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                ParcelaAlienacao parcela = (ParcelaAlienacao)((Object)valorNovo);
                parcela.addObservador(this);
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                ParcelaAlienacao parcela = (ParcelaAlienacao)((Object)valorNovo);
                parcela.removeObservador(this);
                this.calculaTotaisValorRecebido();
                this.calculaTotaisCustoCorretagem();
                this.calculaTotaisValorLiquidoAlienacao();
                this.calculaTotaisCustoAquisicaoProporcional();
                this.calculaTotaisGanhoProporcional();
                this.calculaTotaisImpostoDevido();
                this.calculaTotaisImpostoPago();
                this.calculaTotaisIrrfLei110332004();
                this.calculaTotaisImpostoDevido2();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_VALOR_RECEBIDO)) {
                this.calculaTotaisValorRecebido();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_CORRETAGEM)) {
                this.calculaTotaisCustoCorretagem();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_VALOR_LIQUIDO_ALIENACAO)) {
                this.calculaTotaisValorLiquidoAlienacao();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_CUSTO_AQUISICAO_PROPORCIONAL)) {
                this.calculaTotaisCustoAquisicaoProporcional();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_GANHO_1_PROPORCIONAL)) {
                this.calculaTotaisGanhoProporcional();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_IMPOSTO_DEVIDO)) {
                this.calculaTotaisImpostoDevido();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_IR_FONTE_LEI_11033_2004)) {
                this.calculaTotaisIrrfLei110332004();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_IMPOSTO_DEVIDO_APOS_COMPENSACAO)) {
                this.calculaTotaisImpostoDevido2();
            } else if (nomePropriedade.equals(ParcelaAlienacao.CAMPO_IMPOSTO_PAGO)) {
                this.calculaTotaisImpostoPago();
            }
        }
    }

    public void calculaTodosOsTotais() {
        this.calculaTotaisValorRecebido();
        this.calculaTotaisCustoCorretagem();
        this.calculaTotaisValorLiquidoAlienacao();
        this.calculaTotaisCustoAquisicaoProporcional();
        this.calculaTotaisGanhoProporcional();
        this.calculaTotaisImpostoDevido();
        this.calculaTotaisImpostoPago();
        this.calculaTotaisIrrfLei110332004();
        this.calculaTotaisImpostoDevido2();
    }

    private void calculaTotaisValorRecebido() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.colecao.itens()) {
            total.append('+', parcela.getValorRecebido());
        }
        this.colecao.getValorRecebidoTotal().setConteudo(total);
    }

    private void calculaTotaisCustoCorretagem() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.colecao.itens()) {
            total.append('+', parcela.getCustoCorretagem());
        }
        this.colecao.getCustoCorretagemTotal().setConteudo(total);
    }

    private void calculaTotaisValorLiquidoAlienacao() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.colecao.itens()) {
            total.append('+', parcela.getValorLiquidoAlienacao());
        }
        this.colecao.getValorLiquidoAlienacaoTotal().setConteudo(total);
    }

    private void calculaTotaisCustoAquisicaoProporcional() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.colecao.itens()) {
            total.append('+', parcela.getCustoAquisicaoProporcional());
        }
        this.colecao.getCustoAquisicaoProporcionalTotal().setConteudo(total);
    }

    private void calculaTotaisGanhoProporcional() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.colecao.itens()) {
            total.append('+', parcela.getGanhoCapital1Proporcional());
        }
        this.colecao.getGanhoProporcionalTotal().setConteudo(total);
    }

    private void calculaTotaisImpostoDevido() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.colecao.itens()) {
            total.append('+', parcela.getImpostoDevido());
        }
        this.colecao.getImpostoDevidoTotal().setConteudo(total);
    }

    private void calculaTotaisImpostoPago() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.colecao.itens()) {
            total.append('+', parcela.getImpostoPago());
        }
        this.colecao.getImpostoPagoTotal().setConteudo(total);
    }

    private void calculaTotaisIrrfLei110332004() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.colecao.itens()) {
            total.append('+', parcela.getIrrfLei110332004());
        }
        this.colecao.getIrrfLei110332004Total().setConteudo(total);
    }

    private void calculaTotaisImpostoDevido2() {
        ValorPositivo total = new ValorPositivo();
        for (ParcelaAlienacao parcela : this.colecao.itens()) {
            total.append('+', parcela.getImpostoDevido2());
        }
        this.colecao.getImpostoDevido2Total().setConteudo(total);
    }
}

