/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.observador;

import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ColecaoAlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.consolidacao.Consolidacao;
import java.lang.ref.WeakReference;
import serpro.ppgd.negocio.Observador;

public class ObservadorTotaisConsolidacaoPSocietaria
extends Observador {
    private WeakReference<ColecaoAlienacaoParticipacaoSocietaria> weakColecao;

    public ObservadorTotaisConsolidacaoPSocietaria(ColecaoAlienacaoParticipacaoSocietaria colecao) {
        this.weakColecao = new WeakReference<ColecaoAlienacaoParticipacaoSocietaria>(colecao);
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                this.calcularTotais();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                this.calcularTotais();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_IMPOSTO_DIFERIDO_ANOS_ANTERIORES)) {
                this.calculaTotalImpostoDiferidoAnosAnteriores();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_REFERENTE_ALIENACAO_ANO_ATUAL)) {
                this.calculaTotalImpostoReferenteAlienacaoAnoAtual();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_IMPOSTO_TOTAL)) {
                this.calculaTotalImpostoTotal();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_VALOR_IRF)) {
                this.calculaTotalValorIRF();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_IMPOSTO_DEVIDO_ANO_ATUAL)) {
                this.calculaTotalImpostoDevidoAnoAtual();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_IMPOSTO_DIFERIDO_ANOS_POSTERIORES)) {
                this.calculaTotalImpostoDiferidoAnosPosteriores();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_TOTAL_IMPOSTO_PAGO)) {
                this.calculaTotalImpostoPago();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_REND_ISENTOS_NAO_TRIBUTAVEIS)) {
                this.calculaTotalRendIsentosNaoTributaveis();
            } else if (nomePropriedade.equals(Consolidacao.CAMPO_REND_SUJEITO_TRIBUTACAO_EXCLUSIVA)) {
                this.calculaTotalRendSujeitosTributacao();
            }
        }
    }

    private void calcularTotais() {
        this.calculaTotalImpostoDiferidoAnosAnteriores();
        this.calculaTotalImpostoReferenteAlienacaoAnoAtual();
        this.calculaTotalImpostoTotal();
        this.calculaTotalValorIRF();
        this.calculaTotalImpostoDevidoAnoAtual();
        this.calculaTotalImpostoDiferidoAnosPosteriores();
        this.calculaTotalImpostoPago();
        this.calculaTotalRendIsentosNaoTributaveis();
        this.calculaTotalRendSujeitosTributacao();
    }

    private void calculaTotalImpostoDiferidoAnosAnteriores() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoParticipacaoSocietaria alienacao : ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoDiferidoAnosAnteriores());
        }
        ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).getTotalImpostoDiferidoAnosAnteriores().setConteudo(total);
    }

    private void calculaTotalImpostoReferenteAlienacaoAnoAtual() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoParticipacaoSocietaria alienacao : ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual());
        }
        ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).getTotalImpostoReferenteAlienacaoAnoAtual().setConteudo(total);
    }

    private void calculaTotalImpostoTotal() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoParticipacaoSocietaria alienacao : ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoTotal());
        }
        ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).getTotalImpostoTotal().setConteudo(total);
    }

    private void calculaTotalValorIRF() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoParticipacaoSocietaria alienacao : ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getValorIRF());
        }
        ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).getTotalValorIRF().setConteudo(total);
    }

    private void calculaTotalImpostoDevidoAnoAtual() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoParticipacaoSocietaria alienacao : ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoDevidoAnoAtual());
        }
        ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).getTotalImpostoDevidoAnoAtual().setConteudo(total);
    }

    private void calculaTotalImpostoDiferidoAnosPosteriores() {
        ValorPositivo total = new ValorPositivo();
        for (AlienacaoParticipacaoSocietaria alienacao : ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).itens()) {
            total.append('+', alienacao.getConsolidacao().getImpostoDiferidoAnosPosteriores());
        }
        ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).getTotalImpostoDiferidoAnosPosteriores().setConteudo(total);
    }

    private void calculaTotalImpostoPago() {
        ValorPositivo totalBR = new ValorPositivo();
        for (AlienacaoParticipacaoSocietaria alienacao : ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).itens()) {
            totalBR.append('+', alienacao.getConsolidacao().getTotalImpostoPago());
        }
        ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).getTotalImpostoPago().setConteudo(totalBR);
    }

    private void calculaTotalRendIsentosNaoTributaveis() {
        ValorPositivo totalBR = new ValorPositivo();
        for (AlienacaoParticipacaoSocietaria alienacao : ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).itens()) {
            totalBR.append('+', alienacao.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).getTotalRendIsentosNaoTributaveis().setConteudo(totalBR);
    }

    private void calculaTotalRendSujeitosTributacao() {
        ValorPositivo totalBR = new ValorPositivo();
        for (AlienacaoParticipacaoSocietaria alienacao : ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).itens()) {
            totalBR.append('+', alienacao.getConsolidacao().getTotalRendSujeitosTributacao());
        }
        ((ColecaoAlienacaoParticipacaoSocietaria)((Object)this.weakColecao.get())).getTotalRendSujeitosTributacao().setConteudo(totalBR);
    }
}

