/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.txt.gravacaorestauracao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.entidades.adquirente.Adquirente;
import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemMovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.entidades.apuracao.Apuracao;
import br.gov.serpro.gcap.entidades.aquisicao.ParcelaAquisicao;
import br.gov.serpro.gcap.entidades.especie.MoedaAlienada;
import br.gov.serpro.gcap.entidades.especie.OperacaoEspecie;
import br.gov.serpro.gcap.entidades.psocietarias.ParcelaAquisicaoParticipacaoSocietaria;
import br.gov.serpro.gcap.txt.gravacaorestauracao.DocumentoTxtGCAP;
import java.util.HashMap;
import java.util.Vector;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.Valor;

public class ConversorObjetoRegistros {
    private static final String IDENTIFICACAO = "01";
    private static final String BEM_IMOVEL = "02";
    private static final String BEM_MOVEL = "03";
    private static final String PARTICIPACAO_SOCIETARIA = "04";
    private static final String DECLARACAO_EXTERIOR = "05";
    private static final String ADQUIRENTE = "06";
    private static final String AMPLIACAO = "07";
    private static final String AMPLIACAO_EXTERIOR = "08";
    private static final String APURACAO = "09";
    private static final String PARCELA = "10";
    private static final String CUSTO_AQUISICAO = "11";
    private static final String MOEDA_ESPECIE = "12";
    private static final HashMap<String, String> numOperacaoPorTipoAlienacao = new HashMap();

    public void preencherDocumentoTXT(DemonstrativoGCAP demonstrativoAtual, DocumentoTxtGCAP documentoTXT) throws GeracaoTxtException {
        Vector<RegistroTxt> regs = new Vector<RegistroTxt>();
        documentoTXT.setFicha(regs);
        regs.add(this.gerarReg01Declaracao(demonstrativoAtual));
        regs.add(this.gerarReg02BemImovel(demonstrativoAtual));
        regs.add(this.gerarReg03BemMovel(demonstrativoAtual));
        regs.add(this.gerarReg04ParticipacaoSocietaria(demonstrativoAtual));
        regs.add(this.gerarReg05DeclaracaoExterior(demonstrativoAtual));
        regs.add(this.gerarReg06Adquirente(demonstrativoAtual));
        regs.add(this.gerarReg07Ampliacao(demonstrativoAtual));
        regs.add(this.gerarReg08AmpliacaoExterior(demonstrativoAtual));
        regs.add(this.gerarReg09Apuracao(demonstrativoAtual));
        regs.add(this.gerarReg10Parcela(demonstrativoAtual));
        regs.add(this.gerarReg11CustoApuracao(demonstrativoAtual));
        regs.add(this.gerarReg12MoedaEspecie(demonstrativoAtual));
        documentoTXT.setFicha(regs);
    }

    public RegistroTxt gerarReg01Declaracao(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", IDENTIFICACAO);
        reg.fieldByName("SISTEMA").set("GCAP");
        reg.fieldByName("EXERCICIO").set("2017");
        reg.fieldByName("NR_CPF").set(demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado());
        reg.fieldByName("NM_NOME").set(demonstrativo.getIdentificadorDeclaracao().getNome().naoFormatado());
        reg.fieldByName("NR_DDD_TELEFONE").set(demonstrativo.getIdentificadorDeclaracao().getDddDeclarante().naoFormatado() + demonstrativo.getIdentificadorDeclaracao().getTelefoneDeclarante());
        reg.fieldByName("DT_INICIO").set(demonstrativo.getIdentificadorDeclaracao().getDataInicioPermanencia().naoFormatado());
        reg.fieldByName("DT_FIM").set(demonstrativo.getIdentificadorDeclaracao().getDataFimPermanencia().naoFormatado());
        reg.fieldByName("CD_PAIS").set(demonstrativo.getIdentificadorDeclaracao().getPaisDeclarante().getConteudoAtual(0));
        reg.fieldByName("NM_PAIS").set(demonstrativo.getIdentificadorDeclaracao().getPaisDeclarante().getConteudoAtual(1));
        reg.fieldByName("GC_TRANSP_VR_EXCLUSIVO").set(this.obterRendimentosTributacaoExclusiva(demonstrativo));
        reg.fieldByName("GC_TRANSP_VR_PEQUENO").set(this.obterRendimentosIsentosPequenoValor(demonstrativo));
        reg.fieldByName("GC_TRANSP_VR_UNICO_IMOVEL").set(this.obterRendimentosIsentosUnicoImovel(demonstrativo));
        reg.fieldByName("GC_TRANSP_VR_REDUCAO").set(this.obterRendimentosIsentosReducao(demonstrativo));
        reg.fieldByName("GC_TRANSP_VR_IMPOSTO_PAGO").set(this.obterImpostoPago(demonstrativo));
        reg.fieldByName("GC_TRANSP_VR_IMPOSTO_DEVIDO").set(this.obterImpostoDevido(demonstrativo));
        reg.fieldByName("GC_TRANSP_VR_ISEN_TRIB").set(this.obterRendimentosIsentos(demonstrativo));
        reg.fieldByName("GC_TRANSP_VR_IMPOSTO_DIFERIDO_ANOS_POSTERIORES").set(this.obterImpostoDiferidoAnosPosteriores(demonstrativo));
        reg.fieldByName("GC_GCAP_MOEDA").set(this.converterParaString(demonstrativo.getMoedasAlienadas().getGanhoCapitalTotal()));
        reg.fieldByName("GC_IMPOSTO_DEVIDO_MOEDA").set(this.converterParaString(demonstrativo.getMoedasAlienadas().getImpostoDevido()));
        reg.fieldByName("GC_MOEDA_ALIQUOTA_MEDIA").set(this.converterParaString(demonstrativo.getMoedasAlienadas().getAliquotaMedia()));
        reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
        return reg;
    }

    public RegistroTxt gerarReg02BemImovel(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", BEM_IMOVEL);
        Integer numeroOperacao = 0;
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (AlienacaoBemImovel item : demonstrativo.getBensImoveis().itens()) {
            this.preencherIdentificacaoRegistro(item, reg, BEM_IMOVEL, cpf, numeroOperacao);
            reg.fieldByName("IN_BRASIL_EXTERIOR").set(item.getBemImovel().isAdquiridoNoBrasil() ? "0" : "1");
            reg.fieldByName("NM_IMOVEL_DESCRICAO").set(item.getBemImovel().getEspecificacao().naoFormatado());
            reg.fieldByName("END_TIPO_LOGRADOURO").set(item.getBemImovel().getEndereco().getTipoLogradouro().getConteudoAtual(1));
            reg.fieldByName("END_LOGRADOURO").set(item.getBemImovel().isAdquiridoNoBrasil() ? item.getBemImovel().getEndereco().getLogradouro().naoFormatado() : item.getBemImovel().getEndereco().getLogradouroEx().naoFormatado());
            reg.fieldByName("END_NUMERO").set(item.getBemImovel().isAdquiridoNoBrasil() ? item.getBemImovel().getEndereco().getNumero().naoFormatado() : item.getBemImovel().getEndereco().getNumeroEx().naoFormatado());
            reg.fieldByName("END_COMPLEMENTO").set(item.getBemImovel().isAdquiridoNoBrasil() ? item.getBemImovel().getEndereco().getComplemento().naoFormatado() : item.getBemImovel().getEndereco().getComplementoEx().naoFormatado());
            reg.fieldByName("END_BAIRRO").set(item.getBemImovel().isAdquiridoNoBrasil() ? item.getBemImovel().getEndereco().getBairro().naoFormatado() : item.getBemImovel().getEndereco().getBairroEx().naoFormatado());
            reg.fieldByName("END_CEP").set(item.getBemImovel().getEndereco().getCep().naoFormatado());
            reg.fieldByName("END_CD_MUNICIPIO").set(item.getBemImovel().getEndereco().getMunicipio().getConteudoAtual(0));
            reg.fieldByName("END_MUNICIPIO").set(item.getBemImovel().getEndereco().getMunicipio().getConteudoAtual(1));
            reg.fieldByName("END_UF").set(item.getBemImovel().getEndereco().getUf().naoFormatado());
            reg.fieldByName("DT_AQUISICAO").set(item.getAquisicao().getDataAquisicao().naoFormatado());
            reg.fieldByName("VR_AQUISICAO").set(this.obterValorAquisicao(item));
            reg.fieldByName("IN_REFORMA").set(item.getBemImovel().getAquisicao().getHouveReforma().equals(Logico.SIM) ? "S" : "N");
            reg.fieldByName("IN_PEQUENO_VALOR").set(item.getBemGrandeValor().equals(Logico.SIM) ? "S" : "N");
            reg.fieldByName("IN_PROPR_OUTRO_IMOVEL").set(item.getPerguntas().getPropriedadeOutroImovel().equals(Logico.SIM) ? "S" : "N");
            reg.fieldByName("IN_OUTRA_ALIENACAO").set(item.getPerguntas().getOutraAlienacao().equals(Logico.SIM) ? "S" : "N");
            reg.fieldByName("IN_RESIDENCIAL").set(item.getPerguntas().getImovelResidencial().equals(Logico.SIM) ? "S" : "N");
            reg.fieldByName("IN_UTILIZAZAO_OUTRO_IMOVEL").set(item.getPerguntas().getMP252().equals(Logico.SIM) ? "S" : "N");
            reg.fieldByName("VR_UTILIZAZAO_OUTRO_IMOVEL").set(item.getValorAplicado().naoFormatado());
            this.preencherDadosOperacao(item, reg);
            this.preencherDadosApuracao(item, reg);
            this.preencherDadosCalculoImposto(item, reg);
            this.preencherDadosConsolidacao(item, reg);
            reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
        }
        return reg;
    }

    public RegistroTxt gerarReg03BemMovel(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", BEM_MOVEL);
        Integer numeroOperacao = 0;
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (AlienacaoBemMovel item : demonstrativo.getBensMoveis().itens()) {
            this.preencherIdentificacaoRegistro(item, reg, BEM_MOVEL, cpf, numeroOperacao);
            reg.fieldByName("IN_BRASIL_EXTERIOR").set(item.isAlienacaoBrasil() ? "0" : "1");
            reg.fieldByName("NM_MOVEL_DESCRICAO").set(item.getBemMovel().getEspecificacao().naoFormatado());
            reg.fieldByName("IN_REGISTRO_PUBLICO").set(item.getBemMovel().getSujeitoRegistroPublico());
            reg.fieldByName("DT_AQUISICAO").set(item.getBemMovel().getAquisicao().getDataAquisicao().naoFormatado());
            reg.fieldByName("VR_AQUISICAO").set(this.obterValorAquisicao(item));
            reg.fieldByName("IN_VALOR_SUPERIOR").set(item.getBemGrandeValor());
            this.preencherDadosOperacao(item, reg);
            this.preencherDadosApuracao(item, reg);
            this.preencherDadosCalculoImposto(item, reg);
            this.preencherDadosConsolidacao(item, reg);
            reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
        }
        return reg;
    }

    public RegistroTxt gerarReg04ParticipacaoSocietaria(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", PARTICIPACAO_SOCIETARIA);
        Integer numeroOperacao = 0;
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (AlienacaoParticipacaoSocietaria item : demonstrativo.getParticipacoesSocietarias().itens()) {
            this.preencherIdentificacaoRegistro(item, reg, PARTICIPACAO_SOCIETARIA, cpf, numeroOperacao);
            reg.fieldByName("CD_ESPECIE").set(item.getParticipacaoSocietaria().getEspecie().getConteudoAtual(0));
            reg.fieldByName("NM_ESPECIE").set(item.getParticipacaoSocietaria().getEspecie().getConteudoAtual(1));
            this.preencherDadosOperacao(item, reg);
            this.preencherDadosApuracao(item, reg);
            this.preencherDadosCalculoImposto(item, reg);
            this.preencherDadosConsolidacao(item, reg);
            reg.fieldByName("VR_CUSTO_TOTAL_AQUISICAO").set(this.converterParaString(item.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoAquisicaoTotal()));
            reg.fieldByName("VR_CUSTO_TRANSP_PLANILHA").set(this.converterParaString(item.getColecaoParcelaAquisicaoParticipacaoSocietaria().getCustoMedioTotal()));
            reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
        }
        return reg;
    }

    public RegistroTxt gerarReg05DeclaracaoExterior(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", DECLARACAO_EXTERIOR);
        Integer numeroOperacao = 0;
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (AlienacaoBem item : demonstrativo.getBensMoveis().itens()) {
            if (((AlienacaoBemMovel)item).isAlienacaoBrasil()) continue;
            this.preencherIdentificacaoRegistro(item, reg, DECLARACAO_EXTERIOR, cpf, numeroOperacao);
            reg.fieldByName("IN_TIPO").set("2");
            reg.fieldByName("IN_ORIGEM_REND").set(((AlienacaoBemMovel)item).getBemMovel().getAquisicao().getOrigemRendimentos().getConteudoAtual(0));
            reg.fieldByName("NM_ORIGEM_REND_DESC").set(((AlienacaoBemMovel)item).getBemMovel().getAquisicao().getOrigemRendimentos().getConteudoAtual(1));
            reg.fieldByName("VR_COTACAO_ALIENACAO").set((Valor)item.getCotacaoDolarDataAlienacao());
            reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
        }
        for (AlienacaoBem item : demonstrativo.getBensImoveis().itens()) {
            if (((AlienacaoBemImovel)item).isAlienacaoBrasil()) continue;
            this.preencherIdentificacaoRegistro(item, reg, DECLARACAO_EXTERIOR, cpf, numeroOperacao);
            reg.fieldByName("IN_TIPO").set("1");
            reg.fieldByName("IN_ORIGEM_REND").set(((AlienacaoBemImovel)item).getBemImovel().getAquisicao().getOrigemRendimentos().getConteudoAtual(0));
            reg.fieldByName("NM_ORIGEM_REND_DESC").set(((AlienacaoBemImovel)item).getBemImovel().getAquisicao().getOrigemRendimentos().getConteudoAtual(1));
            reg.fieldByName("VR_COTACAO_ALIENACAO").set((Valor)item.getCotacaoDolarDataAlienacao());
            reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
        }
        return reg;
    }

    private RegistroTxt gerarReg06Adquirente(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", ADQUIRENTE);
        Integer numeroOperacao = 0;
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (Alienacao item : demonstrativo.getBensImoveis().itens()) {
            for (Adquirente adquirente : ((AlienacaoBemImovel)item).getBemImovel().getAdquirentes().itens()) {
                this.preencherAdquirentes(reg, adquirente, item, numeroOperacao, cpf);
            }
        }
        for (Alienacao item : demonstrativo.getBensMoveis().itens()) {
            for (Adquirente adquirente : ((AlienacaoBemMovel)item).getBemMovel().getAdquirentes().itens()) {
                this.preencherAdquirentes(reg, adquirente, item, numeroOperacao, cpf);
            }
        }
        for (Alienacao item : demonstrativo.getParticipacoesSocietarias().itens()) {
            for (Adquirente adquirente : ((AlienacaoParticipacaoSocietaria)item).getAdquirentes().itens()) {
                this.preencherAdquirentes(reg, adquirente, item, numeroOperacao, cpf);
            }
        }
        return reg;
    }

    private RegistroTxt gerarReg07Ampliacao(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", AMPLIACAO);
        Integer numeroOperacao = 0;
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        int numeroItem = 0;
        for (AlienacaoBemImovel item : demonstrativo.getBensImoveis().itens()) {
            if (!item.isAlienacaoBrasil()) continue;
            this.preencherIdentificacaoRegistro(item, reg, AMPLIACAO, cpf, numeroOperacao);
            for (ParcelaAquisicao parcela : item.getBemImovel().getAquisicao().getParcelasAquisicao().itens()) {
                reg.fieldByName("NR_ITEM").set(numeroItem++);
                reg.fieldByName("DT_DATA").set(parcela.getData().naoFormatado());
                reg.fieldByName("VR_VALOR_REAIS").set((Valor)parcela.getCustoAquisicao());
                ValorPositivo total = parcela.getCustoAquisicaoOrigemNacionalDolar();
                total.append('+', parcela.getCustoAquisicaoOrigemNacionalReal());
                reg.fieldByName("VR_TOTAL_PARCELA").set(total.naoFormatado());
                reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
            }
        }
        return reg;
    }

    private RegistroTxt gerarReg08AmpliacaoExterior(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", AMPLIACAO_EXTERIOR);
        Integer numeroOperacao = 0;
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        int numeroItem = 0;
        for (AlienacaoBemImovel item : demonstrativo.getBensImoveis().itens()) {
            if (item.isAlienacaoBrasil()) continue;
            this.preencherIdentificacaoRegistro(item, reg, AMPLIACAO_EXTERIOR, cpf, numeroOperacao);
            for (ParcelaAquisicao parcela : item.getBemImovel().getAquisicao().getParcelasAquisicao().itens()) {
                reg.fieldByName("NR_ITEM").set(numeroItem++);
                reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
            }
        }
        return reg;
    }

    private RegistroTxt gerarReg09Apuracao(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", APURACAO);
        Integer numeroOperacao = 0;
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (Alienacao item : demonstrativo.getBensImoveis().itens()) {
            this.preencherApuracoes(reg, ((AlienacaoBemImovel)item).getApuracao(), item, numeroOperacao, cpf);
        }
        for (Alienacao item : demonstrativo.getBensMoveis().itens()) {
            this.preencherApuracoes(reg, ((AlienacaoBemMovel)item).getApuracao(), item, numeroOperacao, cpf);
        }
        for (Alienacao item : demonstrativo.getParticipacoesSocietarias().itens()) {
            this.preencherApuracoes(reg, ((AlienacaoParticipacaoSocietaria)item).getApuracao(), item, numeroOperacao, cpf);
        }
        return reg;
    }

    private RegistroTxt gerarReg10Parcela(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", PARCELA);
        Integer numeroOperacao = 0;
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        for (Alienacao item : demonstrativo.getBensImoveis().itens()) {
            for (ParcelaAlienacao parcela : ((AlienacaoBem)item).getColecaoParcelaAlienacao().itens()) {
                this.preencherParcelas(reg, parcela, item, numeroOperacao, cpf);
            }
        }
        for (Alienacao item : demonstrativo.getBensMoveis().itens()) {
            for (ParcelaAlienacao parcela : ((AlienacaoBem)item).getColecaoParcelaAlienacao().itens()) {
                this.preencherParcelas(reg, parcela, item, numeroOperacao, cpf);
            }
        }
        for (Alienacao item : demonstrativo.getParticipacoesSocietarias().itens()) {
            for (ParcelaAlienacao parcela : ((AlienacaoParticipacaoSocietaria)item).getColecaoParcelaAlienacao().itens()) {
                this.preencherParcelas(reg, parcela, item, numeroOperacao, cpf);
            }
        }
        return reg;
    }

    private RegistroTxt gerarReg11CustoApuracao(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", CUSTO_AQUISICAO);
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        Integer numeroOperacao = 0;
        int numeroItem = 0;
        for (AlienacaoParticipacaoSocietaria item : demonstrativo.getParticipacoesSocietarias().itens()) {
            for (ParcelaAquisicaoParticipacaoSocietaria parcela : item.getColecaoParcelaAquisicaoParticipacaoSocietaria().itens()) {
                this.preencherIdentificacaoRegistro(item, reg, AMPLIACAO_EXTERIOR, cpf, numeroOperacao);
                reg.fieldByName("NR_ITEM").set(numeroItem++);
                reg.fieldByName("IN_ESPECIE").set(parcela.getEspecieAquisicao().getConteudoAtual(0));
                reg.fieldByName("NM_DESCRICAO_ESPECIE").set(parcela.getEspecieAquisicao().getConteudoAtual(1));
                reg.fieldByName("VR_QUANTIDADE_ALIENADA").set(parcela.getQuantidadeQuotas().naoFormatado());
                reg.fieldByName("VR_CUSTO_MEDIO").set(parcela.getCustoMedio().naoFormatado());
                reg.fieldByName("VR_CUSTO_TOTAL").set(parcela.getCustoAquisicao().naoFormatado());
                reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
            }
        }
        return reg;
    }

    private RegistroTxt gerarReg12MoedaEspecie(DemonstrativoGCAP demonstrativo) throws GeracaoTxtException {
        RegistroTxt reg = new RegistroTxt("ARQ_EXPORT", MOEDA_ESPECIE);
        String cpf = demonstrativo.getIdentificadorDeclaracao().getCpf().naoFormatado();
        Integer numeroOperacao = 0;
        int numeroItem = 0;
        for (MoedaAlienada item : demonstrativo.getMoedasAlienadas().itens()) {
            for (OperacaoEspecie operacao : item.getOperacoesEspecie().itens()) {
                reg.fieldByName("NR_REG").set(MOEDA_ESPECIE);
                reg.fieldByName("NR_CPF").set(cpf);
                Integer n = numeroOperacao;
                numeroOperacao = numeroOperacao + 1;
                numOperacaoPorTipoAlienacao.put(MOEDA_ESPECIE, numeroOperacao.toString());
                reg.fieldByName("NR_OPERACAO").set(numOperacaoPorTipoAlienacao.get(MOEDA_ESPECIE));
                reg.fieldByName("NR_ITEM").set(numeroItem++);
                reg.fieldByName("PAIS").set(item.getMoeda().getConteudoAtual(0));
                reg.fieldByName("NM_MOEDA").set(item.getMoeda().getConteudoAtual(1));
                reg.fieldByName("TIPO_OPERACAO").set(operacao.getTipo().naoFormatado());
                reg.fieldByName("NI_ADQUIRENTE").set(operacao.getNiAdquirente().naoFormatado());
                reg.fieldByName("DT_ALIEN").set(operacao.getData().naoFormatado());
                reg.fieldByName("VR_ALIEN").set(operacao.getValor().naoFormatado());
                reg.fieldByName("NR_QUANTIDADE").set(operacao.getQuantidade().naoFormatado());
                reg.fieldByName("VR_CUSTO").set(operacao.getCustoMedio().naoFormatado());
                reg.fieldByName("VR_GANHO_CAPITAL").set(operacao.getGanhoCapital().naoFormatado());
                reg.fieldByName("VR_SALDO_REAIS").set(operacao.getSaldo().naoFormatado());
            }
        }
        return reg;
    }

    private void preencherAdquirentes(RegistroTxt reg, Adquirente adquirente, Alienacao item, Integer numeroOperacao, String cpf) throws GeracaoTxtException {
        this.preencherIdentificacaoRegistro(item, reg, ADQUIRENTE, cpf, numeroOperacao);
        reg.fieldByName("IN_TIPO").set(this.obterTipoAlienacao(item));
        reg.fieldByName("NR_CPF_CNPJ").set(adquirente.getCpfCnpj().naoFormatado());
        reg.fieldByName("NR_NOME").set(adquirente.getNome().naoFormatado());
        reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
    }

    private void preencherApuracoes(RegistroTxt reg, Apuracao apuracao, Alienacao item, Integer numeroOperacao, String cpf) throws GeracaoTxtException {
        this.preencherIdentificacaoRegistro(item, reg, APURACAO, cpf, numeroOperacao);
        reg.fieldByName("IN_TIPO").set(this.obterTipoAlienacao(item));
        reg.fieldByName("VR_LIQUIDO_APURACAO").set((Valor)apuracao.getValorLiquidoAlienacao());
        reg.fieldByName("VR_CUSTO_APURACAO").set((Valor)apuracao.getCustoAquisicao());
        reg.fieldByName("VR_RESULTADO_1_APURACAO").set((Valor)apuracao.getGanhoCapital1());
        reg.fieldByName("VR_RESULTADO_2_APURACAO").set((Valor)apuracao.getGanhoCapital1());
        reg.fieldByName("VR_RESULTADO_3_APURACAO").set((Valor)apuracao.getGanhoCapital1());
        reg.fieldByName("VR_RESULTADO_4_APURACAO").set((Valor)apuracao.getGanhoCapital1());
        reg.fieldByName("VR_RESULTADO_5_APURACAO").set((Valor)apuracao.getGanhoCapital1());
        reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
    }

    private void preencherParcelas(RegistroTxt reg, ParcelaAlienacao parcela, Alienacao item, Integer numeroOperacao, String cpf) throws GeracaoTxtException {
        this.preencherIdentificacaoRegistro(item, reg, APURACAO, cpf, numeroOperacao);
        reg.fieldByName("IN_TIPO").set(this.obterTipoAlienacao(item));
        reg.fieldByName("VR_LIQUIDO_APURACAO").set((Valor)parcela.getValorLiquidoAlienacao());
        reg.fieldByName("NR_CONTROLE").set(this.calcularHash());
    }

    private void preencherIdentificacaoRegistro(Alienacao item, RegistroTxt reg, String tipo, String cpf, Integer numeroOperacao) throws GeracaoTxtException {
        reg.fieldByName("NR_REG").set(tipo);
        reg.fieldByName("NR_CPF").set(cpf);
        Integer n = numeroOperacao;
        numeroOperacao = numeroOperacao + 1;
        numOperacaoPorTipoAlienacao.put(tipo, numeroOperacao.toString());
        reg.fieldByName("NR_OPERACAO").set(numOperacaoPorTipoAlienacao.get(tipo));
    }

    private String calcularHash() {
        return "";
    }

    private String converterParaString(ValorPositivo total) {
        return total.getConteudoBigDecimal().setScale(2).toString();
    }

    private String obterRendimentosTributacaoExclusiva(DemonstrativoGCAP demonstrativo) {
        ValorPositivo total = new ValorPositivo(null, "total", 13, 2);
        for (Alienacao item : demonstrativo.getParticipacoesSocietarias().itens()) {
            total.append('+', item.getCalculoImposto().getGanhoCapitalTotal());
        }
        for (Alienacao item : demonstrativo.getBensMoveis().itens()) {
            total.append('+', item.getCalculoImposto().getGanhoCapitalTotal());
        }
        for (Alienacao item : demonstrativo.getBensImoveis().itens()) {
            total.append('+', item.getCalculoImposto().getGanhoCapitalTotal());
        }
        return this.converterParaString(total);
    }

    private String obterRendimentosIsentosUnicoImovel(DemonstrativoGCAP demonstrativo) {
        ValorPositivo total = new ValorPositivo("0,00");
        for (AlienacaoBemImovel item : demonstrativo.getBensImoveis().itens()) {
            if (!item.isIsentoPorUnicoImovel()) continue;
            total.append('+', item.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return this.converterParaString(total);
    }

    private String obterRendimentosIsentosPequenoValor(DemonstrativoGCAP demonstrativo) {
        ValorPositivo total = new ValorPositivo(null, "total", 13, 2);
        for (AlienacaoBemImovel item : demonstrativo.getBensImoveis().itens()) {
            if (!item.isIsentoPorPequenoValor()) continue;
            total.append('+', item.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return this.converterParaString(total);
    }

    private String obterRendimentosIsentosReducao(DemonstrativoGCAP demonstrativo) {
        ValorPositivo total = new ValorPositivo(null, "total", 13, 2);
        return this.converterParaString(total);
    }

    private String obterImpostoPago(DemonstrativoGCAP demonstrativo) {
        ValorPositivo total = new ValorPositivo();
        for (Alienacao item : demonstrativo.getParticipacoesSocietarias().itens()) {
            total.append('+', item.getCalculoImposto().getImpostoPago());
        }
        for (Alienacao item : demonstrativo.getBensMoveis().itens()) {
            total.append('+', item.getCalculoImposto().getImpostoPago());
        }
        for (Alienacao item : demonstrativo.getBensImoveis().itens()) {
            total.append('+', item.getCalculoImposto().getImpostoPago());
        }
        return this.converterParaString(total);
    }

    private String obterImpostoDevido(DemonstrativoGCAP demonstrativo) {
        ValorPositivo total = new ValorPositivo();
        for (Alienacao item : demonstrativo.getParticipacoesSocietarias().itens()) {
            total.append('+', item.getCalculoImposto().getImpostoDevido2());
        }
        for (Alienacao item : demonstrativo.getBensMoveis().itens()) {
            total.append('+', item.getCalculoImposto().getImpostoDevido2());
        }
        for (Alienacao item : demonstrativo.getBensImoveis().itens()) {
            total.append('+', item.getCalculoImposto().getImpostoDevido2());
        }
        return this.converterParaString(total);
    }

    private String obterRendimentosIsentos(DemonstrativoGCAP demonstrativo) {
        ValorPositivo total = new ValorPositivo();
        for (Alienacao item : demonstrativo.getParticipacoesSocietarias().itens()) {
            total.append('+', item.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        for (Alienacao item : demonstrativo.getBensMoveis().itens()) {
            total.append('+', item.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        for (Alienacao item : demonstrativo.getBensImoveis().itens()) {
            total.append('+', item.getConsolidacao().getTotalRendIsentosNaoTributaveis());
        }
        return this.converterParaString(total);
    }

    private String obterImpostoDiferidoAnosPosteriores(DemonstrativoGCAP demonstrativo) {
        ValorPositivo total = new ValorPositivo();
        for (Alienacao item : demonstrativo.getParticipacoesSocietarias().itens()) {
            total.append('+', item.getConsolidacao().getImpostoDiferidoAnosPosteriores());
        }
        for (Alienacao item : demonstrativo.getBensMoveis().itens()) {
            total.append('+', item.getConsolidacao().getImpostoDiferidoAnosPosteriores());
        }
        for (Alienacao item : demonstrativo.getBensImoveis().itens()) {
            total.append('+', item.getConsolidacao().getImpostoDiferidoAnosPosteriores());
        }
        return this.converterParaString(total);
    }

    private String obterValorAquisicao(Alienacao item) {
        ValorPositivo valor = new ValorPositivo();
        valor = item instanceof AlienacaoBemImovel ? (((AlienacaoBemImovel)item).getBemImovel().isAdquiridoNoBrasil() ? ((AlienacaoBem)item).getAquisicao().getCustoAquisicao() : ((AlienacaoBem)item).getAquisicao().getCustoAquisicaoOrigemNacionalDolar()) : (((AlienacaoBemMovel)item).getBemMovel().isAdquiridoNoBrasil() ? ((AlienacaoBem)item).getAquisicao().getCustoAquisicao() : ((AlienacaoBem)item).getAquisicao().getCustoAquisicaoOrigemNacionalDolar());
        return this.converterParaString(valor);
    }

    private void preencherDadosOperacao(Alienacao item, RegistroTxt reg) throws GeracaoTxtException {
        reg.fieldByName("CD_OPERACAO").set(item.getNatureza().getConteudoAtual(0));
        reg.fieldByName("NM_OPERACAO").set(item.getNatureza().getConteudoAtual(1));
        reg.fieldByName("DT_ALIENACAO").set(item.getDataAlienacao().naoFormatado());
        reg.fieldByName("DT_DECISAO_JUDICIAL").set(item.getDataAlienacao().naoFormatado());
        reg.fieldByName("DT_LAVRATURA").set(item.getDataAlienacao().naoFormatado());
        reg.fieldByName("DT_TRANSITO_JULGADO").set(item.getDataTransitoJulgado().naoFormatado());
        reg.fieldByName("IN_ALIENPRAZO").set(item.isAlienacaoAPrazo() ? "0" : "1");
        reg.fieldByName("VR_OPERACAO").set(this.converterParaString(item.getValorAlienacao()));
        if (item instanceof AlienacaoBemImovel) {
            reg.fieldByName("VR_CORRETAGEM").set(((AlienacaoBemImovel)item).getBemImovel().isAdquiridoNoBrasil() ? this.converterParaString(((AlienacaoBem)item).getValorCorretagemReal()) : this.converterParaString(((AlienacaoBem)item).getValorCorretagemDolar()));
        }
        if (item instanceof AlienacaoBemMovel) {
            reg.fieldByName("VR_CORRETAGEM").set(((AlienacaoBemMovel)item).getBemMovel().isAdquiridoNoBrasil() ? this.converterParaString(((AlienacaoBem)item).getValorCorretagemReal()) : this.converterParaString(((AlienacaoBem)item).getValorCorretagemDolar()));
        } else {
            reg.fieldByName("VR_CORRETAGEM").set(this.converterParaString(item.getCustoCorretagem()));
        }
        reg.fieldByName("IN_GCAP_ANTERIOR").set(item.getAlienacaoAnoAnterior().equals(Logico.SIM) ? "0" : "1");
        reg.fieldByName("VR_GCAP_OPERACAO").set(this.converterParaString(item.getValorRecebidoAnosAnteriores()));
    }

    private void preencherDadosApuracao(Alienacao item, RegistroTxt reg) throws GeracaoTxtException {
        reg.fieldByName("VR_VALOR_ALIENACAO_AP").set(this.converterParaString(item.getApuracao().getValorAlienacao()));
        reg.fieldByName("VR_VALOR_ALIENACAO_AP").set(this.converterParaString(item.getApuracao().getCustoCorretagem()));
        reg.fieldByName("VR_VALOR_ALIENACAO_AP").set(this.converterParaString(item.getApuracao().getValorLiquidoAlienacao()));
    }

    private void preencherDadosCalculoImposto(Alienacao item, RegistroTxt reg) throws GeracaoTxtException {
        reg.fieldByName("VR_OPERACAO_BRUTO_ANT").set(this.converterParaString(item.getValorRecebidoAnosAnteriores()));
        reg.fieldByName("VR_CORRETAGEM_ANT").set(this.converterParaString(item.getCorretagemAnosAnteriores()));
        reg.fieldByName("VR_GCAP_CI_ANT_LIQUIDO").set(this.converterParaString(item.getValorLiquidoRecebidoAnosAnteriores()));
        if (item instanceof AlienacaoBemImovel) {
            reg.fieldByName("VR_GCAP_CI").set(((AlienacaoBemImovel)item).getBemImovel().isAdquiridoNoBrasil() ? this.converterParaString(item.getCalculoImposto().getGanhoCapitalTotal()) : this.converterParaString(item.getCalculoImposto().getGanhoCapitalTotal()));
        } else if (item instanceof AlienacaoBemMovel) {
            reg.fieldByName("VR_GCAP_CI").set(((AlienacaoBemMovel)item).getBemMovel().isAdquiridoNoBrasil() ? this.converterParaString(item.getCalculoImposto().getGanhoCapitalTotal()) : this.converterParaString(item.getCalculoImposto().getGanhoCapitalTotal()));
        } else {
            reg.fieldByName("VR_GCAP_CI").set(item.isAlienacaoAVista() ? this.converterParaString(item.getCalculoImposto().getGanhoCapitalTotal()) : this.converterParaString(item.getCalculoImposto().getGanhoCapitalTotal()));
        }
        reg.fieldByName("VR_ALIQUOTA_MEDIA_CI").set(item.isAlienacaoAVista() ? this.converterParaString(item.getCalculoImposto().getAliquotaMedia()) : this.converterParaString(item.getCalculoImposto().getAliquotaMedia()));
        reg.fieldByName("VR_IMPOSTO_DEVIDO_CI").set(item.isAlienacaoAVista() ? this.converterParaString(item.getCalculoImposto().getImpostoDevido()) : this.converterParaString(item.getCalculoImposto().getImpostoDevido()));
        reg.fieldByName("VR_IMPOSTO_PAGO_CI").set(item.isAlienacaoAVista() ? this.converterParaString(item.getCalculoImposto().getImpostoPago()) : this.converterParaString(item.getCalculoImposto().getImpostoDevido()));
    }

    private void preencherDadosConsolidacao(Alienacao item, RegistroTxt reg) throws GeracaoTxtException {
        reg.fieldByName("VR_DIFERIDO_ANTERIORES_CB").set(this.converterParaString(item.getConsolidacao().getImpostoDiferidoAnosAnteriores()));
        reg.fieldByName("VR_EXERCICIO_CB").set(this.converterParaString(item.getConsolidacao().getImpostoReferenteAlienacaoAnoAtual()));
        reg.fieldByName("VR_TOTAL_CB").set(this.converterParaString(item.getConsolidacao().getImpostoTotal()));
        reg.fieldByName("VR_IR_CB").set(this.converterParaString(item.getConsolidacao().getValorIRF()));
        reg.fieldByName("VR_IR_DEVIDO_CB").set(this.converterParaString(item.getConsolidacao().getImpostoDevidoAnoAtual()));
        reg.fieldByName("VR_DIFERIDO_POSTERIOR_CB").set(this.converterParaString(item.getConsolidacao().getImpostoDiferidoAnosPosteriores()));
        reg.fieldByName("VR_IMPOSTO_PAGO_CB").set(this.converterParaString(item.getConsolidacao().getTotalImpostoPago()));
        reg.fieldByName("VR_ISENTO_CB").set(this.converterParaString(item.getConsolidacao().getTotalRendIsentosNaoTributaveis()));
        reg.fieldByName("VR_EXCLUSIVO_CB").set(this.converterParaString(item.getConsolidacao().getTotalRendSujeitosTributacao()));
    }

    private String obterTipoAlienacao(Alienacao item) {
        if (item instanceof AlienacaoBemImovel) {
            return "1";
        }
        if (item instanceof AlienacaoBemMovel) {
            return "2";
        }
        if (item instanceof AlienacaoParticipacaoSocietaria) {
            return "3";
        }
        return "0";
    }
}

