/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.txt.gravacaorestauracao;

import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import java.util.List;
import java.util.logging.Logger;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.util.Validador;

public class ConversorRegistros2ObjetosCarneLeao {
    private static final Logger logger = Logger.getLogger(ConversorRegistros2ObjetosCarneLeao.class.getName());

    public String getNumReciboComDV(String numRecibo) {
        if (numRecibo.trim().length() == 10) {
            String dvNumRecibo1 = "" + Validador.calcularModulo11((String)numRecibo, null, (int)2);
            String dvNumRecibo2 = "" + Validador.calcularModulo11((String)(numRecibo + dvNumRecibo1), null, (int)2);
            return numRecibo + dvNumRecibo1 + dvNumRecibo2;
        }
        return numRecibo;
    }

    public void montarIdDeclaracao(List<RegistroTxt> vRegIdentif, IdDemonstrativoGCAP idDeclaracao) throws GeracaoTxtException {
        RegistroTxt objRegTXT = null;
        try {
            objRegTXT = vRegIdentif.get(0);
        }
        catch (Exception e) {
            throw new GeracaoTxtException("Registro Identifica\u00e7\u00e3o n\u00e3o encontrado no arquivo.");
        }
        String cpf = objRegTXT.fieldByName("NR_CPF").asString();
        idDeclaracao.getCpf().setConteudo(cpf);
        idDeclaracao.getNome().setConteudo(objRegTXT.fieldByName("NM_NOME").asString());
        idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
    }

    public void montarIdentificacaoExercicioAnterior(List<RegistroTxt> vRegistro, IdDemonstrativoGCAP identificacao) throws GeracaoTxtException {
        this.montarIdentificacao(vRegistro, identificacao);
    }

    public void montarIdentificacao(List<RegistroTxt> vRegistro, IdDemonstrativoGCAP identificacao) throws GeracaoTxtException {
        RegistroTxt objRegTXT = vRegistro.get(0);
        identificacao.getCpf().setConteudo(objRegTXT.fieldByName("TP_LOGRADOURO").asString());
        identificacao.getNome().setConteudo(objRegTXT.fieldByName("NM_LOGRADOURO").asString());
        identificacao.getExercicio().setConteudo(objRegTXT.fieldByName("NR_NUMERO").asString());
        identificacao.getDataInicioPermanencia().setConteudo(objRegTXT.fieldByName("NM_COMPLEM").asString());
        identificacao.getDataFimPermanencia().setConteudo(objRegTXT.fieldByName("NM_BAIRRO").asString());
        identificacao.getDataUltimoAcesso().setConteudo(objRegTXT.fieldByName("NR_CEP").asString());
        identificacao.getDddDeclarante().setConteudo(objRegTXT.fieldByName("NM_MUNICIP").asString());
        identificacao.getTelefoneDeclarante().setConteudo(objRegTXT.fieldByName("SG_UF").asString());
        identificacao.getPaisDeclarante().setConteudo(objRegTXT.fieldByName("NR_DDD_TELEFONE").asString());
    }

    public IdDemonstrativoGCAP montarIdDeclaracaoNaoPersistido(List<RegistroTxt> vRegistroIdentificacao, boolean anoAnterior) {
        try {
            RegistroTxt regIdentificacao = vRegistroIdentificacao.get(0);
            IdDemonstrativoGCAP idDeclaracao = new IdDemonstrativoGCAP();
            idDeclaracao.getCpf().setConteudo(regIdentificacao.fieldByName("NR_CPF").asString());
            idDeclaracao.getNome().setConteudo(regIdentificacao.fieldByName("NM_NOME").asString());
            idDeclaracao.getExercicio().setConteudo(ConstantesGlobais.EXERCICIO);
            return idDeclaracao;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

