/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.txt.gravacaorestauracao;

import java.io.File;
import java.util.List;
import java.util.Vector;
import serpro.hash.Crc32;
import serpro.ppgd.formatosexternos.txt.DocumentoTXTDefault;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.util.PLong;

public class DocumentoTxtGCAP
extends DocumentoTXTDefault {
    public static final String ARQ_COPIA_SEG_ANO_ANTERIOR = "ARQ_COPIA_SEG_ANO_ANTERIOR";
    public static final String ARQ_COPIA_SEG_ANO_ANTERIOR_REG_HEADER = "01";
    public static final String ARQ_COPIA_SEG_ANO_ANTERIOR_REG_HEADER_CPF = "NR_CPF";
    public static final String ARQ_COPIA_SEG = "ARQ_COPIA_SEG";
    public static final String ARQ_COPIA_SEG_REG_IDENTIFICACAO = "01";
    public static final String ARQ_COPIA_SEG_REG_IDENTIFICACAO_CPF = "NR_CPF";
    public static final String ARQ_EXPORT = "ARQ_EXPORT";
    public static final String ARQ_EXPORT_REG_HEADER = "01";
    public static final String REGISTRO_HASHCODE = "99";
    public static final String CAMPO_HASHCODE = "HASHCODE";
    public static final String ARQ_DECLARACAO = "GCAP";
    public static final String REG_DECLARACAO = "01";
    public static final String NR_REG = "NR_REG";
    public static final String SISTEMA = "SISTEMA";
    public static final String REG_SISTEMA = "GCAP";
    public static final String ANO_EXERCICIO_IRPF = "EXERCICIO";
    public static final String REG_EXERCICIO = "2017";
    public static final String NR_CPF = "NR_CPF";
    public static final String NM_NOME = "NM_NOME";
    public static final String NR_DDD_TELEFONE = "NR_DDD_TELEFONE";
    public static final String DT_INICIO = "DT_INICIO";
    public static final String DT_FIM = "DT_FIM";
    public static final String CD_PAIS = "CD_PAIS";
    public static final String NM_PAIS = "NM_PAIS";
    public static final String GC_TRANSP_VR_EXCLUSIVO = "GC_TRANSP_VR_EXCLUSIVO";
    public static final String GC_TRANSP_VR_PEQUENO = "GC_TRANSP_VR_PEQUENO";
    public static final String GC_TRANSP_VR_UNICO_IMOVEL = "GC_TRANSP_VR_UNICO_IMOVEL";
    public static final String GC_TRANSP_VR_REDUCAO = "GC_TRANSP_VR_REDUCAO";
    public static final String GC_TRANSP_VR_IMPOSTO_PAGO = "GC_TRANSP_VR_IMPOSTO_PAGO";
    public static final String GC_TRANSP_VR_IMPOSTO_DEVIDO = "GC_TRANSP_VR_IMPOSTO_DEVIDO";
    public static final String GC_TRANSP_VR_ISEN_TRIB = "GC_TRANSP_VR_ISEN_TRIB";
    public static final String GC_TRANSP_VR_IMPOSTO_DIFERIDO_ANOS_POSTERIORES = "GC_TRANSP_VR_IMPOSTO_DIFERIDO_ANOS_POSTERIORES";
    public static final String GC_GCAP_MOEDA = "GC_GCAP_MOEDA";
    public static final String GC_IMPOSTO_DEVIDO_MOEDA = "GC_IMPOSTO_DEVIDO_MOEDA";
    public static final String GC_MOEDA_ALIQUOTA_MEDIA = "GC_MOEDA_ALIQUOTA_MEDIA";
    public static final String NR_CONTROLE = "NR_CONTROLE";
    public static final String NR_OPERACAO = "NR_OPERACAO";
    public static final String IN_BRASIL_EXTERIOR = "IN_BRASIL_EXTERIOR";
    public static final String NM_IMOVEL_DESCRICAO = "NM_IMOVEL_DESCRICAO";
    public static final String NM_MOVEL_DESCRICAO = "NM_MOVEL_DESCRICAO";
    public static final String END_TIPO_LOGRADOURO = "END_TIPO_LOGRADOURO";
    public static final String END_LOGRADOURO = "END_LOGRADOURO";
    public static final String END_NUMERO = "END_NUMERO";
    public static final String END_COMPLEMENTO = "END_COMPLEMENTO";
    public static final String END_BAIRRO = "END_BAIRRO";
    public static final String END_CEP = "END_CEP";
    public static final String END_CD_MUNICIPIO = "END_CD_MUNICIPIO";
    public static final String END_MUNICIPIO = "END_MUNICIPIO";
    public static final String END_UF = "END_UF";
    public static final String DT_AQUISICAO = "DT_AQUISICAO";
    public static final String VR_AQUISICAO = "VR_AQUISICAO";
    public static final String IN_REFORMA = "IN_REFORMA";
    public static final String IN_PEQUENO_VALOR = "IN_PEQUENO_VALOR";
    public static final String IN_PROPR_OUTRO_IMOVEL = "IN_PROPR_OUTRO_IMOVEL";
    public static final String IN_OUTRA_ALIENACAO = "IN_OUTRA_ALIENACAO";
    public static final String IN_UNICO_IMOVEL = "IN_UNICO_IMOVEL";
    public static final String IN_RESIDENCIAL = "IN_RESIDENCIAL";
    public static final String IN_UTILIZAZAO_OUTRO_IMOVEL = "IN_UTILIZAZAO_OUTRO_IMOVEL";
    public static final String VR_UTILIZAZAO_OUTRO_IMOVEL = "VR_UTILIZAZAO_OUTRO_IMOVEL";
    public static final String CD_OPERACAO = "CD_OPERACAO";
    public static final String NM_OPERACAO = "NM_OPERACAO";
    public static final String DT_ALIENACAO = "DT_ALIENACAO";
    public static final String DT_DECISAO_JUDICIAL = "DT_DECISAO_JUDICIAL";
    public static final String DT_LAVRATURA = "DT_LAVRATURA";
    public static final String DT_TRANSITO_JULGADO = "DT_TRANSITO_JULGADO";
    public static final String IN_ALIENPRAZO = "IN_ALIENPRAZO";
    public static final String VR_OPERACAO = "VR_OPERACAO";
    public static final String VR_CORRETAGEM = "VR_CORRETAGEM";
    public static final String IN_GCAP_ANTERIOR = "IN_GCAP_ANTERIOR";
    public static final String VR_GCAP_OPERACAO = "VR_GCAP_OPERACAO";
    public static final String VR_OPERACAO_BRUTO_ANT = "VR_OPERACAO_BRUTO_ANT";
    public static final String VR_CORRETAGEM_ANT = "VR_CORRETAGEM_ANT";
    public static final String VR_GCAP_CI_ANT_LIQUIDO = "VR_GCAP_CI_ANT_LIQUIDO";
    public static final String VR_GCAP_CI = "VR_GCAP_CI";
    public static final String VR_ALIQUOTA_MEDIA_CI = "VR_ALIQUOTA_MEDIA_CI";
    public static final String VR_IMPOSTO_DEVIDO_CI = "VR_IMPOSTO_DEVIDO_CI";
    public static final String VR_IMPOSTO_PAGO_CI = "VR_IMPOSTO_PAGO_CI";
    public static final String VR_DIFERIDO_ANTERIORES_CB = "VR_DIFERIDO_ANTERIORES_CB";
    public static final String VR_EXERCICIO_CB = "VR_EXERCICIO_CB";
    public static final String VR_TOTAL_CB = "VR_TOTAL_CB";
    public static final String VR_IR_CB = "VR_IR_CB";
    public static final String VR_IR_DEVIDO_CB = "VR_IR_DEVIDO_CB";
    public static final String VR_DIFERIDO_POSTERIOR_CB = "VR_DIFERIDO_POSTERIOR_CB";
    public static final String VR_IMPOSTO_PAGO_CB = "VR_IMPOSTO_PAGO_CB";
    public static final String VR_ISENTO_CB = "VR_ISENTO_CB";
    public static final String VR_EXCLUSIVO_CB = "VR_EXCLUSIVO_CB";
    public static final String IN_REGISTRO_PUBLICO = "IN_REGISTRO_PUBLICO";
    public static final String IN_VALOR_SUPERIOR = "IN_VALOR_SUPERIOR";
    public static final String CD_ESPECIE = "CD_ESPECIE";
    public static final String NM_ESPECIE = "NM_ESPECIE";
    public static final String VR_VALOR_ALIENACAO_AP = "VR_VALOR_ALIENACAO_AP";
    public static final String VR_CUSTO_CORRATAGEM_AP = "VR_CUSTO_CORRATAGEM_AP";
    public static final String VR_LIQGUIDO_ALIENACAO_AP = "VR_LIQGUIDO_ALIENACAO_AP";
    public static final String VR_CUSTO_TOTAL_AQUISICAO = "VR_CUSTO_TOTAL_AQUISICAO";
    public static final String VR_CUSTO_TRANSP_PLANILHA = "VR_CUSTO_TRANSP_PLANILHA";
    public static final String IN_TIPO = "IN_TIPO";
    public static final String IN_ORIGEM_REND = "IN_ORIGEM_REND";
    public static final String NM_ORIGEM_REND_DESC = "NM_ORIGEM_REND_DESC";
    public static final String VR_COTACAO_ALIENACAO = "VR_COTACAO_ALIENACAO";
    public static final String VR_COTACAO_AQUISICAO = "VR_COTACAO_AQUISICAO";
    public static final String VR_BEM_AQUISICAO_DOLAR = "VR_BEM_AQUISICAO_DOLAR";
    public static final String VR_BEM_AQUISICAO_RMN = "VR_BEM_AQUISICAO_RMN";
    public static final String FT_BEM_AQUISICAO_RMN = "FT_BEM_AQUISICAO_RMN";
    public static final String VR_BEM_AQUISICAO_RME = "VR_BEM_AQUISICAO_RME";
    public static final String FT_BEM_AQUISICAO_RME = "FT_BEM_AQUISICAO_RME";
    public static final String COD_PAIS_ACORDO = "COD_PAIS_ACORDO";
    public static final String VR_IMPOSTO_REAL_ACORDO = "VR_IMPOSTO_REAL_ACORDO";
    public static final String VR_GCAP_TOTAL_AJUSTE = "VR_GCAP_TOTAL_AJUSTE";
    public static final String FT_ALIQUOTA_MEDIA_AJUSTE = "FT_ALIQUOTA_MEDIA_AJUSTE";
    public static final String VR_IMPOSTO_TOTAL_AJUSTE = "VR_IMPOSTO_TOTAL_AJUSTE";
    public static final String VR_IMPOSTO_PARCELA_AJUSTE = "VR_IMPOSTO_PARCELA_AJUSTE";
    public static final String VR_SALDO_IMPOSTO_AJUSTE = "VR_SALDO_IMPOSTO_AJUSTE";
    public static final String VR_IMPOSTO_PAGO_AJUSTE = "VR_IMPOSTO_PAGO_AJUSTE";
    public static final String NR_CPF_CNPJ = "NR_CPF_CNPJ";
    public static final String NR_NOME = "NR_NOME";
    public static final String NR_ITEM = "NR_ITEM";
    public static final String DT_DATA = "DT_DATA";
    public static final String VR_VALOR_REAIS = "VR_VALOR_REAIS";
    public static final String VR_TOTAL_PARCELA = "VR_TOTAL_PARCELA";
    public static final String VR_COTACAO_AMPLIACAO = "VR_COTACAO_AMPLIACAO";
    public static final String NR_TIPO_APURACAO = "NR_TIPO_APURACAO";
    public static final String VR_LIQUIDO_APURACAO = "VR_LIQUIDO_APURACAO";
    public static final String VR_CUSTO_APURACAO = "VR_CUSTO_APURACAO";
    public static final String VR_RESULTADO_1_APURACAO = "VR_RESULTADO_1_APURACAO";
    public static final String FT_REDUCAO_LEI7713_APURACAO = "FT_REDUCAO_LEI7713_APURACAO";
    public static final String VR_REDUCAO_LEI7713_APURACAO = "VR_REDUCAO_LEI7713_APURACAO";
    public static final String VR_RESULTADO_2_APURACAO = "VR_RESULTADO_2_APURACAO";
    public static final String FT_REDUCAO_LEI11196FR1 = "FT_REDUCAO_LEI11196FR1";
    public static final String VR_REDUCAO_LEI11196FR1 = "VR_REDUCAO_LEI11196FR1";
    public static final String VR_RESULTADO_3_APURACAO = "VR_RESULTADO_3_APURACAO";
    public static final String FT_REDUCAO_LEI11196FR2 = "FT_REDUCAO_LEI11196FR2";
    public static final String VR_REDUCAO_LEI11196FR2 = "VR_REDUCAO_LEI11196FR2";
    public static final String VR_RESULTADO_4_APURACAO = "VR_RESULTADO_4_APURACAO";
    public static final String FT_APLICA_OUTRO_APURACAO = "FT_APLICA_OUTRO_APURACAO";
    public static final String VR_APLICA_OUTRO_APURACAO = "VR_APLICA_OUTRO_APURACAO";
    public static final String VR_RESULTADO_5_APURACAO = "VR_RESULTADO_5_APURACAO";
    public static final String VR_COTACAO_APURACAO = "VR_COTACAO_APURACAO";
    public static final String VR_APURACAO_REAIS = "VR_APURACAO_REAIS";
    public static final String IN_ESPECIE = "IN_ESPECIE";
    public static final String NM_DESCRICAO_ESPECIE = "NM_DESCRICAO_ESPECIE";
    public static final String VR_QUANTIDADE_ALIENADA = "VR_QUANTIDADE_ALIENADA";
    public static final String VR_CUSTO_MEDIO = "VR_CUSTO_MEDIO";
    public static final String VR_CUSTO_TOTAL = "VR_CUSTO_TOTAL";
    public static final String PAIS = "PAIS";
    public static final String NM_MOEDA = "NM_MOEDA";
    public static final String TIPO_OPERACAO = "TIPO_OPERACAO";
    public static final String NI_ADQUIRENTE = "NI_ADQUIRENTE";
    public static final String DT_ALIEN = "DT_ALIEN";
    public static final String VR_ALIEN = "VR_ALIEN";
    public static final String NR_QUANTIDADE = "NR_QUANTIDADE";
    public static final String VR_CUSTO = "VR_CUSTO";
    public static final String VR_CUSTO_ANTERIOR = "VR_CUSTO_ANTERIOR";
    public static final String VR_CUSTO_TOT_AQUIS = "VR_CUSTO_TOT_AQUIS";
    public static final String VR_GANHO_CAPITAL = "VR_GANHO_CAPITAL";
    public static final String VR_SALDO_REAIS = "VR_SALDO_REAIS";
    public static final String VR_SALDO_REAIS_ANT = "VR_SALDO_REAIS_ANT";
    public static final String VR_ME = "VR_ME";
    public static final String VR_ME_ANT = "VR_ME_ANT";

    public DocumentoTxtGCAP(String tipoArquivo, String path) {
        super(tipoArquivo, path);
    }

    public static String montaPathArquivoCopiaSeguranca(File dir, String cpf, String dataInicio, String dataFim) {
        String sistema = cpf + "-" + dataInicio.substring(0, 4) + "-" + dataFim.substring(0, 4) + "-GCAP-" + ConstantesGlobais.EXERCICIO;
        return dir.getPath() + File.separator + sistema + ".DBK";
    }

    public static String montaPathArquivoExportacaoIRPF(File dir, String cpf, String dataInicio, String dataFim) {
        String sistema = "-GCAP-" + dataInicio.substring(0, 4) + "-" + dataFim.substring(0, 4) + "-" + ConstantesGlobais.EXERCICIO + "-" + ConstantesGlobais.EXERCICIO;
        String tipo = "-EXPORTA-IRPF" + ConstantesGlobais.EXERCICIO_POSTERIOR;
        return dir.getPath() + File.separator + cpf + sistema + tipo + ".DEC";
    }

    public void gravarCRC() throws GeracaoTxtException {
        PLong pLongAcumulado = new PLong();
        Crc32 crc32Acumulado = new Crc32();
        long hashCalculadoLinhaAnterior = 0L;
        for (int i = 0; i < this.arquivo().size() - 1; ++i) {
            String linha = (String)this.arquivo().get(i);
            if (hashCalculadoLinhaAnterior != 0L) {
                pLongAcumulado.setValue(hashCalculadoLinhaAnterior);
            }
            hashCalculadoLinhaAnterior = crc32Acumulado.CalcCrc32(linha, linha.length(), pLongAcumulado);
        }
        String crcAcumuladoFinal = String.valueOf(hashCalculadoLinhaAnterior);
        RegistroTxt reg = new RegistroTxt(this.getTipoArquivo(), REGISTRO_HASHCODE);
        reg.setLinha((String)this.arquivo().get(this.arquivo().size() - 1));
        reg.fieldByName(CAMPO_HASHCODE).set(crcAcumuladoFinal);
        this.atualizarRegistros(this.arquivo().size() - 1, reg);
    }

    public void gravarCRC(Vector arquivo) throws GeracaoTxtException {
        PLong pLongAcumulado = new PLong();
        Crc32 crc32Acumulado = new Crc32();
        long hashCalculadoLinhaAnterior = 0L;
        for (int i = 0; i < arquivo.size() - 1; ++i) {
            String linha = (String)arquivo.get(i);
            if (hashCalculadoLinhaAnterior != 0L) {
                pLongAcumulado.setValue(hashCalculadoLinhaAnterior);
            }
            hashCalculadoLinhaAnterior = crc32Acumulado.CalcCrc32(linha, linha.length(), pLongAcumulado);
        }
        String crcAcumuladoFinal = String.valueOf(hashCalculadoLinhaAnterior);
        RegistroTxt reg = new RegistroTxt(this.getTipoArquivo(), REGISTRO_HASHCODE);
        reg.setLinha(arquivo.get(arquivo.size() - 1).toString());
        reg.fieldByName(CAMPO_HASHCODE).set(crcAcumuladoFinal);
        arquivo.add(reg);
    }

    public void verificaCRCCopiaSeguranca(List<String> arquivo, String hashCode) throws GeracaoTxtException {
        PLong pLongAcumulado = new PLong();
        Crc32 crc32Acumulado = new Crc32();
        long hashCalculadoLinhaAnterior = 0L;
        for (int i = 0; i < arquivo.size() - 1; ++i) {
            String linha = arquivo.get(i);
            if (hashCalculadoLinhaAnterior != 0L) {
                pLongAcumulado.setValue(hashCalculadoLinhaAnterior);
            }
            hashCalculadoLinhaAnterior = crc32Acumulado.CalcCrc32(linha, linha.length(), pLongAcumulado);
        }
        String crcAcumuladoFinal = String.valueOf(hashCalculadoLinhaAnterior);
        if (!hashCode.equals(crcAcumuladoFinal)) {
            throw new GeracaoTxtException("Arquivo corrompido");
        }
    }

    public void verificaCRCCopiaSeguranca() throws GeracaoTxtException {
        PLong pLongAcumulado = new PLong();
        Crc32 crc32Acumulado = new Crc32();
        long hashCalculadoLinhaAnterior = 0L;
        for (int i = 0; i < this.arquivo().size() - 1; ++i) {
            String linha = (String)this.arquivo().get(i);
            if (hashCalculadoLinhaAnterior != 0L) {
                pLongAcumulado.setValue(hashCalculadoLinhaAnterior);
            }
            hashCalculadoLinhaAnterior = crc32Acumulado.CalcCrc32(linha, linha.length(), pLongAcumulado);
        }
        String crcAcumuladoFinal = String.valueOf(hashCalculadoLinhaAnterior);
        RegistroTxt reg = (RegistroTxt)this.getRegistrosTxt(REGISTRO_HASHCODE).get(0);
        String crcLido = reg.fieldByName(CAMPO_HASHCODE).asString();
        if (!crcLido.equals(crcAcumuladoFinal)) {
            throw new GeracaoTxtException("Arquivo corrompido");
        }
    }
}

