/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.txt.gravacaorestauracao;

import br.gov.serpro.gcap.acoes.VerificarPendenciasAction;
import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.exception.AplicacaoException;
import br.gov.serpro.gcap.gui.ControladorGui;
import br.gov.serpro.gcap.gui.dialogs.PainelResultadoExportacaoIRPF;
import br.gov.serpro.gcap.gui.dialogs.PainelResultadoGravacao;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.gui.util.ProgressMonitor;
import br.gov.serpro.gcap.gui.util.ProgressUtil;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.txt.gravacaorestauracao.DocumentoTxtGCAP;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.GcapUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import serpro.ppgd.infraestrutura.PlataformaPPGD;

public class GravadorCopiaSeguranca {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gravar(Component parent, File dir, IdDemonstrativoGCAP[] ids) {
        String path = "";
        StringBuffer arquivosComSucesso = new StringBuffer();
        StringBuffer arquivosComErro = new StringBuffer();
        boolean concluiuImportacao = false;
        ProgressMonitor monitor = ProgressUtil.createProgressMonitor(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), ids.length, false, 2000, "Gravando");
        try {
            if (ids.length > 0) {
                path = dir.getPath();
                boolean confirmacao = true;
                String pathArquivo = "";
                for (int i = 0; i < ids.length; ++i) {
                    confirmacao = true;
                    if (i == 0) {
                        monitor.start("Gravando " + (i + 1) + " de " + ids.length);
                    } else {
                        monitor.setCurrent("Gravando " + (i + 1) + " de " + ids.length, i + 1);
                    }
                    IdDemonstrativoGCAP idAtual = ids[i];
                    if (path == "") continue;
                    try {
                        pathArquivo = DocumentoTxtGCAP.montaPathArquivoCopiaSeguranca(dir, idAtual.getCpf().naoFormatado(), idAtual.getDataInicioPermanencia().naoFormatado(), idAtual.getDataFimPermanencia().naoFormatado());
                        File arq = new File(pathArquivo);
                        if (arq.exists() && JOptionPane.showConfirmDialog(parent, MensagemUtil.getMensagem("CopiaSegurancaJaExiste", new String[]{idAtual.getCpf().formatado()}), "Confirma\u00e7\u00e3o", 0) != 0) {
                            confirmacao = false;
                        }
                        if (!confirmacao) continue;
                        ControladorGui.abrirDemonstrativoSemUI(idAtual);
                        ControladorGui.fecharDemonstrativoSemUI();
                        this.gravarCopiaSeguranca(dir, idAtual);
                        concluiuImportacao = true;
                        arquivosComSucesso.append(idAtual.getCpf().naoFormatado() + " - " + idAtual.getNome().naoFormatado() + "\n");
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        arquivosComErro.append(idAtual.getCpf().naoFormatado() + " - " + idAtual.getNome().naoFormatado() + "\n");
                    }
                }
                if (ids.length == 1) {
                    if (concluiuImportacao) {
                        GuiUtil.mostrarInfo("CopiaSegurancaGravadaSucesso");
                    } else if (!confirmacao) {
                        GuiUtil.mostrarInfo("CopiaSegurancaCancelada");
                    } else {
                        GuiUtil.mostrarErro(parent, MensagemUtil.getMensagem("ErroGravarCopiaSeguranca", new String[]{ids[0].getCpf().formatado()}));
                    }
                } else {
                    PainelResultadoGravacao painelResultadoGravacao = new PainelResultadoGravacao();
                    if (arquivosComSucesso.toString().length() > 0) {
                        painelResultadoGravacao.setListaDeclaracoesImportadasOK(arquivosComSucesso.toString());
                    }
                    if (arquivosComErro.toString().length() > 0) {
                        painelResultadoGravacao.setListaDeclaracoesImportadasErro(arquivosComErro.toString());
                    }
                    GuiUtil.exibeDialog(painelResultadoGravacao, true, MensagemUtil.getMensagem("TituloGravarCopiaSeguranca", new String[]{String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt())}), false);
                }
            }
        }
        catch (Exception ev) {
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem("CopiaSegurancaFalha"), "Erro", 0);
            return;
        }
        finally {
            if (monitor != null) {
                monitor.setCurrent("Conclu\u00eddo", ids.length);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportar(Component parent, File dir, IdDemonstrativoGCAP[] ids) {
        String path = "";
        StringBuffer arquivosComSucesso = new StringBuffer();
        StringBuffer arquivosComErro = new StringBuffer();
        boolean concluiuImportacao = false;
        ProgressMonitor monitor = ProgressUtil.createProgressMonitor(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), ids.length, false, 500, "Gravando");
        try {
            if (ids.length > 0) {
                path = dir.getPath();
                boolean confirmacao = true;
                Object pathArquivo = "";
                if (path != "") {
                    for (int i = 0; i < ids.length; ++i) {
                        if (i == 0) {
                            monitor.start("Gravando " + (i + 1) + " de " + ids.length);
                        } else {
                            monitor.setCurrent("Gravando " + (i + 1) + " de " + ids.length, i + 1);
                        }
                        IdDemonstrativoGCAP idAtual = ids[i];
                        DemonstrativoGCAP decAtual = GCAPFacade.getInstancia().recuperarDemonstrativoGCAP(idAtual.getCpf().naoFormatado(), idAtual.getDataInicioPermanencia().formatado(), idAtual.getDataFimPermanencia().formatado());
                        ControladorGui.abrirDemonstrativoSemUI(idAtual);
                        VerificarPendenciasAction verificarPendenciasAction = new VerificarPendenciasAction();
                        VerificarPendenciasAction.PendenciasDemonstrativo pendencias = verificarPendenciasAction.obterPendencias(ControladorGui.getDemonstrativoAberto());
                        ControladorGui.fecharDemonstrativoSemUI();
                        if (pendencias.getTotalErros() > 0) {
                            if (ids.length == 1 && 0 == JOptionPane.showConfirmDialog(parent, MensagemUtil.getMensagem("ErroExportacaoErrosImpeditivosExibirListaPendencias", new String[]{idAtual.getCpf().formatado(), path}), "Confirma\u00e7\u00e3o", 0, 3)) {
                                GCAPFacade.limpaCacheDeclaracoes();
                                ControladorGui.abrirDemonstrativo(decAtual.getIdDemonstrativo(), true);
                                verificarPendenciasAction.exibirPendencias(verificarPendenciasAction.obterPendencias(ControladorGui.getDemonstrativoAberto()));
                                return;
                            }
                            GCAPFacade.limpaCacheDeclaracoes();
                            arquivosComErro.append(idAtual.getCpf().asString() + " - " + idAtual.getNome().asString() + "\n");
                            continue;
                        }
                        confirmacao = true;
                        try {
                            pathArquivo = dir.getPath() + File.separator + idAtual.getNomeArquivo() + ".DEC";
                            File arq = new File((String)pathArquivo);
                            if (arq.exists() && JOptionPane.showConfirmDialog(parent, MensagemUtil.getMensagem("ExportarIRPFJaExiste", new String[]{idAtual.getCpf().formatado()}), "Confirma\u00e7\u00e3o", 0) != 0) {
                                confirmacao = false;
                            }
                            if (!confirmacao) continue;
                            this.exportarParaIRPF(arq, idAtual);
                            concluiuImportacao = true;
                            arquivosComSucesso.append(idAtual.getCpf().asString() + " - " + idAtual.getNome().asString() + "\n");
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem("ExportarIRPFFalha"), "Erro", 0);
                        }
                    }
                }
                if (ids.length == 1) {
                    if (concluiuImportacao) {
                        GuiUtil.mostrarInfo("ExportarIRPFGravadaSucesso");
                    } else if (!confirmacao) {
                        GuiUtil.mostrarInfo("ExportarIRPFCancelada");
                    }
                } else {
                    PainelResultadoExportacaoIRPF painelResultadoGravacao = new PainelResultadoExportacaoIRPF();
                    if (arquivosComSucesso.toString().length() > 0) {
                        painelResultadoGravacao.setListaDeclaracoesImportadasOK(arquivosComSucesso.toString());
                    }
                    if (arquivosComErro.toString().length() > 0) {
                        painelResultadoGravacao.setListaDeclaracoesImportadasErro(arquivosComErro.toString());
                    }
                    GuiUtil.exibeDialog(painelResultadoGravacao, true, MensagemUtil.getMensagem("TituloExportarIRPF", new String[]{String.valueOf(AplicacaoPropertiesUtil.getExercicioAsInt() + 1)}), false);
                }
            }
        }
        catch (Exception ev) {
            ev.printStackTrace();
            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem("ExportarIRPFFalha"), "Erro", 0);
            return;
        }
        finally {
            if (monitor != null) {
                monitor.setCurrent("Conclu\u00eddo", ids.length);
            }
        }
    }

    public void gravarCopiaSeguranca(File diretorioGravacao, IdDemonstrativoGCAP idDemonstrativo) throws Exception {
        Object lCaminhoNomeArquivo = diretorioGravacao.getPath() + File.separator + idDemonstrativo.getNomeArquivo() + ".DBK";
        lCaminhoNomeArquivo = ((String)lCaminhoNomeArquivo).replaceFirst("//", "/");
        Object lCaminhoNomeArquivoDADOS = GcapUtil.DIR_DADOS + File.separator + idDemonstrativo.getCpf().getUltimoConteudoValido() + File.separator + idDemonstrativo.getNomeArquivo() + ".xml";
        lCaminhoNomeArquivoDADOS = ((String)lCaminhoNomeArquivoDADOS).replaceFirst("//", "/");
        this.compactarArquivoSalvandoDados((String)lCaminhoNomeArquivo, (String)lCaminhoNomeArquivoDADOS, false);
    }

    public void exportarParaIRPF(File arquivoGravacao, IdDemonstrativoGCAP idDemonstrativo) throws Exception {
        Object lCaminhoNomeArquivoDADOS = GcapUtil.DIR_DADOS + File.separator + idDemonstrativo.getCpf().getUltimoConteudoValido() + File.separator + idDemonstrativo.getNomeArquivo() + ".xml";
        lCaminhoNomeArquivoDADOS = ((String)lCaminhoNomeArquivoDADOS).replaceFirst("//", "/");
        this.compactarArquivoSalvandoDados(arquivoGravacao.getPath(), (String)lCaminhoNomeArquivoDADOS, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactarArquivoSalvandoDados(String pCaminhoNomeArquivo, String pCaminhoNomeArquivoDADOS, boolean hash) throws Exception {
        ZipOutputStream out = null;
        Writer lWriter = null;
        File fConfig = null;
        try {
            String line;
            out = new ZipOutputStream(new FileOutputStream(pCaminhoNomeArquivo));
            out.setLevel(-1);
            File fCaminhoNomeArquivoDADOS = new File(pCaminhoNomeArquivoDADOS);
            out.putNextEntry(new ZipEntry(fCaminhoNomeArquivoDADOS.getName()));
            BufferedReader bfr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fCaminhoNomeArquivoDADOS), "UTF-8"));
            lWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
            while ((line = bfr.readLine()) != null) {
                lWriter.write(line);
            }
            lWriter.flush();
            bfr.close();
            out.closeEntry();
            fConfig = this.criarArquivoConfiguracao(fCaminhoNomeArquivoDADOS, hash);
            out.putNextEntry(new ZipEntry(fConfig.getName()));
            bfr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fConfig), "UTF-8"));
            lWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
            while ((line = bfr.readLine()) != null) {
                lWriter.write(line + "\n");
            }
            lWriter.flush();
            bfr.close();
            out.closeEntry();
        }
        finally {
            if (lWriter != null) {
                lWriter.close();
            }
            if (fConfig != null) {
                fConfig.delete();
            }
        }
    }

    public File criarArquivoConfiguracao(File arquivoXML, boolean hash) throws AplicacaoException {
        File configFile = null;
        try {
            Properties properties = new Properties();
            properties.setProperty("pgd_version", AplicacaoPropertiesUtil.getVersao());
            properties.setProperty("java_home", System.getProperty("java.home"));
            properties.setProperty("java_version", System.getProperty("java.version"));
            properties.setProperty("os_name", System.getProperty("os.name"));
            properties.setProperty("os_arch", System.getProperty("os.arch"));
            properties.setProperty("os_version", System.getProperty("os.version"));
            if (hash) {
                properties.setProperty("hash", GCAPFacade.calcularHashMD5(arquivoXML));
            } else {
                properties.setProperty("hash", "");
            }
            String path = GcapUtil.DIR_DADOS + File.separator + ".tmp";
            new File(path).mkdirs();
            configFile = new File(path + File.separator + "config.properties");
            FileOutputStream fileOut = new FileOutputStream(configFile);
            properties.store(fileOut, "config.properties");
            fileOut.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adicionarArquivoZip(File fCaminhoNomeArquivoDADOS, ZipOutputStream out) throws Exception {
        try (Writer writer = null;){
            String line;
            out.putNextEntry(new ZipEntry(fCaminhoNomeArquivoDADOS.getName()));
            BufferedReader bfr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fCaminhoNomeArquivoDADOS), "UTF-8"));
            writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            while ((line = bfr.readLine()) != null) {
                writer.write(line);
            }
            writer.flush();
            bfr.close();
            out.closeEntry();
        }
    }
}

