/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.txt.gravacaorestauracao;

import br.gov.serpro.gcap.entidades.DemonstrativoGCAP;
import br.gov.serpro.gcap.entidades.IdDemonstrativoGCAP;
import br.gov.serpro.gcap.txt.gravacaorestauracao.ConversorObjetosCarneLeao2Registros;
import br.gov.serpro.gcap.txt.gravacaorestauracao.ConversorRegistros2ObjetosCarneLeao;
import br.gov.serpro.gcap.txt.gravacaorestauracao.DocumentoAjusteTXT;
import java.io.File;
import java.io.IOException;
import java.util.List;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class RepositorioDeclaracaoCentralTxt {
    private static byte FINALIDADE_ENTREGA = 0;
    private static byte FINALIDADE_BACKUP = 1;
    private DocumentoAjusteTXT arquivo;
    private File file;
    private boolean fLido = false;
    private IdDemonstrativoGCAP objIdArquivo;
    private ConversorRegistros2ObjetosCarneLeao conversor2ObjIRPF;
    private ConversorObjetosCarneLeao2Registros conversor2Registros;

    public RepositorioDeclaracaoCentralTxt(String tipoArq, File file) throws GeracaoTxtException {
        this.file = file;
        this.arquivo = new DocumentoAjusteTXT(tipoArq, file.getPath());
        this.conversor2ObjIRPF = new ConversorRegistros2ObjetosCarneLeao();
        this.conversor2Registros = new ConversorObjetosCarneLeao2Registros();
    }

    public IdDemonstrativoGCAP recuperarIdDeclaracao() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegIdentificacao = this.arquivo.getRegistrosTxt("01");
        this.objIdArquivo = new IdDemonstrativoGCAP();
        this.conversor2ObjIRPF.montarIdDeclaracao(vetorRegIdentificacao, this.objIdArquivo);
        return this.objIdArquivo;
    }

    public void atualizarNroReciboTransmitida(String nrRecibo) throws Exception {
        this.arquivo.atualizarNrReciboTransmitida(nrRecibo);
        this.arquivo.setBKPno();
        this.arquivo.salvar();
    }

    public String recuperarNroRecibo() throws Exception {
        return this.recuperarRegistroHeader().fieldByName("NR_HASH").asString();
    }

    public IdDemonstrativoGCAP recuperarIdDeclaracaoNaoPersistido() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistrosIdentificacao = this.arquivo.getRegistrosTxt("01");
        this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracaoNaoPersistido(vetorRegistrosIdentificacao, false);
        return this.objIdArquivo;
    }

    public IdDemonstrativoGCAP recuperarIdDeclaracaoNaoPersistidoAnoAnterior() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistrosIdentificacao = this.arquivo.getRegistrosTxt("01");
        this.objIdArquivo = this.conversor2ObjIRPF.montarIdDeclaracaoNaoPersistido(vetorRegistrosIdentificacao, true);
        return this.objIdArquivo;
    }

    public void recuperarDeclaracao(IdDemonstrativoGCAP idDecl) throws GeracaoTxtException {
    }

    public void gravarDeclaracao(IdDemonstrativoGCAP objIdDecl) throws GeracaoTxtException, IOException {
    }

    public void salvarDeclaracao(IdDemonstrativoGCAP objIdDecl) throws GeracaoTxtException, IOException {
    }

    public void atualizarDeclaracao(DemonstrativoGCAP objDecl, byte finalidade) throws GeracaoTxtException {
    }

    public void importarDeclaracaoAnoAnterior(DemonstrativoGCAP dec) throws GeracaoTxtException {
        List vetorRegistros = this.arquivo.getRegistrosTxt("01");
        this.conversor2ObjIRPF.montarIdentificacaoExercicioAnterior(vetorRegistros, dec.getIdDemonstrativo());
    }

    public void validarDeclaracao() throws Exception {
        if (this.objIdArquivo == null) {
            this.objIdArquivo = this.recuperarIdDeclaracao();
        }
        this.arquivo.validarCRC();
        this.arquivo.validarHeader(this.objIdArquivo);
    }

    public void validarDeclaracaoNaoPersistido() throws GeracaoTxtException, IOException {
        if (this.objIdArquivo == null) {
            this.objIdArquivo = this.recuperarIdDeclaracaoNaoPersistido();
        }
        this.arquivo.validarCRC();
        this.arquivo.validarHeader(this.objIdArquivo);
    }

    public void lerDeclaracao() throws GeracaoTxtException, IOException {
        if (this.arquivo == null) {
            throw new GeracaoTxtException("Erro durante leitura de arquivo. Nenhum arquivo foi especificado para leitura.");
        }
        if (!this.fLido) {
            this.arquivo.ler();
        }
        this.fLido = true;
    }

    public void lerDeclaracaoValidando() throws GeracaoTxtException, IOException {
        if (this.arquivo == null) {
            this.arquivo = new DocumentoAjusteTXT("ARQ_IRPF", this.file.getPath());
        }
        if (!this.fLido) {
            this.arquivo.ler();
        }
        this.arquivo.validarHashsDeclaracao();
        this.fLido = true;
    }

    public RegistroTxt recuperarRegistroHeader() throws GeracaoTxtException, IOException {
        return null;
    }

    public RegistroTxt recuperarRegistroIdentificacao() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistros = this.arquivo.getRegistrosTxt("01");
        return (RegistroTxt)vetorRegistros.get(0);
    }

    public RegistroTxt recuperarRegistroFinalEspolio() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistros = this.arquivo.getRegistrosTxt("38");
        return (RegistroTxt)vetorRegistros.get(0);
    }

    public RegistroTxt recuperarRegistroSaida() throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        List vetorRegistros = this.arquivo.getRegistrosTxt("39");
        return (RegistroTxt)vetorRegistros.get(0);
    }

    public RegistroTxt recuperarRegistroRecibo() throws GeracaoTxtException, IOException {
        return null;
    }

    public RegistroTxt recuperarRegistroComplementoRecibo() throws GeracaoTxtException, IOException {
        return null;
    }

    public RegistroTxt recuperarRegistroComplementoReciboMulta() throws GeracaoTxtException, IOException {
        return null;
    }

    public RegistroTxt recuperarRegistroComplementoReciboValidador() throws GeracaoTxtException, IOException {
        return null;
    }

    public String getPath() {
        return this.file.getPath();
    }

    private boolean getValidaHash() {
        return !UtilitariosArquivo.extraiExtensaoAquivo((String)this.getPath()).toUpperCase().equals(".F2B");
    }

    public void validarComplementoRecibo(IdDemonstrativoGCAP idDecl) throws GeracaoTxtException, IOException {
        this.lerDeclaracao();
        this.arquivo.validarCRCAcumulado();
        this.arquivo.validarComplRecibo(idDecl);
    }

    public DocumentoAjusteTXT getArquivo() {
        return this.arquivo;
    }
}

