/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class LeitorArquivoAjuda {
    private static LeitorArquivoAjuda instancia = null;
    private static String ARQUIVO = null;
    private HashMap<String, String> mapa = new LinkedHashMap<String, String>();

    private LeitorArquivoAjuda() {
        try {
            this.lerArquivo();
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    private void lerArquivo() throws IOException {
        try (FileInputStream in = new FileInputStream(ARQUIVO);
             InputStreamReader streamReader = new InputStreamReader((InputStream)in, "ISO-8859-1");
             BufferedReader reader = new BufferedReader(streamReader);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                String nomeTela = line.substring(0, line.indexOf("=\""));
                String textoAjuda = line.substring(line.indexOf("\"") + 1, line.lastIndexOf("\""));
                this.mapa.put(nomeTela, textoAjuda);
            }
        }
    }

    public static LeitorArquivoAjuda getInstance() {
        if (instancia == null) {
            instancia = new LeitorArquivoAjuda();
        }
        return instancia;
    }

    public String getTexto(String nomeTela) {
        return String.valueOf(this.mapa.get(nomeTela));
    }

    public static void main(String[] args) {
        try {
            LeitorArquivoAjuda.getInstance().lerArquivo();
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
        }
    }

    static {
        ARQUIVO = FabricaUtilitarios.isMac() ? UtilitariosArquivo.getPathAplicacao() + "../GCAP.acb" : UtilitariosArquivo.getPathAplicacao() + "GCAP.acb";
    }
}

