/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.util.calc;

import br.gov.serpro.gcap.entidades.ValorBigDecimal;
import br.gov.serpro.gcap.entidades.ValorPositivo;
import br.gov.serpro.gcap.gui.PainelDemonstrativoAb;
import br.gov.serpro.gcap.gui.table.editors.PPGDCellEditorIf;
import br.gov.serpro.gcap.gui.util.GuiUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import br.gov.serpro.gcap.util.calc.CalculadoraForm;
import br.gov.serpro.gcap.util.calc.OperadorCalculadora;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.editors.PPGDFormattedTextField;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;

public class CalculadoraComValorInterno
extends PainelDemonstrativoAb
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JDialog janela = null;
    private CalculadoraForm calculadoraForm = null;
    private OperadorCalculadora operadorCalc = new OperadorCalculadora();
    private Valor memoria = null;
    private String operador = null;
    private boolean iniciouOperacao = false;
    private boolean reiniciaDigitos = false;
    private boolean isTransporteEmTabela;
    private EscutadorMouse escutadorMouse;
    private boolean transportando = false;
    private PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
    private JComponent contentPlataforma;
    private Component glassPlataforma;
    private JMenuBar menuBar;
    private Component destComponent;

    public CalculadoraComValorInterno() {
        super(new BorderLayout());
        this.setBackground(new Color(220, 236, 244));
        this.calculadoraForm = new CalculadoraForm();
        this.calculadoraForm.addActionListener(this);
        this.configuraBackspace(this.calculadoraForm);
        this.memoria = new Valor(null, "Mem\u00f3ria");
        this.calculadoraForm.getTecladoForm().getDisplayMemoria().setVisible(false);
        this.menuBar = this.plataforma.getJanelaPrincipal().getJMenuBar();
        this.contentPlataforma = (JComponent)this.plataforma.getJanelaPrincipal().getContentPane();
        this.add((Component)this.calculadoraForm, "Center");
        this.escutadorMouse = new EscutadorMouse();
        this.reiniciaResultado();
        GuiUtil.adicionarListenerF11(this.calculadoraForm.getDisplayForm().getDisplayValor(), MensagemUtil.getMensagem("TituloCalculadora"));
        GuiUtil.adicionarListenerF11(this.calculadoraForm.getDisplayForm(), MensagemUtil.getMensagem("TituloCalculadora"));
        GuiUtil.adicionarListenerF11(this.calculadoraForm.getTecladoForm(), MensagemUtil.getMensagem("TituloCalculadora"));
    }

    private void configuraBackspace(JPanel panel) {
        KeyStroke stroke = KeyStroke.getKeyStroke("BACK_SPACE");
        String key = "backspace";
        panel.getInputMap(2).put(stroke, key);
        panel.getActionMap().put(key, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String valorDisplay = CalculadoraComValorInterno.this.calculadoraForm.getDisplayForm().getValorInterno();
                if (valorDisplay.length() > 0) {
                    String novoValor = valorDisplay.substring(0, valorDisplay.length() - 1);
                    CalculadoraComValorInterno.this.calculadoraForm.getDisplayForm().atualiza(novoValor);
                }
            }
        });
    }

    private void compactaJanela() {
        if (this.getJanela() != null) {
            this.calculadoraForm.setCompacto(true);
            this.getJanela().pack();
        }
    }

    private void descompactaJanela() {
        if (this.getJanela() != null) {
            this.calculadoraForm.setCompacto(false);
            Dimension prefSize = this.getJanela().getPreferredSize();
            Dimension size = this.getJanela().getSize();
            this.getJanela().pack();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int qtdDigitos = this.calculadoraForm.getDisplayForm().getValorInterno().length();
        if (this.calculadoraForm.getDisplayForm().getValorInterno().indexOf(44) != -1) {
            --qtdDigitos;
        }
        String cmd = e.getActionCommand();
        if (this.reiniciaDigitos || qtdDigitos < 11) {
            if ("0123456789".indexOf(cmd) > -1) {
                this.processaDigito(cmd);
            } else if (cmd.equals(",")) {
                this.processaVirgula();
            }
        }
        if ("+-X/".indexOf(cmd) > -1) {
            if (this.iniciouOperacao) {
                this.processaOperacao();
            }
            this.operador = cmd.equals("X") ? "*" : cmd;
            this.operadorCalc.setOperandoA(this.calculadoraForm.getDisplayForm().getValorFormatado());
            this.iniciouOperacao = true;
            this.reiniciaDigitos = true;
            this.calculadoraForm.gravarNoHistorico(this.calculadoraForm.getDisplayForm().getValorFormatado());
            this.calculadoraForm.gravarNoHistorico(this.operador);
        } else if ("=".equals(cmd) && this.operador != null) {
            this.calculadoraForm.gravarNoHistorico(this.calculadoraForm.getDisplayForm().getValorFormatado());
            this.calculadoraForm.gravarNoHistorico("=");
            this.processaOperacao();
            this.calculadoraForm.gravarNoHistorico(this.calculadoraForm.getDisplayForm().getValorFormatado());
        } else if ("AC".equals(cmd)) {
            this.reiniciaResultado();
            this.operador = null;
            this.operadorCalc.reiniciaOperandoA();
            this.iniciouOperacao = false;
            this.calculadoraForm.getHistoricoPane().setText("");
        } else if ("CE".equals(cmd)) {
            this.reiniciaResultado();
        } else if ("+/-".equals(cmd)) {
            Valor valorAtual = new Valor(this.calculadoraForm.getDisplayForm().getValorInterno());
            valorAtual.append('*', "-1");
            this.calculadoraForm.getDisplayForm().atualiza(valorAtual.getConteudoFormatado());
        } else if ("MC".equals(cmd)) {
            this.memoria = new Valor(null, "Mem\u00f3ria");
            this.calculadoraForm.getTecladoForm().getDisplayMemoria().setVisible(false);
        } else if ("MR".equals(cmd)) {
            this.calculadoraForm.getDisplayForm().atualiza(this.memoria.getConteudoFormatado());
        } else if ("M+".equals(cmd)) {
            Valor num = new Valor(this.calculadoraForm.getDisplayForm().getValorInterno());
            if (num.getCasasDecimais() > this.memoria.getCasasDecimais()) {
                this.memoria.converteQtdCasasDecimais(num.getCasasDecimais());
            }
            this.memoria.append('+', num);
            this.calculadoraForm.getTecladoForm().getDisplayMemoria().setVisible(true);
        } else if ("M-".equals(cmd)) {
            this.memoria.append('-', this.calculadoraForm.getDisplayForm().getValorInterno());
            this.calculadoraForm.getTecladoForm().getDisplayMemoria().setVisible(true);
        } else if ("Transportar".equals(cmd)) {
            if (this.calculadoraForm.getDisplayForm().getValorInterno().indexOf("-") == -1) {
                this.iniciaTransportar();
            } else {
                GuiUtil.mostrarAviso("transporte_negativo");
            }
        } else if ("Cancelar".equals(cmd)) {
            this.terminouTransporte();
        }
        this.calculadoraForm.getDisplayForm().getDisplayValor().getAccessibleContext().setAccessibleName(this.calculadoraForm.getDisplayForm().getDisplayValor().getText());
        this.calculadoraForm.getDisplayForm().getDisplayValor().requestFocus();
    }

    private void processaOperacao() {
        this.operadorCalc.setOperandoB(this.calculadoraForm.getDisplayForm().getValorInterno());
        ValorBigDecimal result = this.operadorCalc.processaOperacao(this.operador.charAt(0));
        this.calculadoraForm.getDisplayForm().atualiza(result.getConteudoFormatado(), true);
        this.operador = null;
        this.iniciouOperacao = false;
        this.reiniciaDigitos = true;
    }

    private void iniciaTransportar() {
        this.isTransporteEmTabela = false;
        this.compactaJanela();
        this.updateUI();
        this.glassPlataforma = this.plataforma.getJanelaPrincipal().getGlassPane();
        this.glassPlataforma.setVisible(true);
        this.glassPlataforma.addMouseMotionListener(this.escutadorMouse);
        this.glassPlataforma.addMouseListener(this.escutadorMouse);
        this.setTransportando(true);
    }

    private void processaVirgula() {
        if (this.reiniciaDigitos) {
            this.reiniciaDigitos = false;
            this.reiniciaResultado();
        } else if (this.calculadoraForm.getDisplayForm().getValorInterno().indexOf(44) != -1) {
            return;
        }
        this.calculadoraForm.getDisplayForm().atualiza(this.calculadoraForm.getDisplayForm().getValorInterno() + ",");
    }

    private void processaDigito(String cmd) {
        String strDisplay;
        if (this.reiniciaDigitos) {
            this.reiniciaDigitos = false;
            this.reiniciaResultado();
        }
        if ((strDisplay = this.calculadoraForm.getDisplayForm().getValorInterno()).equals("0")) {
            this.calculadoraForm.getDisplayForm().atualiza(cmd);
        } else {
            this.calculadoraForm.getDisplayForm().atualiza(this.calculadoraForm.getDisplayForm().getValorInterno() + cmd);
        }
    }

    private void reiniciaResultado() {
        this.calculadoraForm.getDisplayForm().atualiza("0");
    }

    private boolean podeTransportarParaGrid(int lin, int col) {
        this.isTransporteEmTabela = true;
        if (lin >= 0 && col >= 0 && ((JTable)this.destComponent).isCellEditable(lin, col)) {
            ((JTable)this.destComponent).editCellAt(lin, col);
            PPGDCellEditorIf cellEditor = (PPGDCellEditorIf)((Object)((JTable)this.destComponent).getCellEditor(lin, col));
            JEditCampo edit = cellEditor.getEditCampo();
            if (edit.getInformacao() instanceof Valor && edit.getInformacao().isHabilitado() && !edit.getInformacao().isReadOnly()) {
                return true;
            }
        }
        return false;
    }

    private void aplicaCursorPodeTransportar() {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void aplicaCursorNaoPodeTransportar() {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(DragSource.DefaultCopyNoDrop);
    }

    private void tentaTransportar() {
        if (this.destComponent instanceof PPGDFormattedTextField) {
            PPGDFormattedTextField formattedTextField = (PPGDFormattedTextField)this.destComponent;
            Informacao info = formattedTextField.getInformacao();
            if (this.destComponent.isEnabled() && info != null && info.isHabilitado() && !info.isReadOnly()) {
                if (info instanceof Valor) {
                    Valor valorDest = (Valor)formattedTextField.getInformacao();
                    int qtdCasas = valorDest.getCasasDecimais();
                    String valorDeTransporte = this.calculadoraForm.getDisplayForm().getValorInternoTruncado(qtdCasas);
                    valorDeTransporte = valorDeTransporte.replaceAll("\\.", "");
                    if (Double.valueOf(valorDeTransporte = valorDeTransporte.replace(',', '.')) < 0.0 && info instanceof ValorPositivo && !this.isTransporteEmTabela) {
                        GuiUtil.mostrarAviso("ErroDeTentativaDeTrasnporteDeValorNegativo");
                    } else {
                        valorDest.clear();
                        valorDest.setConteudo(this.calculadoraForm.getDisplayForm().getValorInternoTruncado(qtdCasas));
                        this.destComponent.requestFocusInWindow();
                    }
                }
                this.terminouTransporte();
            }
        }
    }

    public void terminouTransporte() {
        if (this.isTransportando()) {
            this.descompactaJanela();
            this.glassPlataforma.removeMouseMotionListener(this.escutadorMouse);
            this.glassPlataforma.removeMouseListener(this.escutadorMouse);
            this.aplicaCursorDefault();
            this.setTransportando(false);
        }
    }

    private void aplicaCursorDefault() {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane().setCursor(Cursor.getDefaultCursor());
        super.setCursor(Cursor.getDefaultCursor());
    }

    private void setTransportando(boolean transportando) {
        this.transportando = transportando;
    }

    public boolean isTransportando() {
        return this.transportando;
    }

    public void setJanela(JDialog janela) {
        this.janela = janela;
    }

    public JDialog getJanela() {
        return this.janela;
    }

    class EscutadorMouse
    extends MouseAdapter {
        EscutadorMouse() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (CalculadoraComValorInterno.this.isTransportando()) {
                CalculadoraComValorInterno.this.tentaTransportar();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (CalculadoraComValorInterno.this.menuBar != null) {
                y -= CalculadoraComValorInterno.this.menuBar.getHeight();
            }
            CalculadoraComValorInterno.this.destComponent = SwingUtilities.getDeepestComponentAt(CalculadoraComValorInterno.this.contentPlataforma, x, y);
            if (CalculadoraComValorInterno.this.isTransportando()) {
                if (CalculadoraComValorInterno.this.destComponent instanceof PPGDFormattedTextField) {
                    Informacao info = ((PPGDFormattedTextField)CalculadoraComValorInterno.this.destComponent).getInformacao();
                    if (CalculadoraComValorInterno.this.destComponent.isEnabled() && info != null && info instanceof Valor && info.isHabilitado() && !info.isReadOnly()) {
                        CalculadoraComValorInterno.this.aplicaCursorPodeTransportar();
                    }
                } else if (CalculadoraComValorInterno.this.destComponent instanceof JTable) {
                    int col;
                    Point p = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), CalculadoraComValorInterno.this.destComponent);
                    int lin = ((JTable)CalculadoraComValorInterno.this.destComponent).rowAtPoint(p);
                    if (CalculadoraComValorInterno.this.podeTransportarParaGrid(lin, col = ((JTable)CalculadoraComValorInterno.this.destComponent).columnAtPoint(p))) {
                        CalculadoraComValorInterno.this.aplicaCursorPodeTransportar();
                    } else {
                        CalculadoraComValorInterno.this.aplicaCursorNaoPodeTransportar();
                    }
                } else {
                    CalculadoraComValorInterno.this.aplicaCursorNaoPodeTransportar();
                }
            }
        }
    }
}

