/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.util.scriptlet;

import br.gov.serpro.gcap.tabelas.CadastroTabelasGCAP;
import java.text.ParseException;
import javax.swing.text.MaskFormatter;
import net.sf.jasperreports.engine.JRDefaultScriptlet;
import serpro.ppgd.negocio.ElementoTabela;

public class FuncoesFormatacao
extends JRDefaultScriptlet {
    public static String teste(String x) {
        return "abcd";
    }

    public static String corrigirString(String value) {
        if (value == null) {
            value = "";
        }
        return value.replaceAll("(\\A(\\n|\\s|\\t)+)|((\\n|\\s|\\t)+\\z)", "");
    }

    public static String formatarCPF(String value) {
        value = FuncoesFormatacao.corrigirString(value);
        try {
            MaskFormatter mask = new MaskFormatter("###.###.###-##");
            mask.setValueContainsLiteralCharacters(false);
            return mask.valueToString(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String formatarCNPJ(String value) {
        value = FuncoesFormatacao.corrigirString(value);
        try {
            MaskFormatter mask = new MaskFormatter("##.###.###/####-##");
            mask.setValueContainsLiteralCharacters(false);
            return mask.valueToString(value);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String formatarNI(String value) {
        if ((value = FuncoesFormatacao.corrigirString(value)).length() < 12) {
            return FuncoesFormatacao.formatarCPF(value);
        }
        return FuncoesFormatacao.formatarCNPJ(value);
    }

    public static String formatarNome(String value) {
        value = FuncoesFormatacao.corrigirString(value);
        return value.replaceAll("(\\n|\\s|\\t)+", " ");
    }

    public static String obterTiposOrigemRendimentos(String codigo) {
        String origemRendimentos = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarTiposOrigemRendimentos()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            origemRendimentos = et.getConteudo(1);
            break;
        }
        return origemRendimentos;
    }

    public static String obterDescricaoNaturezaGCAPBemImovel(String codigo) {
        String descricao = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarNaturezaGCAPBemImovel()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            descricao = et.getConteudo(1);
            break;
        }
        return descricao;
    }

    public static String obterDescricaoNaturezaGCMEBemImovel(String codigo) {
        String descricao = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarNaturezaGCMEBemImovel()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            descricao = et.getConteudo(1);
            break;
        }
        return descricao;
    }

    public static String obterDescricaoNaturezaGCAPBemMovelDireitos(String codigo) {
        String descricao = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarNaturezaGCAPBemMovelDireitos()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            descricao = et.getConteudo(1);
            break;
        }
        return descricao;
    }

    public static String obterDescricaoNaturezaGCMEBemMovelDireitos(String codigo) {
        String descricao = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarNaturezaGCMEBemMovelDireitos()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            descricao = et.getConteudo(1);
            break;
        }
        return descricao;
    }

    public static String obterDescricaoNaturezaParticipacaoSocietaria(String codigo) {
        String descricao = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarNaturezaParticipacaoSocietaria()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            descricao = et.getConteudo(1);
            break;
        }
        return descricao;
    }

    public static String obterEspecieOperacaoParticipacaoSocietaria(String codigo) {
        String especie = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarEspecieOperacaoPSocietaria()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            especie = et.getConteudo(1);
            break;
        }
        return especie;
    }

    public static String obterEspecieAquisicaoPSAcoes(String codigo) {
        String especie = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarEspecieAquisicaoPSAcoes()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            especie = et.getConteudo(1);
            break;
        }
        return especie;
    }

    public static String obterTipoLogradouro(String codigo) {
        String tipo = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarTiposLogradouro()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            tipo = et.getConteudo(1);
            break;
        }
        return tipo;
    }

    public static void main(String[] args) {
        System.out.println("R: " + FuncoesFormatacao.obterTipoLogradouro("NUCLEO"));
    }

    public static String obterNomeMunicipio(String uf, String codigo) {
        String municipio = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarMunicipios(uf, 1)) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            municipio = et.getConteudo(1);
            break;
        }
        return municipio;
    }

    public static String obterNomePaises(String codigo) {
        String pais = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarPaises()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            pais = et.getConteudo(1);
            break;
        }
        return pais;
    }

    public static String obterFlagParaisoFiscalPais(String codigo) {
        String pais = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarPaises()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            pais = et.getConteudo(2);
            break;
        }
        return pais;
    }

    public static String obterDescricaoMoeda(String codigo) {
        String moeda = "";
        for (ElementoTabela et : CadastroTabelasGCAP.recuperarMoedas()) {
            if (!et.getConteudo(0).equals(codigo)) continue;
            moeda = et.getConteudo(1);
            break;
        }
        return moeda;
    }

    public static String retornaValorFaixa(String conteudoFaixas, String posicao) {
        String retorno = null;
        conteudoFaixas = conteudoFaixas.replace("|", "#");
        String[] arrayInicial = conteudoFaixas.split("#");
        String[][] arrayFaixas = new String[10][10];
        for (int i = 0; i < arrayInicial.length; ++i) {
            String[] arraySegundo = arrayInicial[i].split(";");
            for (int k = 0; k < arraySegundo.length; ++k) {
                arrayFaixas[i][k] = arraySegundo[k];
            }
        }
        switch (posicao) {
            case "1": {
                retorno = arrayFaixas[0][0];
                break;
            }
            case "2": {
                retorno = arrayFaixas[0][1];
                break;
            }
            case "3": {
                retorno = arrayFaixas[0][2];
                break;
            }
            case "4": {
                retorno = arrayFaixas[1][0];
                break;
            }
            case "5": {
                retorno = arrayFaixas[1][1];
                break;
            }
            case "6": {
                retorno = arrayFaixas[1][2];
                break;
            }
            case "7": {
                retorno = arrayFaixas[2][0];
                break;
            }
            case "8": {
                retorno = arrayFaixas[2][1];
                break;
            }
            case "9": {
                retorno = arrayFaixas[2][2];
                break;
            }
            case "10": {
                retorno = arrayFaixas[3][0];
                break;
            }
            case "11": {
                retorno = arrayFaixas[3][1];
                break;
            }
            case "12": {
                retorno = arrayFaixas[3][2];
                break;
            }
            case "13": {
                retorno = arrayFaixas[4][0];
                break;
            }
            case "14": {
                retorno = arrayFaixas[4][1];
                break;
            }
            case "15": {
                retorno = arrayFaixas[4][2];
                break;
            }
        }
        return retorno;
    }
}

