/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.validador;

import java.util.Date;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorComparacao;

public class ValidadorComparacaoData
extends ValidadorComparacao {
    private byte regraValidacao = 1;

    public ValidadorComparacaoData(byte severidade, byte regra, Object parValidacao) {
        super(severidade, regra, parValidacao);
        this.regraValidacao = regra;
    }

    public RetornoValidacao validarImplementado() {
        return ValidadorComparacaoData.validarImplementado((Data)this.getInformacao(), (Data)this.getParValidacao(), this.regraValidacao);
    }

    public static RetornoValidacao validarImplementado(Data pInformacao, Data pParValidacao, byte pRegraValidacao) {
        Date lData1 = pInformacao.asDate();
        Date lData2 = pParValidacao.asDate();
        if (lData1 == null || lData2 == null) {
            return null;
        }
        String msg = null;
        String nomeCampo = pInformacao.getNomeCampo();
        String nomeParValidacao = pParValidacao.getNomeCampo();
        int r = lData1.compareTo(lData2);
        switch (pRegraValidacao) {
            case 0: {
                if (r == 0) break;
                msg = "\"" + nomeCampo + "\" \u00e9 diferente de \"" + nomeParValidacao + "\"";
                break;
            }
            case 1: {
                if (r != 0) break;
                msg = "\"" + nomeCampo + "\" \u00e9 igual de \"" + nomeParValidacao + "\"";
                break;
            }
            case -2: {
                if (r < 0) break;
                msg = "A \"" + nomeCampo + "\" deve ser anterior \u00e0 \"" + nomeParValidacao + "\"";
                break;
            }
            case -3: {
                if (r <= 0) break;
                msg = "A \"" + nomeCampo + "\" deve ser igual ou anterior \u00e0 \"" + nomeParValidacao + "\"";
                break;
            }
            case 2: {
                if (r > 0) break;
                msg = "A \"" + nomeCampo + "\" deve ser posterior \u00e0 \"" + nomeParValidacao + "\"";
                break;
            }
            case 3: {
                if (r >= 0) break;
                msg = "A \"" + nomeCampo + "\" deve ser igual ou posterior \u00e0 \"" + nomeParValidacao + "\"";
                break;
            }
            default: {
                throw new IllegalArgumentException("regra de valida\u00e7\u00e3o inv\u00e1lida: " + pRegraValidacao);
            }
        }
        if (msg != null) {
            return new RetornoValidacao(msg);
        }
        return null;
    }
}

