/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.validador;

import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorComparacao;

public class ValidadorComparacaoValor
extends ValidadorComparacao {
    private byte regraValidacao = 1;

    public ValidadorComparacaoValor(byte severidade, byte regra, Object parValidacao) {
        super(severidade, regra, parValidacao);
        this.regraValidacao = regra;
    }

    public RetornoValidacao validarImplementado() {
        return ValidadorComparacaoValor.validarImplementado((Valor)this.getInformacao(), (Valor)this.getParValidacao(), this.regraValidacao);
    }

    public static RetornoValidacao validarImplementado(Valor pInformacao, Valor pParValidacao, byte pRegraValidacao) {
        if (pInformacao == null || pParValidacao == null) {
            return null;
        }
        String msg = null;
        String nomeCampo = pInformacao.getNomeCampo();
        String nomeParValidacao = pParValidacao.getNomeCampo();
        int r = pInformacao.compareTo(pParValidacao);
        switch (pRegraValidacao) {
            case 0: {
                if (r == 0) break;
                msg = "\"" + nomeCampo + "\" \u00e9 diferente de \"" + nomeParValidacao + "\"";
                break;
            }
            case 1: {
                if (r != 0) break;
                msg = "\"" + nomeCampo + "\" \u00e9 igual de \"" + nomeParValidacao + "\"";
                break;
            }
            case -2: {
                if (r < 0) break;
                msg = "O \"" + nomeCampo + "\" n\u00e3o pode ser maior ou igual ao \"" + nomeParValidacao + "\"";
                break;
            }
            case -3: {
                if (r <= 0) break;
                msg = "O \"" + nomeCampo + "\" deve ser igual ou menor ao \"" + nomeParValidacao + "\"";
                break;
            }
            case 2: {
                if (r > 0) break;
                msg = "O \"" + nomeCampo + "\" deve ser posterior \u00e0 \"" + nomeParValidacao + "\"";
                break;
            }
            case 3: {
                if (r >= 0) break;
                msg = "O \"" + nomeCampo + "\" deve ser igual ou maior ao \"" + nomeParValidacao + "\"";
                break;
            }
            default: {
                throw new IllegalArgumentException("regra de valida\u00e7\u00e3o inv\u00e1lida: " + pRegraValidacao);
            }
        }
        if (msg != null) {
            return new RetornoValidacao(msg);
        }
        return null;
    }
}

