/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.validador;

import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.negocio.GCAPFacade;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.lang.ref.WeakReference;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorDataAlienacao
extends ValidadorDefault {
    WeakReference<Alienacao> weakAlienacao;

    public ValidadorDataAlienacao(Alienacao alienacao, byte severidade) {
        super(severidade);
        this.weakAlienacao = new WeakReference<Alienacao>(alienacao);
    }

    public RetornoValidacao validarImplementado() {
        Data lData = new Data();
        lData.setConteudo(this.getInformacao().naoFormatado());
        if (GCAPFacade.getInstancia().getDeclaracao() != null && lData.naoFormatado().length() == 8 && AplicacaoPropertiesUtil.getExercicio().equals(lData.getAno()) && lData.maisAntiga(GCAPFacade.getInstancia().getDeclaracao().getIdDemonstrativo().getDataInicioPermanencia())) {
            return new RetornoValidacao(MensagemUtil.getMensagem("dataAlienacaoAnteriorDemonstrativo"));
        }
        if (GCAPFacade.getInstancia().getDeclaracao() != null && lData.maisNova(GCAPFacade.getInstancia().getDeclaracao().getIdDemonstrativo().getDataFimPermanencia())) {
            return new RetornoValidacao(MensagemUtil.getMensagem("dataAlienacaoPosteriorDemonstrativo"));
        }
        return new RetornoValidacao(0);
    }
}

