/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.validador;

import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBemImovel;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.entidades.alienacao.ParcelaAlienacao;
import br.gov.serpro.gcap.util.AplicacaoPropertiesUtil;
import br.gov.serpro.gcap.util.MensagemUtil;
import java.lang.ref.WeakReference;
import java.util.Calendar;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ValidadorDataRecebimentoParcela
extends ValidadorNaoNulo {
    private WeakReference<Alienacao> weakAlienacao = null;
    private ParcelaAlienacao parcela;

    public ValidadorDataRecebimentoParcela(Alienacao weakAlienacao, ParcelaAlienacao parcela) {
        super((byte)3);
        this.weakAlienacao = new WeakReference<Alienacao>(weakAlienacao);
        this.parcela = parcela;
    }

    public RetornoValidacao validarImplementado() {
        Data dataRecebimento = (Data)this.getInformacao();
        String exercicio = AplicacaoPropertiesUtil.getExercicio();
        boolean jaTemUltimaParcela = false;
        boolean parcelaPosteriorUltima = false;
        boolean existeParcelaAposUltima = false;
        boolean existeParcelaNaMesmaData = false;
        boolean parcelaFora180Dias = false;
        if (this.weakAlienacao.get() instanceof AlienacaoBem) {
            jaTemUltimaParcela = ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().jaTemUltimaParcela();
            parcelaPosteriorUltima = ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().parcelaPosteriorUltima(dataRecebimento);
            existeParcelaAposUltima = ((AlienacaoBem)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().existeParcelaAposUltima(this.parcela);
        } else if (this.weakAlienacao.get() instanceof AlienacaoParticipacaoSocietaria) {
            jaTemUltimaParcela = ((AlienacaoParticipacaoSocietaria)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().jaTemUltimaParcela();
            parcelaPosteriorUltima = ((AlienacaoParticipacaoSocietaria)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().parcelaPosteriorUltima(dataRecebimento);
            existeParcelaAposUltima = ((AlienacaoParticipacaoSocietaria)((Object)this.weakAlienacao.get())).getColecaoParcelaAlienacao().existeParcelaAposUltima(this.parcela);
        }
        if (this.weakAlienacao.get() instanceof AlienacaoBemImovel && !dataRecebimento.isVazio() && ((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).criticarLei180Dias() && ((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().isValorReaplicadoTotalmente()) {
            Calendar calendarDataAlienacao = Calendar.getInstance();
            if (((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().isValorReaplicadoPrimeiraAlienacao() && ((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().getDataPrimeiraAlienacao().isValido() && !((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().getDataPrimeiraAlienacao().isVazio()) {
                calendarDataAlienacao.setTime(((AlienacaoBemImovel)((Object)this.weakAlienacao.get())).getPerguntas().getDataPrimeiraAlienacao().asDate());
            } else {
                calendarDataAlienacao.setTime(((Alienacao)((Object)this.weakAlienacao.get())).getDataAlienacao().asDate());
            }
            calendarDataAlienacao.add(5, 180);
            if (dataRecebimento.asDate().after(calendarDataAlienacao.getTime())) {
                parcelaFora180Dias = true;
            }
        }
        if (!dataRecebimento.isVazio()) {
            if (((Alienacao)((Object)this.weakAlienacao.get())).isAlienacaoBrasil() && !exercicio.equals(dataRecebimento.getAno())) {
                return new RetornoValidacao(MensagemUtil.getMensagem("dataParcelaForaExercicio", new String[]{exercicio, exercicio}));
            }
            if (!((Alienacao)((Object)this.weakAlienacao.get())).isAlienacaoBrasil() && dataRecebimento.getAno().matches("\\d{4}") && Integer.valueOf(dataRecebimento.getAno()) > Integer.valueOf(exercicio)) {
                return new RetornoValidacao(MensagemUtil.getMensagem("dataParcelaPosteriorExercicio", new String[]{exercicio, exercicio}));
            }
            if (jaTemUltimaParcela) {
                return new RetornoValidacao(MensagemUtil.getMensagem("JaExisteUltimaParcelaInformada"));
            }
            if (parcelaPosteriorUltima) {
                return new RetornoValidacao(MensagemUtil.getMensagem("ParcelaPosteriorUltima"));
            }
            if (this.parcela.getDataRecebimento().maisAntiga(((Alienacao)((Object)this.weakAlienacao.get())).getDataAlienacao())) {
                return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinhaHTML("dataParcelaAnteriorAlienacao"));
            }
            if (existeParcelaAposUltima) {
                return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinhaHTML("dataParcelaPosteriorUltimaParcela"));
            }
            if (existeParcelaNaMesmaData) {
                return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinhaHTML("dataParcelaIgualOutraParcela"));
            }
            if (parcelaFora180Dias) {
                return new RetornoValidacao(MensagemUtil.getMensagemComQuebraDeLinhaHTML("dataParcelaSuperior180Dias"));
            }
        }
        return new RetornoValidacao(0);
    }
}

