/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.validador;

import java.util.StringTokenizer;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;

public class ValidadorNomePessoaFisica
extends ValidadorDefault {
    public ValidadorNomePessoaFisica(byte severidade) {
        super(severidade);
    }

    public RetornoValidacao validarImplementado() {
        RetornoValidacao retorno = ValidadorNomePessoaFisica.validarNomeCompleto(this.getInformacao().asString());
        if (retorno != null) {
            retorno.setSeveridade(this.getSeveridade());
            this.setMensagemValidacao(retorno.getMensagemValidacao());
        }
        return retorno;
    }

    public static RetornoValidacao validarNomeCompleto(String nomeCompleto) {
        String testeNome;
        if (nomeCompleto.length() > 60) {
            return new RetornoValidacao("Nome tem mais que 60 caracteres.");
        }
        StringTokenizer testeNomeCompleto = new StringTokenizer(nomeCompleto);
        if (testeNomeCompleto.countTokens() > 15) {
            return new RetornoValidacao("Nome deve ter no m\u00e1ximo quinze partes.");
        }
        RetornoValidacao rValidacao = null;
        while (testeNomeCompleto.hasMoreTokens() && (rValidacao = ValidadorNomePessoaFisica.validarNome(testeNome = testeNomeCompleto.nextToken(), !testeNomeCompleto.hasMoreTokens())) == null) {
        }
        return rValidacao;
    }

    private static RetornoValidacao validarNome(String parteNomeCompleto, boolean heUltimaParteNome) {
        if (parteNomeCompleto.length() > 20) {
            return new RetornoValidacao("Cada parte do nome deve ter no m\u00e1ximo 20 caracteres.");
        }
        int letrasRepetidas = 1;
        for (int j = 1; j < parteNomeCompleto.length(); ++j) {
            letrasRepetidas = parteNomeCompleto.charAt(j) == parteNomeCompleto.charAt(j - 1) ? ++letrasRepetidas : 1;
            if (!(letrasRepetidas != 3 || parteNomeCompleto.equals("III") && heUltimaParteNome)) {
                return new RetornoValidacao("N\u00e3o \u00e9 poss\u00edvel a informa\u00e7\u00e3o do mesmo caractere por 3 ou mais vezes consecutivas.");
            }
            if (Character.isDigit(parteNomeCompleto.charAt(j - 1))) {
                return new RetornoValidacao("Nome n\u00e3o pode ter n\u00fameros.");
            }
            if (Character.isLetter(parteNomeCompleto.charAt(j - 1))) continue;
            return new RetornoValidacao("Nome tem caracteres inv\u00e1lidos.");
        }
        if (Character.isDigit(parteNomeCompleto.charAt(parteNomeCompleto.length() - 1))) {
            return new RetornoValidacao("Nome n\u00e3o pode ter n\u00fameros.");
        }
        if (!Character.isLetter(parteNomeCompleto.charAt(parteNomeCompleto.length() - 1))) {
            return new RetornoValidacao("Nome tem caracteres inv\u00e1lidos.");
        }
        return null;
    }
}

