/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.gcap.validador;

import br.gov.serpro.gcap.entidades.alienacao.Alienacao;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoBem;
import br.gov.serpro.gcap.entidades.alienacao.AlienacaoParticipacaoSocietaria;
import br.gov.serpro.gcap.util.MensagemUtil;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNaoNulo;

public class ValidadorPerguntaAlienacaoParcial
extends ValidadorNaoNulo {
    private Data dataAlienacao;
    private Codigo naturezaAlienacao;
    private Codigo especieParticipacao;

    public ValidadorPerguntaAlienacaoParcial(Data dataAlienacao, Codigo naturezaAlienacao, Codigo especieParticipacao) {
        super((byte)3);
        this.dataAlienacao = dataAlienacao;
        this.naturezaAlienacao = naturezaAlienacao;
        this.especieParticipacao = especieParticipacao;
    }

    public RetornoValidacao validarImplementado() {
        int anoAlienacao = 0;
        boolean aliquotaFixa = false;
        boolean fundoInvestimento = false;
        try {
            anoAlienacao = Integer.valueOf(this.dataAlienacao.getAno());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            int codNatureza = Integer.valueOf(this.naturezaAlienacao.naoFormatado());
            aliquotaFixa = AlienacaoBem.CODIGO_NATUREZA_TRASMISSAO_CAUSA_MORTIS == codNatureza || AlienacaoBem.CODIGO_NATUREZA_DISSOLUCAO_DA_SOCIEDADE_CONJUGAL_OU_UNIAO_ESTAVEL == codNatureza || AlienacaoBem.CODIGO_NATUREZA_DOACAO_ADIANTAMENTO_LEGITIMA == codNatureza;
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.especieParticipacao != null && (AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_FII.equals(this.especieParticipacao.naoFormatado()) || AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_PARTICIPACOES.equals(this.especieParticipacao.naoFormatado()) || AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_EMPRESAS_EMERGENTES.equals(this.especieParticipacao.naoFormatado()) || AlienacaoParticipacaoSocietaria.CODIGO_ESPECIE_FUNDOS_INVESTIMENTOS_COTAS_FUNDOS_INVESTIMENTOS_PARTICIPACOES.equals(this.especieParticipacao.naoFormatado()))) {
                fundoInvestimento = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!aliquotaFixa && !fundoInvestimento && (this.dataAlienacao.isVazio() || anoAlienacao >= Alienacao.CONSTANTE_ANO_MINIMO_ALIENACAO_PARCIAL) && this.getInformacao().isVazio()) {
            return new RetornoValidacao(MensagemUtil.getMensagem("perguntaEmBranco", new String[]{this.getInformacao().getNomeCampo()}));
        }
        return new RetornoValidacao(0);
    }
}

