/*
 * Decompiled with CFR 0.152.
 */
package ml.options;

import java.util.ArrayList;
import java.util.regex.Pattern;
import ml.options.Options;

public class OptionData {
    private static final String CLASS = "OptionData";
    private Options.Prefix prefix = null;
    private String key = null;
    private boolean detail = false;
    private Options.Separator separator = null;
    private boolean value = false;
    private Options.Multiplicity multiplicity = null;
    private Pattern pattern = null;
    private int counter = 0;
    private ArrayList<String> values = null;
    private ArrayList<String> details = null;

    OptionData(Options.Prefix prefix, String key, boolean detail, Options.Separator separator, boolean value, Options.Multiplicity multiplicity) {
        if (prefix == null) {
            throw new IllegalArgumentException("OptionData: prefix may not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("OptionData: key may not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("OptionData: separator may not be null");
        }
        if (multiplicity == null) {
            throw new IllegalArgumentException("OptionData: multiplicity may not be null");
        }
        this.prefix = prefix;
        this.key = key;
        this.detail = detail;
        this.separator = separator;
        this.value = value;
        this.multiplicity = multiplicity;
        this.pattern = value ? (separator == Options.Separator.BLANK ? (detail ? Pattern.compile(prefix.getName() + key + "((\\w|\\.)+)$") : Pattern.compile(prefix.getName() + key + "$")) : (detail ? Pattern.compile(prefix.getName() + key + "((\\w|\\.)+)" + separator.getName() + "(.+)$") : Pattern.compile(prefix.getName() + key + separator.getName() + "(.+)$"))) : Pattern.compile(prefix.getName() + key + "$");
        if (value) {
            this.values = new ArrayList();
            if (detail) {
                this.details = new ArrayList();
            }
        }
    }

    Options.Prefix getPrefix() {
        return this.prefix;
    }

    String getKey() {
        return this.key;
    }

    boolean useDetail() {
        return this.detail;
    }

    Options.Separator getSeparator() {
        return this.separator;
    }

    boolean useValue() {
        return this.value;
    }

    Options.Multiplicity getMultiplicity() {
        return this.multiplicity;
    }

    Pattern getPattern() {
        return this.pattern;
    }

    public int getResultCount() {
        if (this.value) {
            return this.values.size();
        }
        return this.counter;
    }

    public String getResultValue(int index) {
        if (!this.value) {
            return null;
        }
        if (index < 0 || index >= this.getResultCount()) {
            throw new IllegalArgumentException("OptionData: illegal value for index");
        }
        return this.values.get(index);
    }

    public String getResultDetail(int index) {
        if (!this.detail) {
            return null;
        }
        if (index < 0 || index >= this.getResultCount()) {
            throw new IllegalArgumentException("OptionData: illegal value for index");
        }
        return this.details.get(index);
    }

    void addResult(String valueData, String detailData) {
        if (this.value) {
            if (valueData == null) {
                throw new IllegalArgumentException("OptionData: valueData may not be null");
            }
            this.values.add(valueData);
            if (this.detail) {
                if (detailData == null) {
                    throw new IllegalArgumentException("OptionData: detailData may not be null");
                }
                this.details.add(detailData);
            }
        }
        ++this.counter;
    }

    public String toString() {
        StringBuffer sb;
        block4: {
            sb = new StringBuffer();
            sb.append("Prefix      : ");
            sb.append((Object)this.prefix);
            sb.append('\n');
            sb.append("Key         : ");
            sb.append(this.key);
            sb.append('\n');
            sb.append("Detail      : ");
            sb.append(this.detail);
            sb.append('\n');
            sb.append("Separator   : ");
            sb.append((Object)this.separator);
            sb.append('\n');
            sb.append("Value       : ");
            sb.append(this.value);
            sb.append('\n');
            sb.append("Multiplicity: ");
            sb.append((Object)this.multiplicity);
            sb.append('\n');
            sb.append("Pattern     : ");
            sb.append(this.pattern);
            sb.append('\n');
            sb.append("Results     : ");
            sb.append(this.counter);
            sb.append('\n');
            if (!this.value) break block4;
            if (this.detail) {
                for (int i = 0; i < this.values.size(); ++i) {
                    sb.append(this.details.get(i));
                    sb.append(" / ");
                    sb.append(this.values.get(i));
                    sb.append('\n');
                }
            } else {
                for (int i = 0; i < this.values.size(); ++i) {
                    sb.append(this.values.get(i));
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }
}

