/*
 * Decompiled with CFR 0.152.
 */
package ml.options;

import java.util.ArrayList;
import java.util.HashMap;
import ml.options.OptionData;
import ml.options.Options;

public class OptionSet {
    private static final String CLASS = "OptionSet";
    private ArrayList<OptionData> options = new ArrayList();
    private HashMap<String, OptionData> keys = new HashMap();
    private ArrayList<String> unmatched = new ArrayList();
    private ArrayList<String> data = new ArrayList();
    private String setName = null;
    private int minData = 0;
    private int maxData = 0;
    private Options.Prefix prefix = null;
    private Options.Multiplicity defaultMultiplicity = null;

    OptionSet(Options.Prefix prefix, Options.Multiplicity defaultMultiplicity, String setName, int minData, int maxData) {
        if (setName == null) {
            throw new IllegalArgumentException("OptionSet: setName may not be null");
        }
        if (minData < 0) {
            throw new IllegalArgumentException("OptionSet: minData must be >= 0");
        }
        if (maxData < minData) {
            throw new IllegalArgumentException("OptionSet: maxData must be >= minData");
        }
        this.prefix = prefix;
        this.defaultMultiplicity = defaultMultiplicity;
        this.setName = setName;
        this.minData = minData;
        this.maxData = maxData;
    }

    public ArrayList<OptionData> getOptionData() {
        return this.options;
    }

    public OptionData getOption(String key) {
        if (key == null) {
            throw new IllegalArgumentException("OptionSet: key may not be null");
        }
        if (!this.keys.containsKey(key)) {
            throw new IllegalArgumentException("OptionSet: unknown key: " + key);
        }
        return this.keys.get(key);
    }

    public boolean isSet(String key) {
        if (key == null) {
            throw new IllegalArgumentException("OptionSet: key may not be null");
        }
        if (!this.keys.containsKey(key)) {
            throw new IllegalArgumentException("OptionSet: unknown key: " + key);
        }
        return this.keys.get(key).getResultCount() > 0;
    }

    public String getSetName() {
        return this.setName;
    }

    public int getMinData() {
        return this.minData;
    }

    public int getMaxData() {
        return this.maxData;
    }

    public ArrayList<String> getData() {
        return this.data;
    }

    public ArrayList<String> getUnmatched() {
        return this.unmatched;
    }

    public OptionSet addOption(String key) {
        return this.addOption(key, this.defaultMultiplicity);
    }

    public OptionSet addOption(String key, Options.Multiplicity multiplicity) {
        return this.addOption(key, false, Options.Separator.NONE, false, multiplicity);
    }

    public OptionSet addOption(String key, Options.Separator separator) {
        return this.addOption(key, false, separator, true, this.defaultMultiplicity);
    }

    public OptionSet addOption(String key, Options.Separator separator, Options.Multiplicity multiplicity) {
        return this.addOption(key, false, separator, true, multiplicity);
    }

    public OptionSet addOption(String key, boolean details, Options.Separator separator) {
        return this.addOption(key, details, separator, true, this.defaultMultiplicity);
    }

    public OptionSet addOption(String key, boolean details, Options.Separator separator, Options.Multiplicity multiplicity) {
        return this.addOption(key, details, separator, true, multiplicity);
    }

    OptionSet addOption(String key, boolean details, Options.Separator separator, boolean value, Options.Multiplicity multiplicity) {
        if (key == null) {
            throw new IllegalArgumentException("OptionSet: key may not be null");
        }
        if (multiplicity == null) {
            throw new IllegalArgumentException("OptionSet: multiplicity may not be null");
        }
        if (separator == null) {
            throw new IllegalArgumentException("OptionSet: separator may not be null");
        }
        if (this.keys.containsKey(key)) {
            throw new IllegalArgumentException("OptionSet: the key " + key + " has already been defined for this OptionSet");
        }
        OptionData od = new OptionData(this.prefix, key, details, separator, value, multiplicity);
        this.options.add(od);
        this.keys.put(key, od);
        return this;
    }
}

