/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import net.java.balloontip.styles.BalloonTipStyle;

public class TexturedBalloonStyle
extends BalloonTipStyle {
    private final int arcWidth;
    private final int arcHeight;
    private final BufferedImage bg;
    private final Rectangle bgBounds;
    private final Color borderColor;

    public TexturedBalloonStyle(int arcWidth, int arcHeight, URL background, Color borderColor) throws IOException {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.bg = ImageIO.read(background);
        this.bgBounds = new Rectangle(0, 0, this.bg.getWidth(), this.bg.getHeight());
        this.borderColor = borderColor;
    }

    public Insets getBorderInsets(Component c) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + this.arcHeight, this.arcWidth, this.arcHeight, this.arcWidth);
        }
        return new Insets(this.arcHeight, this.arcWidth, this.arcHeight + this.verticalOffset, this.arcWidth);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        int yBottom;
        int yTop;
        Graphics2D g2d = (Graphics2D)g;
        --width;
        --height;
        if (this.flipY) {
            yTop = y + this.verticalOffset;
            yBottom = y + height;
        } else {
            yTop = y;
            yBottom = y + height - this.verticalOffset;
        }
        GeneralPath outline = new GeneralPath();
        outline.moveTo(x + this.arcWidth, yTop);
        outline.quadTo(x, yTop, x, yTop + this.arcHeight);
        outline.lineTo(x, yBottom - this.arcHeight);
        outline.quadTo(x, yBottom, x + this.arcWidth, yBottom);
        if (!this.flipX && !this.flipY) {
            outline.lineTo(x + this.horizontalOffset, yBottom);
            outline.lineTo(x + this.horizontalOffset, yBottom + this.verticalOffset);
            outline.lineTo(x + this.horizontalOffset + this.verticalOffset, yBottom);
        } else if (this.flipX && !this.flipY) {
            outline.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yBottom);
            outline.lineTo(x + width - this.horizontalOffset, yBottom + this.verticalOffset);
            outline.lineTo(x + width - this.horizontalOffset, yBottom);
        }
        outline.lineTo(x + width - this.arcWidth, yBottom);
        outline.quadTo(x + width, yBottom, x + width, yBottom - this.arcHeight);
        outline.lineTo(x + width, yTop + this.arcHeight);
        outline.quadTo(x + width, yTop, x + width - this.arcWidth, yTop);
        if (!this.flipX && this.flipY) {
            outline.lineTo(x + this.horizontalOffset + this.verticalOffset, yTop);
            outline.lineTo(x + this.horizontalOffset, yTop - this.verticalOffset);
            outline.lineTo(x + this.horizontalOffset, yTop);
        } else if (this.flipX && this.flipY) {
            outline.lineTo(x + width - this.horizontalOffset, yTop);
            outline.lineTo(x + width - this.horizontalOffset, yTop - this.verticalOffset);
            outline.lineTo(x + width - this.horizontalOffset - this.verticalOffset, yTop);
        }
        outline.closePath();
        g2d.setPaint(new TexturePaint(this.bg, this.bgBounds));
        g2d.fill(outline);
        g2d.setPaint(this.borderColor);
        g2d.draw(outline);
    }

    public int getMinimalHorizontalOffset() {
        return this.arcWidth + this.verticalOffset;
    }
}

