/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.apache.commons.beanutils.ConvertUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import serpro.ppgd.negocio.util.LogPPGD;

public class JRXmlDataSourcePPGD
implements JRRewindableDataSource {
    private static final String[] CLASSES_XPATH_API = new String[]{"com.sun.org.apache.xpath.internal.CachedXPathAPI", "org.apache.xpath.CachedXPathAPI", "com.sun.org.apache.xpath.internal.XPathAPI", "org.apache.xpath.XPathAPI"};
    private Document document;
    private String selectExpression;
    private NodeList nodeList;
    private int nodeListLength;
    private Node currentNode;
    private int currentNodeIndex = -1;
    private Object xpathAPI;

    public JRXmlDataSourcePPGD(Document document) throws JRException {
        this(document, ".");
    }

    public JRXmlDataSourcePPGD(Document document, String selectExpression) throws JRException {
        Class<?> xpathClass = null;
        xpathClass = this.getXpathClass();
        try {
            this.xpathAPI = xpathClass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.document = document;
        this.selectExpression = selectExpression;
        this.moveFirst();
    }

    private Class<?> getXpathClass() {
        Class<?> xpathClass = null;
        for (int i = 0; i < CLASSES_XPATH_API.length; ++i) {
            try {
                xpathClass = Class.forName(CLASSES_XPATH_API[i]);
            }
            catch (ClassNotFoundException e) {
                xpathClass = null;
            }
            if (xpathClass == null) continue;
            i = CLASSES_XPATH_API.length + 1;
        }
        if (xpathClass == null) {
            throw new IllegalArgumentException("N\u00e3o foi poss\u00edvel encontrar nenhuma biblioteca do XPathAPI ou CachedXPathAPI!");
        }
        return xpathClass;
    }

    public JRXmlDataSourcePPGD(InputStream in) throws JRException {
        this(in, ".");
    }

    public JRXmlDataSourcePPGD(InputStream in, String selectExpression) throws JRException {
        this(JRXmlDataSourcePPGD.parse(new InputSource(in)), selectExpression);
    }

    public JRXmlDataSourcePPGD(String uri) throws JRException {
        this(uri, ".");
    }

    public JRXmlDataSourcePPGD(String uri, String selectExpression) throws JRException {
        this(JRXmlDataSourcePPGD.parse(new InputSource(uri)), selectExpression);
    }

    public JRXmlDataSourcePPGD(File file) throws JRException {
        this(file, ".");
    }

    public JRXmlDataSourcePPGD(File file, String selectExpression) throws JRException {
        this(JRXmlDataSourcePPGD.parse(file), selectExpression);
    }

    private static Document parse(InputSource is) throws JRException {
        try {
            return JRXmlDataSourcePPGD.createDocumentBuilder().parse(is);
        }
        catch (SAXException e) {
            throw new JRException("Failed to parse the xml document", (Throwable)e);
        }
        catch (IOException e) {
            throw new JRException("Failed to parse the xml document", (Throwable)e);
        }
    }

    private static Document parse(File file) throws JRException {
        try {
            return JRXmlDataSourcePPGD.createDocumentBuilder().parse(file);
        }
        catch (SAXException e) {
            throw new JRException("Failed to parse the xml document", (Throwable)e);
        }
        catch (IOException e) {
            throw new JRException("Failed to parse the xml document", (Throwable)e);
        }
    }

    private static DocumentBuilder createDocumentBuilder() throws JRException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setIgnoringComments(true);
        try {
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new JRException("Failed to create a document builder factory", (Throwable)e);
        }
    }

    public void moveFirst() throws JRException {
        if (this.document == null) {
            throw new JRException("document cannot be not null");
        }
        if (this.selectExpression == null) {
            throw new JRException("selectExpression cannot be not null");
        }
        try {
            this.currentNode = null;
            this.currentNodeIndex = -1;
            this.nodeListLength = 0;
            try {
                Method mSelectNodeList = this.getXpathClass().getMethod("selectNodeList", Node.class, String.class);
                this.nodeList = (NodeList)mSelectNodeList.invoke(this.xpathAPI, this.document, this.selectExpression);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.nodeListLength = this.nodeList.getLength();
        }
        catch (Exception e) {
            throw new JRException("XPath selection failed. Expression: " + this.selectExpression, (Throwable)e);
        }
    }

    public boolean next() throws JRException {
        if (this.currentNodeIndex == this.nodeListLength - 1) {
            return false;
        }
        this.currentNode = this.nodeList.item(++this.currentNodeIndex);
        return true;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        if (this.currentNode == null) {
            return null;
        }
        String expression = jrField.getDescription();
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Object value = null;
        Class valueClass = jrField.getValueClass();
        if (Object.class != valueClass) {
            String text;
            Node node = null;
            try {
                try {
                    Method mSelectSingleNode = this.getXpathClass().getMethod("selectSingleNode", Node.class, String.class);
                    node = (Node)mSelectSingleNode.invoke(this.xpathAPI, this.currentNode, expression);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                throw new JRException("XPath selection failed. Expression: " + expression, (Throwable)e);
            }
            if (node != null && (text = this.getText(node)) != null) {
                value = String.class == valueClass ? text : ConvertUtils.convert((String)text.trim(), (Class)valueClass);
            }
        }
        return value;
    }

    public JRXmlDataSourcePPGD subDataSource(String selectExpression) throws JRException {
        if (this.currentNode == null) {
            throw new JRException("No node available. Iterate or rewind the data source.");
        }
        Document document = JRXmlDataSourcePPGD.createDocumentBuilder().newDocument();
        Node node = document.importNode(this.currentNode, true);
        document.appendChild(node);
        return new JRXmlDataSourcePPGD(document, selectExpression);
    }

    public JRXmlDataSourcePPGD subDataSource() throws JRException {
        return this.subDataSource(".");
    }

    public JRXmlDataSourcePPGD dataSource(String selectExpression) throws JRException {
        return new JRXmlDataSourcePPGD(this.document, selectExpression);
    }

    public JRXmlDataSourcePPGD dataSource() throws JRException {
        return this.dataSource(".");
    }

    public String getText(Node node) {
        if (!node.hasChildNodes()) {
            return node.getNodeValue();
        }
        StringBuilder result = new StringBuilder();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            String value;
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() == 4) {
                value = subnode.getNodeValue();
                if (value == null) continue;
                result.append(value);
                continue;
            }
            if (subnode.getNodeType() != 5 || (value = this.getText(subnode)) == null) continue;
            result.append(value);
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        JRXmlDataSourcePPGD ds = new JRXmlDataSourcePPGD(new FileInputStream("northwind.xml"), "/Northwind/Customers");
        JRDesignField field = new JRDesignField();
        field.setDescription("CustomerID");
        field.setValueClass(String.class);
        ds.next();
        String v = (String)ds.getFieldValue((JRField)field);
        LogPPGD.debug((String)(field.getDescription() + "=" + v));
        JRXmlDataSourcePPGD subDs = ds.dataSource("/Northwind/Orders");
        JRDesignField field1 = new JRDesignField();
        field1.setDescription("OrderID");
        field1.setValueClass(String.class);
        subDs.next();
        String v1 = (String)subDs.getFieldValue((JRField)field1);
        System.out.println(field1.getDescription() + "=" + v1);
    }
}

