/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos;

import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.data.JRXmlDataSource;
import serpro.ppgd.formatosexternos.JRXmlDataSourcePPGD;
import serpro.ppgd.formatosexternos.PPGDJasperViewer;
import serpro.ppgd.formatosexternos.RelatorioIf;
import serpro.ppgd.negocio.util.LogPPGD;

public class RelatorioXML
implements RelatorioIf {
    private String xml;
    private String raiz;
    private String relatorioJasper;
    private String titulo;
    private boolean habilitado = true;
    private Map<String, Object> parametros = new HashMap<String, Object>();

    public RelatorioXML(String aTitulo, String aRelatorioJasper, String aXml, String aRaiz) {
        this.setTitulo(aTitulo);
        if (aRelatorioJasper != null) {
            this.setRelatorioJasper(aRelatorioJasper.replaceAll("%20", " "));
        }
        if (aXml != null) {
            this.setXml(aXml.replaceAll("%20", " "));
        }
        this.setRaiz(aRaiz);
    }

    public RelatorioXML(String aTitulo, String aRelatorioJasper) {
        this.setTitulo(aTitulo);
        if (aRelatorioJasper != null) {
            this.setRelatorioJasper(aRelatorioJasper.replaceAll("%20", " "));
        }
    }

    @Override
    public void visualizar() {
        try {
            JasperPrint print;
            if (this.getXml() != null && !this.getXml().equals("")) {
                JRXmlDataSourcePPGD xmlDataSource = new JRXmlDataSourcePPGD(new File(this.getXml()), this.getRaiz());
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                LogPPGD.debug((String)("rel jasper: " + this.getRelatorioJasper()));
                LogPPGD.debug((String)("streamrel: " + streamRel));
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            } else {
                JREmptyDataSource xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                LogPPGD.debug((String)("rel jasper: " + this.getRelatorioJasper()));
                LogPPGD.debug((String)("streamrel: " + streamRel));
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            }
            PPGDJasperViewer viewer = new PPGDJasperViewer(print, false, new Locale("pt", "BR"));
            viewer.setTitle(this.getTitulo());
            viewer.setIconImage(Frame.getFrames()[0].getIconImage());
            viewer.addWindowFocusListener(new WindowFocusListener(){
                private boolean firstLost = true;

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (this.firstLost) {
                        e.getWindow().toFront();
                        this.firstLost = false;
                    }
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }
            });
            viewer.setVisible(true);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public void addParametro(String nome, String valor) {
        this.parametros.put(nome, valor);
    }

    public void addParametro(String nome, Object valor) {
        this.parametros.put(nome, valor);
    }

    public Map<String, Object> getAllParametro() {
        return this.parametros;
    }

    @Override
    public void imprimir() {
        try {
            JasperPrint print;
            if (this.getXml() != null && !this.getXml().equals("")) {
                JRXmlDataSourcePPGD xmlDataSource = new JRXmlDataSourcePPGD(new File(this.getXml()), this.getRaiz());
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            } else {
                JREmptyDataSource xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            }
            JasperPrintManager.printReport((JasperPrint)print, (boolean)false);
        }
        catch (JRException e) {
            e.printStackTrace();
        }
    }

    public JasperPrint obterPaginas() {
        try {
            JasperPrint print;
            if (this.getXml() != null && !this.getXml().equals("")) {
                JRXmlDataSource xmlDataSource = new JRXmlDataSource(new File(this.getXml()), this.getRaiz());
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                LogPPGD.debug((String)("rel jasper: " + this.getRelatorioJasper()));
                LogPPGD.debug((String)("streamrel: " + streamRel));
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            } else {
                JREmptyDataSource xmlDataSource = new JREmptyDataSource();
                InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getRelatorioJasper());
                print = JasperFillManager.fillReport((InputStream)streamRel, this.parametros, (JRDataSource)xmlDataSource);
            }
            return print;
        }
        catch (JRException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setHabilitado(boolean habilitado) {
        this.habilitado = habilitado;
    }

    @Override
    public boolean isHabilitado() {
        return this.habilitado;
    }

    public void setXml(String xml) {
        this.xml = xml;
    }

    public String getXml() {
        return this.xml;
    }

    private void setRaiz(String raiz) {
        this.raiz = raiz;
    }

    private String getRaiz() {
        return this.raiz;
    }

    private void setRelatorioJasper(String relatorioJasper) {
        this.relatorioJasper = relatorioJasper;
    }

    private String getRelatorioJasper() {
        return this.relatorioJasper;
    }

    @Override
    public void setTitulo(String titulo) {
        this.titulo = titulo;
    }

    @Override
    public String getTitulo() {
        return this.titulo;
    }

    @Override
    public void prepara() {
    }

    @Override
    public boolean isPreparado() {
        return false;
    }
}

