/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.formatosexternos.txt;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.formatosexternos.txt.RegistroTxt;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.negocio.util.UtilitariosString;

public abstract class DocumentoTXT {
    private List<String> vectorDeclaracao = new ArrayList<String>();
    private String fTipoArquivo;
    private boolean fAlterado = true;
    private boolean fBKP = true;
    private String fPath;

    public DocumentoTXT(String tipoArquivo, String path) {
        this.fPath = path;
        this.fTipoArquivo = tipoArquivo;
    }

    protected List<String> lerLinhas(String tipoReg) {
        ArrayList<String> vetorLinhas = new ArrayList<String>();
        for (int i = 0; i < this.vectorDeclaracao.size(); ++i) {
            String linha = this.arquivo().get(i);
            if (linha.length() <= 0 || !tipoReg.equals("Default") && tipoReg.trim().length() != 0 && !tipoReg.equals(linha.substring(0, tipoReg.length()))) continue;
            vetorLinhas.add(linha);
        }
        return vetorLinhas;
    }

    protected void incluirLinhas(List<String> linhas) {
        for (int i = 0; i < linhas.size(); ++i) {
            this.arquivo().add(UtilitariosString.retiraCaracteresEspeciais((String)linhas.get(i)));
        }
        this.fAlterado = true;
    }

    protected abstract List<String> transformarObjDaDeclaracaoEmRegistroTXT(List<RegistroTxt> var1) throws GeracaoTxtException;

    protected abstract List<RegistroTxt> transformarRegistroTXTEmObjDaDeclaracao(List<String> var1, String var2, String var3) throws GeracaoTxtException;

    public List<String> arquivo() {
        return this.vectorDeclaracao;
    }

    public void setTipoArquivo(String tipoArquivo) {
        this.fTipoArquivo = tipoArquivo;
    }

    public String getTipoArquivo() {
        return this.fTipoArquivo;
    }

    public List<RegistroTxt> getRegistrosTxt(String tipoReg) throws GeracaoTxtException {
        List<String> linhas = this.lerLinhas(tipoReg);
        List<RegistroTxt> ficha = this.transformarRegistroTXTEmObjDaDeclaracao(linhas, this.getTipoArquivo(), tipoReg);
        return ficha;
    }

    public void atualizarRegistros(int pos, RegistroTxt pReg) throws GeracaoTxtException {
        this.arquivo().set(pos, pReg.getLinha());
    }

    protected void antesDeAtualizarRegistros(String pTipoReg, RegistroTxt pReg) {
    }

    public void setObjetosDaDeclaracao(List<RegistroTxt> objetos) throws GeracaoTxtException {
        List<String> linhas = this.transformarObjDaDeclaracaoEmRegistroTXT(objetos);
    }

    public String getPath() {
        return this.fPath;
    }

    public void setAlterado() {
        this.fAlterado = true;
    }

    public void setUpper() {
        this.setAlterado();
        for (int i = 0; i < this.vectorDeclaracao.size(); ++i) {
            this.vectorDeclaracao.set(i, UtilitariosString.retiraCaracteresEspeciais((String)this.vectorDeclaracao.get(i)));
        }
    }

    public void setBKPno() {
        this.fBKP = false;
    }

    public void salvar() throws IOException {
        char[] CRLF = new char[]{'\r', '\n'};
        String strCRLF = new String(CRLF);
        if (this.fAlterado) {
            try {
                File arquivo = new File(this.fPath);
                if (arquivo.exists()) {
                    File arquivoBkp = new File(this.fPath.substring(0, this.fPath.lastIndexOf(".")) + ".BAK");
                    if (arquivoBkp.exists()) {
                        arquivoBkp.delete();
                    }
                    if (!this.fBKP) {
                        arquivo.delete();
                    } else if (!arquivo.renameTo(arquivoBkp)) {
                        throw new IOException("Erro na c\u00ef\u00bf\u00bdpia do arquivo de gravacao.");
                    }
                }
                BufferedWriter arqDeclaracao = new BufferedWriter(new FileWriter(arquivo));
                for (int i = 0; i < this.vectorDeclaracao.size(); ++i) {
                    arqDeclaracao.write(this.vectorDeclaracao.get(i) + strCRLF);
                }
                try {
                    arqDeclaracao.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IOException("Erro ao gravar arquivo - " + this.fPath);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (e instanceof FileNotFoundException) {
                    throw new FileNotFoundException("Erro ao gravar arquivo - " + this.fPath);
                }
                throw new IOException("Erro ao gravar arquivo - " + this.fPath);
            }
        }
    }

    public void ler() throws IOException {
        try {
            BufferedReader arqDeclaracao = new BufferedReader(new FileReader(this.fPath));
            boolean eof = false;
            while (!eof) {
                String linha = arqDeclaracao.readLine();
                if (linha != null && linha.length() > 0) {
                    this.vectorDeclaracao.add(linha);
                    continue;
                }
                eof = true;
            }
            arqDeclaracao.close();
        }
        catch (IOException e) {
            throw new IOException("Erro ao ler arquivo - " + this.fPath);
        }
    }

    public void clear() {
        this.vectorDeclaracao.clear();
    }

    public void setFicha(List<RegistroTxt> ficha) throws GeracaoTxtException {
        String ultRegistro = "";
        boolean numRegistros = false;
        List<String> linhas = this.transformarObjDaDeclaracaoEmRegistroTXT(ficha);
        if (linhas.size() > 0) {
            this.incluirLinhas(linhas);
        }
    }
}

