/*
 * Decompiled with CFR 0.152.
 */
package jupar.parsers;

import jupar.objects.Release;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReleaseXMLParserHandler
extends DefaultHandler {
    private String currentelement = "";
    private String currentFileId = "";
    private StringBuilder value = null;
    private Release releaseinfo = new Release();

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        this.currentelement = qName;
        this.value = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String value = String.copyValueOf(ch, start, length).trim();
        if (value != null && value.length() > 0) {
            this.value.append(value);
        }
    }

    public Release getInfo() {
        return this.releaseinfo;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.value != null && this.value.length() > 0) {
            String value = this.value.toString();
            if (this.currentelement.equals("pubDate")) {
                this.releaseinfo.setPubDate(value);
            } else if (this.currentelement.equals("pkgver")) {
                this.releaseinfo.setPkgver(value);
            } else if (this.currentelement.equals("pkgrel")) {
                this.releaseinfo.setPkgrel(value);
            } else if (this.currentelement.equals("severity")) {
                this.releaseinfo.setSeverity(value);
            } else if (this.currentelement.equals("message")) {
                this.releaseinfo.setMessage(value);
            } else if (this.currentelement.equals("fileId")) {
                this.currentFileId = value;
                Release.FileInfo fileInfo = this.releaseinfo.new Release.FileInfo();
                fileInfo.setId(this.currentFileId);
                this.releaseinfo.getFiles().put(this.currentFileId, fileInfo);
            } else if (this.currentelement.equals("fileVersion")) {
                this.releaseinfo.getFiles().get(this.currentFileId).setVersion(value);
            } else if (this.currentelement.equals("fileHash")) {
                this.releaseinfo.getFiles().get(this.currentFileId).setHash(value);
            } else if (this.currentelement.equals("filePath")) {
                this.releaseinfo.getFiles().get(this.currentFileId).setPath(value);
            } else if (this.currentelement.equals("filePackageName")) {
                this.releaseinfo.getFiles().get(this.currentFileId).setPackName(value);
            }
        }
        this.currentelement = "";
    }
}

